/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarlakxen.embedphantomjs;

import com.github.jarlakxen.embedphantomjs.Version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class PhantomJSReference {
    private static final Logger LOGGER = Logger.getLogger(PhantomJSReference.class);
    public static final String PHANTOMJS_NATIVE_CMD = "/usr/bin/phantomjs";
    public static final String PHANTOMJS_DATA_FILE = "phantomjs/data.properties";
    public static final String PHANTOMJS_DOWNLOAD_BINARY_PATH = "/bin/phantomjs";
    private Version version;
    private String architecture;
    private String hostOs;
    private String downloadUrl;
    private String targetInstallationFolder;
    private String binaryPath;
    private String commandLineOptions;

    public static PhantomJSReferenceBuilder create() {
        return new PhantomJSReferenceBuilder();
    }

    private PhantomJSReference(PhantomJSReferenceBuilder builder) {
        this.version = builder.version;
        this.architecture = builder.architecture;
        this.hostOs = builder.hostOs;
        this.downloadUrl = builder.downloadUrl;
        this.targetInstallationFolder = builder.targetInstallationFolder;
        this.commandLineOptions = builder.commandLineOptions == null ? "" : builder.commandLineOptions;
    }

    public String getBinaryPath() {
        if (this.binaryPath == null) {
            this.ensureBinary();
        }
        return this.binaryPath;
    }

    public synchronized void ensureBinary() {
        if (this.binaryPath != null) {
            return;
        }
        if (Version.NATIVE.equals((Object)this.version)) {
            LOGGER.debug((Object)"Checking PhantomJS native installation");
            if (this.checkPhantomJSBinaryAnyVersion(PHANTOMJS_NATIVE_CMD).booleanValue()) {
                LOGGER.debug((Object)"Native installation founded");
                this.binaryPath = PHANTOMJS_NATIVE_CMD;
                return;
            }
            throw new RuntimeException("Invalid native installation!");
        }
        if (!this.getVersion().isDownloadSopported()) {
            throw new RuntimeException("Unsopported version for downloading!");
        }
        File binaryFile = new File(this.getTargetInstallationFolder() + "/" + this.getVersion().getDescription() + "/phantomjs");
        String binaryFilePath = binaryFile.getAbsolutePath();
        LOGGER.debug((Object)("Checking PhantomJS installation in " + binaryFilePath));
        if (this.checkPhantomJSBinaryVersion(binaryFilePath, this.getVersion()).booleanValue()) {
            LOGGER.debug((Object)("PhantomJS founded in " + binaryFilePath));
            this.binaryPath = binaryFilePath;
        } else {
            LOGGER.debug((Object)("PhantomJS not founded in " + binaryFilePath));
            try {
                this.downloadPhantomJS(binaryFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!this.checkPhantomJSBinaryVersion(binaryFilePath, this.getVersion()).booleanValue()) {
                throw new RuntimeException("Invalid download");
            }
            this.binaryPath = binaryFilePath;
        }
    }

    public String getCommandLineOptions() {
        return this.commandLineOptions;
    }

    private void downloadPhantomJS(File binaryFile) throws IOException {
        ArchiveEntry entry;
        Properties properties = new Properties();
        properties.load(this.getClass().getClassLoader().getResourceAsStream(PHANTOMJS_DATA_FILE));
        String name = properties.getProperty(this.getVersion().getDescription() + "." + this.getHostOs() + ".name");
        String architecture = this.getArchitecture().indexOf("64") >= 0 ? "x86_64" : "i686";
        LOGGER.debug((Object)("System Data: Arch [" + architecture + "] - OS [" + this.getHostOs() + "]"));
        if (this.getHostOs().equals("linux")) {
            name = String.format(name, architecture);
        }
        URL downloadPath = new URL(this.getDownloadUrl() + name);
        File phantomJsCompressedFile = new File(System.getProperty("java.io.tmpdir") + "/" + name);
        LOGGER.info((Object)("Downloading " + downloadPath.getPath() + " ..."));
        FileUtils.copyURLToFile((URL)downloadPath, (File)phantomJsCompressedFile);
        ZipArchiveInputStream archiveInputStream = null;
        if (phantomJsCompressedFile.getName().endsWith(".zip")) {
            archiveInputStream = new ZipArchiveInputStream((InputStream)new FileInputStream(phantomJsCompressedFile));
        } else if (phantomJsCompressedFile.getName().endsWith(".bz2")) {
            archiveInputStream = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(phantomJsCompressedFile)));
        } else if (phantomJsCompressedFile.getName().endsWith(".gz")) {
            archiveInputStream = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(phantomJsCompressedFile)));
        }
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            if (!entry.getName().endsWith(PHANTOMJS_DOWNLOAD_BINARY_PATH) && !entry.getName().toLowerCase().endsWith("phantomjs.exe")) continue;
            new File(this.getTargetInstallationFolder() + "/" + this.getVersion().getDescription()).mkdirs();
            FileUtils.forceMkdir((File)new File(binaryFile.getParent()));
            if (!binaryFile.exists()) {
                binaryFile.createNewFile();
            }
            binaryFile.setExecutable(true);
            binaryFile.setReadable(true);
            FileOutputStream outputBinary = new FileOutputStream(binaryFile);
            LOGGER.info((Object)("Un-compress download to " + downloadPath.getPath() + " ..."));
            IOUtils.copy((InputStream)archiveInputStream, (OutputStream)outputBinary);
            outputBinary.close();
        }
        archiveInputStream.close();
    }

    private String checkPhantomJSBinary(String path) {
        try {
            Process process = Runtime.getRuntime().exec(path + " --version");
            process.waitFor();
            String processOutput = IOUtils.toString((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
            return processOutput.substring(0, 5);
        }
        catch (Exception e) {
            LOGGER.warn((Object)e);
            return null;
        }
    }

    private Boolean checkPhantomJSBinaryAnyVersion(String path) {
        String outputVersion = this.checkPhantomJSBinary(path);
        return Version.fromValue(outputVersion) != null;
    }

    private Boolean checkPhantomJSBinaryVersion(String path, Version version) {
        String outputVersion = this.checkPhantomJSBinary(path);
        return version.getDescription().equals(outputVersion);
    }

    public Version getVersion() {
        return this.version;
    }

    public String getHostOs() {
        return this.hostOs;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getTargetInstallationFolder() {
        return this.targetInstallationFolder;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static class PhantomJSReferenceBuilder {
        private Version version = Version.v_2_1_1;
        private String architecture = System.getProperty("os.arch").toLowerCase();
        private String hostOs;
        private String downloadUrl = "https://bitbucket.org/ariya/phantomjs/downloads/";
        private String targetInstallationFolder = System.getProperty("user.home") + "/.embedphantomjs";
        private String commandLineOptions;

        public PhantomJSReferenceBuilder withVersion(Version version) {
            this.version = version;
            return this;
        }

        public PhantomJSReferenceBuilder withArchitecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public PhantomJSReferenceBuilder withHostOS(String hostOs) {
            this.hostOs = hostOs;
            return this;
        }

        public PhantomJSReferenceBuilder useDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public PhantomJSReferenceBuilder addCommandLineOptions(String ... commandLineOptions) {
            this.commandLineOptions = StringUtils.join((Object[])commandLineOptions, (String)" ");
            return this;
        }

        public PhantomJSReferenceBuilder useTargetInstallationFolder(String targetInstallationFolder) {
            this.targetInstallationFolder = targetInstallationFolder;
            return this;
        }

        public PhantomJSReference build() {
            return new PhantomJSReference(this);
        }

        public PhantomJSReferenceBuilder() {
            String os = System.getProperty("os.name").toLowerCase();
            this.hostOs = os.contains("win") ? "win" : (os.contains("mac") ? "macosx" : "linux");
        }
    }
}

