/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.models.errors.ErrorResponse;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;

public class ErrorUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private ErrorUtils() {
    }

    public static ErrorResponse parseErrorResponse(ResponseBody errorResponse) throws IOException {
        return (ErrorResponse)MAPPER.readValue(errorResponse.bytes(), ErrorResponse.class);
    }

    public static ErrorResponse parseError(JsonNode errorResponse) throws JsonProcessingException {
        return (ErrorResponse)MAPPER.treeToValue((TreeNode)errorResponse, ErrorResponse.class);
    }

    static {
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

