/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.jasminb.jsonapi.ReflectionUtils;
import com.github.jasminb.jsonapi.RelationshipResolver;
import com.github.jasminb.jsonapi.ValidationUtils;
import com.github.jasminb.jsonapi.annotations.Id;
import com.github.jasminb.jsonapi.annotations.Relationship;
import com.github.jasminb.jsonapi.annotations.Type;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResourceConverter {
    private static final Map<String, Class<?>> TYPE_TO_CLASS_MAPPING = new HashMap();
    private static final Map<Class<?>, Type> TYPE_ANNOTATIONS = new HashMap();
    private static final Map<Class<?>, Field> ID_MAP = new HashMap();
    private static final Map<Class<?>, List<Field>> RELATIONSHIPS_MAP = new HashMap();
    private static final Map<Class<?>, Map<String, Class<?>>> RELATIONSHIP_TYPE_MAP = new HashMap();
    private static final Map<Class<?>, Map<String, Field>> RELATIONSHIP_FIELD_MAP = new HashMap();
    private ObjectMapper objectMapper;
    private RelationshipResolver globalResolver;
    private Map<Class<?>, RelationshipResolver> typedResolvers = new HashMap();

    public ResourceConverter(Class<?> ... classes) {
        this((ObjectMapper)null, classes);
    }

    public ResourceConverter(ObjectMapper mapper, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            List<Field> idAnnotatedFields;
            if (clazz.isAnnotationPresent(Type.class)) {
                Type annotation = clazz.getAnnotation(Type.class);
                TYPE_TO_CLASS_MAPPING.put(annotation.value(), clazz);
                TYPE_ANNOTATIONS.put(clazz, annotation);
                RELATIONSHIP_TYPE_MAP.put(clazz, new HashMap());
                RELATIONSHIP_FIELD_MAP.put(clazz, new HashMap());
                List<Field> relationshipFields = ReflectionUtils.getAnnotatedFields(clazz, Relationship.class);
                for (Field relationshipField : relationshipFields) {
                    relationshipField.setAccessible(true);
                    Relationship relationship = relationshipField.getAnnotation(Relationship.class);
                    Class<?> targetType = ReflectionUtils.getRelationshipType(relationshipField);
                    RELATIONSHIP_TYPE_MAP.get(clazz).put(relationship.value(), targetType);
                    RELATIONSHIP_FIELD_MAP.get(clazz).put(relationship.value(), relationshipField);
                }
                RELATIONSHIPS_MAP.put(clazz, relationshipFields);
                idAnnotatedFields = ReflectionUtils.getAnnotatedFields(clazz, Id.class);
                if (idAnnotatedFields.isEmpty()) {
                    throw new IllegalArgumentException("All resource classes must have a field annotated with the @Id annotation");
                }
            } else {
                throw new IllegalArgumentException("All resource classes must be annotated with Type annotation!");
            }
            Field idField = idAnnotatedFields.get(0);
            idField.setAccessible(true);
            ID_MAP.put(clazz, idField);
        }
        this.objectMapper = mapper != null ? mapper : new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public void setGlobalResolver(RelationshipResolver resolver) {
        this.globalResolver = resolver;
    }

    public void setTypeResolver(RelationshipResolver resolver, Class<?> type) {
        String typeName;
        if (resolver != null && (typeName = ReflectionUtils.getTypeName(type)) != null) {
            this.typedResolvers.put(type, resolver);
        }
    }

    public <T> T readObject(byte[] data, Class<T> clazz) {
        try {
            JsonNode rootNode = this.objectMapper.readTree(data);
            ValidationUtils.ensureNotError(rootNode);
            ValidationUtils.ensureObject(rootNode);
            Map<String, Object> included = this.parseIncluded(rootNode);
            JsonNode dataNode = rootNode.get("data");
            T result = this.readObject(dataNode, clazz, included);
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> readObjectCollection(byte[] data, Class<T> clazz) {
        try {
            JsonNode rootNode = this.objectMapper.readTree(data);
            ValidationUtils.ensureNotError(rootNode);
            ValidationUtils.ensureCollection(rootNode);
            Map<String, Object> included = this.parseIncluded(rootNode);
            ArrayList<T> result = new ArrayList<T>();
            for (JsonNode element : rootNode.get("data")) {
                T pojo = this.readObject(element, clazz, included);
                result.add(pojo);
            }
            return result;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T readObject(JsonNode source, Class<T> clazz, Map<String, Object> cache) throws IOException, IllegalAccessException, InstantiationException {
        Object result = source.has("attributes") ? this.objectMapper.treeToValue((TreeNode)source.get("attributes"), clazz) : clazz.newInstance();
        this.setIdValue(result, source.get("id"));
        if (cache != null) {
            this.handleRelationships(source, result, cache);
            cache.put(this.createIdentifier(source), result);
        }
        return result;
    }

    private Map<String, Object> parseIncluded(JsonNode parent) throws IOException, IllegalAccessException, InstantiationException {
        List<Resource> includedResources;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (parent.has("included") && !(includedResources = this.getIncludedResources(parent)).isEmpty()) {
            for (Resource includedResource : includedResources) {
                result.put(includedResource.getIdentifier(), includedResource.getObject());
            }
            ArrayNode includedArray = (ArrayNode)parent.get("included");
            for (int i = 0; i < includedResources.size(); ++i) {
                Resource resource = includedResources.get(i);
                JsonNode node = includedArray.get(i);
                this.handleRelationships(node, resource.getObject(), result);
            }
        }
        return result;
    }

    private List<Resource> getIncludedResources(JsonNode parent) throws IOException, IllegalAccessException, InstantiationException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (parent.has("included")) {
            for (JsonNode jsonNode : parent.get("included")) {
                Class<?> clazz;
                String type = jsonNode.get("type").asText();
                if (type == null || (clazz = TYPE_TO_CLASS_MAPPING.get(type)) == null) continue;
                Object object = this.readObject(jsonNode, clazz, null);
                result.add(new Resource(this.createIdentifier(jsonNode), object));
            }
        }
        return result;
    }

    private void handleRelationships(JsonNode source, Object object, Map<String, Object> includedData) throws IllegalAccessException, IOException, InstantiationException {
        JsonNode relationships = source.get("relationships");
        if (relationships != null) {
            Iterator fields = relationships.fieldNames();
            while (fields.hasNext()) {
                Class<?> type;
                String field = (String)fields.next();
                JsonNode relationship = relationships.get(field);
                Field relationshipField = RELATIONSHIP_FIELD_MAP.get(object.getClass()).get(field);
                if (relationshipField == null || (type = RELATIONSHIP_TYPE_MAP.get(object.getClass()).get(field)) == null) continue;
                boolean resolveRelationship = relationshipField.getAnnotation(Relationship.class).resolve();
                RelationshipResolver resolver = this.getResolver(type);
                if (resolveRelationship && resolver != null && relationship.has("links")) {
                    JsonNode self = relationship.get("links").get("self");
                    if (self == null) continue;
                    String selfLink = self.asText();
                    if (this.isCollection(relationship)) {
                        relationshipField.set(object, this.readObjectCollection(resolver.resolve(selfLink), type));
                        continue;
                    }
                    relationshipField.set(object, this.readObject(resolver.resolve(selfLink), type));
                    continue;
                }
                if (this.isCollection(relationship)) {
                    ArrayList<Object> elements = new ArrayList<Object>();
                    for (JsonNode element : relationship.get("data")) {
                        Object relationshipObject = this.parseRelationship(element, type, includedData);
                        if (relationshipObject == null) continue;
                        elements.add(relationshipObject);
                    }
                    relationshipField.set(object, elements);
                    continue;
                }
                Object relationshipObject = this.parseRelationship(relationship.get("data"), type, includedData);
                if (relationshipObject == null) continue;
                relationshipField.set(object, relationshipObject);
            }
        }
    }

    private Object parseRelationship(JsonNode relationshipDataNode, Class<?> type, Map<String, Object> cache) throws IOException, IllegalAccessException, InstantiationException {
        if (ValidationUtils.isRelationshipParsable(relationshipDataNode)) {
            String identifier = this.createIdentifier(relationshipDataNode);
            if (cache.containsKey(identifier)) {
                return cache.get(identifier);
            }
            return this.readObject(relationshipDataNode, type, cache);
        }
        return null;
    }

    private String createIdentifier(JsonNode object) {
        String id = object.get("id").asText();
        String type = object.get("type").asText();
        return type.concat(id.toString());
    }

    private void setIdValue(Object target, JsonNode idValue) throws IllegalAccessException {
        Field idField = ID_MAP.get(target.getClass());
        idField.set(target, idValue.asText());
    }

    private boolean isCollection(JsonNode source) {
        JsonNode data = source.get("data");
        return data != null && data.isArray();
    }

    public byte[] writeObject(Object object) throws JsonProcessingException, IllegalAccessException {
        ObjectNode result = this.objectMapper.createObjectNode();
        ObjectNode attributesNode = (ObjectNode)this.objectMapper.valueToTree(object);
        Field idField = ID_MAP.get(object.getClass());
        attributesNode.remove(idField.getName());
        ObjectNode dataNode = this.objectMapper.createObjectNode();
        dataNode.put("type", TYPE_ANNOTATIONS.get(object.getClass()).value());
        String resourceId = (String)idField.get(object);
        if (resourceId != null) {
            dataNode.put("id", resourceId);
        }
        dataNode.set("attributes", (JsonNode)attributesNode);
        result.set("data", (JsonNode)dataNode);
        List<Field> relationshipFields = RELATIONSHIPS_MAP.get(object.getClass());
        if (relationshipFields != null) {
            ObjectNode relationshipsNode = this.objectMapper.createObjectNode();
            for (Field relationshipField : relationshipFields) {
                Object relationshipObject = relationshipField.get(object);
                if (relationshipObject == null) continue;
                attributesNode.remove(relationshipField.getName());
                Relationship relationship = relationshipField.getAnnotation(Relationship.class);
                if (!relationship.serialise()) continue;
                String relationshipName = relationship.value();
                if (relationshipObject instanceof List) {
                    ArrayNode dataArrayNode = this.objectMapper.createArrayNode();
                    for (Object element : (List)relationshipObject) {
                        String relationshipType = TYPE_ANNOTATIONS.get(element.getClass()).value();
                        String idValue = (String)ID_MAP.get(element.getClass()).get(element);
                        ObjectNode identifierNode = this.objectMapper.createObjectNode();
                        identifierNode.put("type", relationshipType);
                        identifierNode.put("id", idValue);
                        dataArrayNode.add((JsonNode)identifierNode);
                    }
                    ObjectNode relationshipDataNode = this.objectMapper.createObjectNode();
                    relationshipDataNode.set("data", (JsonNode)dataArrayNode);
                    relationshipsNode.set(relationshipName, (JsonNode)relationshipDataNode);
                    continue;
                }
                String relationshipType = TYPE_ANNOTATIONS.get(relationshipObject.getClass()).value();
                String idValue = (String)ID_MAP.get(relationshipObject.getClass()).get(relationshipObject);
                ObjectNode identifierNode = this.objectMapper.createObjectNode();
                identifierNode.put("type", relationshipType);
                identifierNode.put("id", idValue);
                ObjectNode relationshipDataNode = this.objectMapper.createObjectNode();
                relationshipDataNode.set("data", (JsonNode)identifierNode);
                relationshipsNode.set(relationshipName, (JsonNode)relationshipDataNode);
            }
            if (relationshipsNode.size() > 0) {
                dataNode.set("relationships", (JsonNode)relationshipsNode);
            }
        }
        return this.objectMapper.writeValueAsBytes((Object)result);
    }

    public boolean isRegisteredType(Class<?> type) {
        return TYPE_ANNOTATIONS.containsKey(type);
    }

    private RelationshipResolver getResolver(Class<?> type) {
        RelationshipResolver resolver = this.typedResolvers.get(type);
        return resolver != null ? resolver : this.globalResolver;
    }

    private static class Resource {
        private String identifier;
        private Object object;

        public Resource(String identifier, Object resource) {
            this.identifier = identifier;
            this.object = resource;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

