/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.jasminb.jsonapi.ErrorUtils;
import com.github.jasminb.jsonapi.exceptions.ResourceParseException;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static void ensureCollection(JsonNode resource) {
        if (!ValidationUtils.ensureDataNode(resource).isArray()) {
            throw new IllegalArgumentException("'data' node is not an array!");
        }
    }

    public static void ensureObject(JsonNode resource) {
        if (ValidationUtils.ensureDataNode(resource).isArray()) {
            throw new IllegalArgumentException("'data' node is not an object!");
        }
    }

    public static boolean isRelationshipParsable(JsonNode dataNode) {
        return dataNode != null && dataNode.hasNonNull("id") && dataNode.hasNonNull("type") && !dataNode.get("id").isContainerNode() && !dataNode.get("type").isContainerNode();
    }

    public static void ensureNotError(JsonNode resourceNode) {
        if (resourceNode != null && resourceNode.hasNonNull("errors")) {
            try {
                throw new ResourceParseException(ErrorUtils.parseError(resourceNode));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static JsonNode ensureDataNode(JsonNode resource) {
        JsonNode dataNode = resource.get("data");
        if (dataNode == null) {
            throw new IllegalArgumentException("Object is missing 'data' node!");
        }
        if (!dataNode.isContainerNode()) {
            throw new IllegalArgumentException("'data' node cannot be simple attribute!");
        }
        return dataNode;
    }
}

