/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi.retrofit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.ResourceConverter;
import com.github.jasminb.jsonapi.retrofit.JSONAPIRequestBodyConverter;
import com.github.jasminb.jsonapi.retrofit.JSONAPIResponseBodyConverter;
import com.github.jasminb.jsonapi.retrofit.RetrofitType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ResponseBody;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit.Converter;

public class JSONAPIConverterFactory
extends Converter.Factory {
    private ResourceConverter parser;
    private Converter.Factory alternativeFactory;

    public JSONAPIConverterFactory(ResourceConverter parser) {
        this.parser = parser;
    }

    public JSONAPIConverterFactory(ObjectMapper mapper, Class<?> ... classes) {
        this.parser = new ResourceConverter(mapper, classes);
    }

    public void setAlternativeFactory(Converter.Factory alternativeFactory) {
        this.alternativeFactory = alternativeFactory;
    }

    public Converter<ResponseBody, ?> fromResponseBody(Type type, Annotation[] annotations) {
        RetrofitType retrofitType = new RetrofitType(type);
        if (retrofitType.isValid() && this.parser.isRegisteredType(retrofitType.getType())) {
            if (retrofitType.isCollection()) {
                return new JSONAPIResponseBodyConverter(this.parser, retrofitType.getType(), true);
            }
            return new JSONAPIResponseBodyConverter(this.parser, retrofitType.getType(), false);
        }
        if (this.alternativeFactory != null) {
            return this.alternativeFactory.fromResponseBody(type, annotations);
        }
        return null;
    }

    public Converter<?, RequestBody> toRequestBody(Type type, Annotation[] annotations) {
        RetrofitType retrofitType = new RetrofitType(type);
        if (retrofitType.isValid() && this.parser.isRegisteredType(retrofitType.getType())) {
            return new JSONAPIRequestBodyConverter(this.parser);
        }
        if (this.alternativeFactory != null) {
            return this.alternativeFactory.toRequestBody(type, annotations);
        }
        return null;
    }
}

