/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.github.jasminb.jsonapi.annotations.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static List<Field> getAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotation, boolean checkSuperclass) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(annotation)) continue;
            result.add(field);
        }
        if (checkSuperclass && clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
            result.addAll(ReflectionUtils.getAnnotatedFields(clazz.getSuperclass(), annotation, true));
        }
        return result;
    }

    public static String getTypeName(Class<?> clazz) {
        Type typeAnnotation = clazz.getAnnotation(Type.class);
        return typeAnnotation != null ? typeAnnotation.value() : null;
    }

    public static Class<?> getFieldType(Field field) {
        Class targetType = field.getType();
        if (targetType.equals(List.class)) {
            ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
            targetType = (Class)stringListType.getActualTypeArguments()[0];
        }
        return targetType;
    }
}

