/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.jasminb.jsonapi.ConverterConfiguration;
import com.github.jasminb.jsonapi.DeserializationFeature;
import com.github.jasminb.jsonapi.JSONAPIDocument;
import com.github.jasminb.jsonapi.Link;
import com.github.jasminb.jsonapi.Links;
import com.github.jasminb.jsonapi.ReflectionUtils;
import com.github.jasminb.jsonapi.RelationshipResolver;
import com.github.jasminb.jsonapi.ResourceCache;
import com.github.jasminb.jsonapi.SerializationFeature;
import com.github.jasminb.jsonapi.ValidationUtils;
import com.github.jasminb.jsonapi.annotations.Relationship;
import com.github.jasminb.jsonapi.exceptions.DocumentSerializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceConverter {
    private final ConverterConfiguration configuration;
    private final ObjectMapper objectMapper;
    private final Map<Class<?>, RelationshipResolver> typedResolvers = new HashMap();
    private final ResourceCache resourceCache;
    private final Set<DeserializationFeature> deserializationFeatures = DeserializationFeature.getDefaultFeatures();
    private final Set<SerializationFeature> serializationFeatures = SerializationFeature.getDefaultFeatures();
    private RelationshipResolver globalResolver;

    public ResourceConverter(Class<?> ... classes) {
        this((ObjectMapper)null, classes);
    }

    public ResourceConverter(ObjectMapper mapper, Class<?> ... classes) {
        this.configuration = new ConverterConfiguration(classes);
        this.objectMapper = mapper != null ? mapper : new ObjectMapper();
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.resourceCache = new ResourceCache();
    }

    public void setGlobalResolver(RelationshipResolver resolver) {
        this.globalResolver = resolver;
    }

    public void setTypeResolver(RelationshipResolver resolver, Class<?> type) {
        String typeName;
        if (resolver != null && (typeName = ReflectionUtils.getTypeName(type)) != null) {
            this.typedResolvers.put(type, resolver);
        }
    }

    @Deprecated
    public <T> T readObject(byte[] data, Class<T> clazz) {
        return this.readDocument(data, clazz).get();
    }

    @Deprecated
    public <T> List<T> readObjectCollection(byte[] data, Class<T> clazz) {
        return this.readDocumentCollection(data, clazz).get();
    }

    public <T> JSONAPIDocument<T> readDocument(byte[] data, Class<T> clazz) {
        return this.readDocument(new ByteArrayInputStream(data), clazz);
    }

    public <T> JSONAPIDocument<T> readDocument(InputStream dataStream, Class<T> clazz) {
        try {
            JSONAPIDocument result;
            this.resourceCache.init();
            JsonNode rootNode = this.objectMapper.readTree(dataStream);
            ValidationUtils.ensureNotError(this.objectMapper, rootNode);
            ValidationUtils.ensureObject(rootNode);
            this.resourceCache.cache(this.parseIncluded(rootNode));
            JsonNode dataNode = rootNode.get("data");
            if (!dataNode.isNull()) {
                T resourceObject = this.readObject(dataNode, clazz, true);
                result = new JSONAPIDocument<T>(resourceObject, this.objectMapper);
            } else {
                result = new JSONAPIDocument();
            }
            if (rootNode.has("meta")) {
                result.setMeta(this.mapMeta(rootNode.get("meta")));
            }
            if (rootNode.has("links")) {
                result.setLinks(new Links(this.mapLinks(rootNode.get("links"))));
            }
            JSONAPIDocument jSONAPIDocument = result;
            return jSONAPIDocument;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.resourceCache.clear();
        }
    }

    public <T> JSONAPIDocument<List<T>> readDocumentCollection(byte[] data, Class<T> clazz) {
        return this.readDocumentCollection(new ByteArrayInputStream(data), clazz);
    }

    public <T> JSONAPIDocument<List<T>> readDocumentCollection(InputStream dataStream, Class<T> clazz) {
        try {
            this.resourceCache.init();
            JsonNode rootNode = this.objectMapper.readTree(dataStream);
            ValidationUtils.ensureNotError(this.objectMapper, rootNode);
            ValidationUtils.ensureCollection(rootNode);
            this.resourceCache.cache(this.parseIncluded(rootNode));
            ArrayList<T> resourceList = new ArrayList<T>();
            for (JsonNode element : rootNode.get("data")) {
                T pojo = this.readObject(element, clazz, true);
                resourceList.add(pojo);
            }
            JSONAPIDocument<List<T>> result = new JSONAPIDocument<List<T>>(resourceList, this.objectMapper);
            if (rootNode.has("meta")) {
                result.setMeta(this.mapMeta(rootNode.get("meta")));
            }
            if (rootNode.has("links")) {
                result.setLinks(new Links(this.mapLinks(rootNode.get("links"))));
            }
            JSONAPIDocument<List<T>> jSONAPIDocument = result;
            return jSONAPIDocument;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.resourceCache.clear();
        }
    }

    private <T> T readObject(JsonNode source, Class<T> clazz, boolean handleRelationships) throws IOException, IllegalAccessException, InstantiationException {
        String identifier = this.createIdentifier(source);
        Object result = this.resourceCache.get(identifier);
        if (result == null) {
            Field linkField;
            Field field;
            result = source.has("attributes") ? this.objectMapper.treeToValue((TreeNode)source.get("attributes"), clazz) : (clazz.isInterface() ? null : clazz.newInstance());
            if (source.has("meta") && (field = this.configuration.getMetaField(clazz)) != null) {
                Class<?> metaType = this.configuration.getMetaType(clazz);
                Object metaObject = this.objectMapper.treeToValue((TreeNode)source.get("meta"), metaType);
                field.set(result, metaObject);
            }
            if (source.has("links") && (linkField = this.configuration.getLinksField(clazz)) != null) {
                linkField.set(result, new Links(this.mapLinks(source.get("links"))));
            }
            if (result != null) {
                this.resourceCache.cache(identifier, result);
                this.setIdValue(result, source.get("id"));
                if (handleRelationships) {
                    this.handleRelationships(source, result);
                }
            }
        }
        return (T)result;
    }

    private Map<String, Object> parseIncluded(JsonNode parent) throws IOException, IllegalAccessException, InstantiationException {
        List<Resource> includedResources;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (parent.has("included") && !(includedResources = this.getIncludedResources(parent)).isEmpty()) {
            for (Resource includedResource : includedResources) {
                result.put(includedResource.getIdentifier(), includedResource.getObject());
            }
            ArrayNode includedArray = (ArrayNode)parent.get("included");
            for (int i = 0; i < includedResources.size(); ++i) {
                Resource resource = includedResources.get(i);
                JsonNode node = includedArray.get(i);
                this.handleRelationships(node, resource.getObject());
            }
        }
        return result;
    }

    private List<Resource> getIncludedResources(JsonNode parent) throws IOException, IllegalAccessException, InstantiationException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (parent.has("included")) {
            for (JsonNode jsonNode : parent.get("included")) {
                Object object;
                Class<?> clazz;
                String type = jsonNode.get("type").asText();
                if (type == null || (clazz = this.configuration.getTypeClass(type)) == null || (object = this.readObject(jsonNode, clazz, false)) == null) continue;
                result.add(new Resource(this.createIdentifier(jsonNode), object));
            }
        }
        return result;
    }

    private void handleRelationships(JsonNode source, Object object) throws IllegalAccessException, IOException, InstantiationException {
        JsonNode relationships = source.get("relationships");
        if (relationships != null) {
            Iterator fields = relationships.fieldNames();
            while (fields.hasNext()) {
                Class<?> type;
                String field = (String)fields.next();
                JsonNode relationship = relationships.get(field);
                Field relationshipField = this.configuration.getRelationshipField(object.getClass(), field);
                if (relationshipField == null || (type = this.configuration.getRelationshipType(object.getClass(), field)) == null) continue;
                boolean resolveRelationship = this.configuration.getFieldRelationship(relationshipField).resolve();
                RelationshipResolver resolver = this.getResolver(type);
                if (resolveRelationship && resolver != null && relationship.has("links")) {
                    String link;
                    String relType = this.configuration.getFieldRelationship(relationshipField).relType().getRelName();
                    JsonNode linkNode = relationship.get("links").get(relType);
                    if (linkNode == null || (link = this.getLink(linkNode)) == null) continue;
                    if (this.isCollection(relationship)) {
                        relationshipField.set(object, this.readDocumentCollection(new ByteArrayInputStream(resolver.resolve(link)), type).get());
                        continue;
                    }
                    relationshipField.set(object, this.readDocument(new ByteArrayInputStream(resolver.resolve(link)), type).get());
                    continue;
                }
                if (this.isCollection(relationship)) {
                    ArrayList<Object> elements = new ArrayList<Object>();
                    for (JsonNode element : relationship.get("data")) {
                        Object relationshipObject = this.parseRelationship(element, type);
                        if (relationshipObject == null) continue;
                        elements.add(relationshipObject);
                    }
                    relationshipField.set(object, elements);
                    continue;
                }
                Object relationshipObject = this.parseRelationship(relationship.get("data"), type);
                if (relationshipObject == null) continue;
                relationshipField.set(object, relationshipObject);
            }
        }
    }

    String getLink(JsonNode linkNode) {
        if (linkNode.has("href")) {
            return linkNode.get("href").asText();
        }
        return linkNode.asText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object parseRelationship(JsonNode relationshipDataNode, Class<?> type) throws IOException, IllegalAccessException, InstantiationException {
        if (ValidationUtils.isRelationshipParsable(relationshipDataNode)) {
            String identifier = this.createIdentifier(relationshipDataNode);
            if (this.resourceCache.contains(identifier)) {
                return this.resourceCache.get(identifier);
            }
            this.resourceCache.lock();
            try {
                Object obj = this.readObject(relationshipDataNode, type, true);
                return obj;
            }
            finally {
                this.resourceCache.unlock();
            }
        }
        return null;
    }

    private String createIdentifier(JsonNode object) {
        String id;
        JsonNode idNode = object.get("id");
        String string = id = idNode != null ? idNode.asText().trim() : "";
        if (id.isEmpty() && this.deserializationFeatures.contains((Object)DeserializationFeature.REQUIRE_RESOURCE_ID)) {
            throw new IllegalArgumentException("Resource must have an non null and non-empty 'id' attribute!");
        }
        String type = object.get("type").asText();
        return type.concat(id);
    }

    private void setIdValue(Object target, JsonNode idValue) throws IllegalAccessException {
        Field idField = this.configuration.getIdField(target.getClass());
        if (idValue != null) {
            idField.set(target, idValue.asText());
        }
    }

    private boolean isCollection(JsonNode source) {
        JsonNode data = source.get("data");
        return data != null && data.isArray();
    }

    @Deprecated
    public byte[] writeObject(Object object) throws JsonProcessingException, IllegalAccessException {
        HashMap<String, ObjectNode> includedDataMap = new HashMap<String, ObjectNode>();
        ObjectNode dataNode = this.getDataNode(object, includedDataMap);
        ObjectNode result = this.objectMapper.createObjectNode();
        result.set("data", (JsonNode)dataNode);
        result = this.addIncludedSection(result, includedDataMap);
        return this.objectMapper.writeValueAsBytes((Object)result);
    }

    public byte[] writeDocument(JSONAPIDocument<?> document) throws DocumentSerializationException {
        try {
            HashMap<String, ObjectNode> includedDataMap = new HashMap<String, ObjectNode>();
            ObjectNode dataNode = this.getDataNode(document.get(), includedDataMap);
            ObjectNode result = this.objectMapper.createObjectNode();
            result.set("data", (JsonNode)dataNode);
            result = this.addIncludedSection(result, includedDataMap);
            if (document.getMeta() != null && !document.getMeta().isEmpty() && this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_META)) {
                result.set("meta", this.objectMapper.valueToTree(document.getMeta()));
            }
            if (document.getLinks() != null && this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_LINKS)) {
                result.set("links", this.objectMapper.valueToTree((Object)document.getLinks()));
            }
            return this.objectMapper.writeValueAsBytes((Object)result);
        }
        catch (Exception e) {
            throw new DocumentSerializationException(e);
        }
    }

    private ObjectNode getDataNode(Object object, Map<String, ObjectNode> includedContainer) throws IllegalAccessException {
        JsonNode links;
        Field linksField;
        JsonNode meta;
        ObjectNode dataNode = this.objectMapper.createObjectNode();
        ObjectNode attributesNode = (ObjectNode)this.objectMapper.valueToTree(object);
        Field idField = this.configuration.getIdField(object.getClass());
        attributesNode.remove(idField.getName());
        Field metaField = this.configuration.getMetaField(object.getClass());
        if (metaField != null && (meta = attributesNode.remove(metaField.getName())) != null && this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_META)) {
            dataNode.set("meta", meta);
        }
        if ((linksField = this.configuration.getLinksField(object.getClass())) != null && (links = attributesNode.remove("links")) != null && this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_LINKS)) {
            dataNode.set("links", links);
        }
        dataNode.put("type", this.configuration.getTypeName(object.getClass()));
        String resourceId = (String)idField.get(object);
        if (resourceId != null) {
            dataNode.put("id", resourceId);
        }
        dataNode.set("attributes", (JsonNode)attributesNode);
        List<Field> relationshipFields = this.configuration.getRelationshipFields(object.getClass());
        if (relationshipFields != null) {
            ObjectNode relationshipsNode = this.objectMapper.createObjectNode();
            for (Field relationshipField : relationshipFields) {
                String identifier;
                Object relationshipObject = relationshipField.get(object);
                if (relationshipObject == null) continue;
                attributesNode.remove(relationshipField.getName());
                Relationship relationship = this.configuration.getFieldRelationship(relationshipField);
                if (!relationship.serialise()) continue;
                String relationshipName = relationship.value();
                if (relationshipObject instanceof List) {
                    ArrayNode dataArrayNode = this.objectMapper.createArrayNode();
                    for (Object element : (List)relationshipObject) {
                        String identifier2;
                        String relationshipType = this.configuration.getTypeName(element.getClass());
                        String idValue = (String)this.configuration.getIdField(element.getClass()).get(element);
                        ObjectNode identifierNode = this.objectMapper.createObjectNode();
                        identifierNode.put("type", relationshipType);
                        identifierNode.put("id", idValue);
                        dataArrayNode.add((JsonNode)identifierNode);
                        if (!this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_RELATIONSHIP_ATTRIBUTES) || idValue == null || includedContainer.containsKey(identifier2 = idValue.concat(relationshipType))) continue;
                        includedContainer.put(identifier2, this.getDataNode(element, includedContainer));
                    }
                    ObjectNode relationshipDataNode = this.objectMapper.createObjectNode();
                    relationshipDataNode.set("data", (JsonNode)dataArrayNode);
                    relationshipsNode.set(relationshipName, (JsonNode)relationshipDataNode);
                    continue;
                }
                String relationshipType = this.configuration.getTypeName(relationshipObject.getClass());
                String idValue = (String)this.configuration.getIdField(relationshipObject.getClass()).get(relationshipObject);
                ObjectNode identifierNode = this.objectMapper.createObjectNode();
                identifierNode.put("type", relationshipType);
                identifierNode.put("id", idValue);
                ObjectNode relationshipDataNode = this.objectMapper.createObjectNode();
                relationshipDataNode.set("data", (JsonNode)identifierNode);
                relationshipsNode.set(relationshipName, (JsonNode)relationshipDataNode);
                if (!this.serializationFeatures.contains((Object)SerializationFeature.INCLUDE_RELATIONSHIP_ATTRIBUTES) || idValue == null || includedContainer.containsKey(identifier = idValue.concat(relationshipType))) continue;
                includedContainer.put(identifier, this.getDataNode(relationshipObject, includedContainer));
            }
            if (relationshipsNode.size() > 0) {
                dataNode.set("relationships", (JsonNode)relationshipsNode);
            }
        }
        return dataNode;
    }

    public <T> byte[] writeObjectCollection(Iterable<T> objects) throws JsonProcessingException, IllegalAccessException {
        ArrayNode results = this.objectMapper.createArrayNode();
        HashMap<String, ObjectNode> includedDataMap = new HashMap<String, ObjectNode>();
        for (T object : objects) {
            results.add((JsonNode)this.getDataNode(object, includedDataMap));
        }
        ObjectNode result = this.objectMapper.createObjectNode();
        result.set("data", (JsonNode)results);
        result = this.addIncludedSection(result, includedDataMap);
        return this.objectMapper.writeValueAsBytes((Object)result);
    }

    public boolean isRegisteredType(Class<?> type) {
        return this.configuration.isRegisteredType(type);
    }

    private RelationshipResolver getResolver(Class<?> type) {
        RelationshipResolver resolver = this.typedResolvers.get(type);
        return resolver != null ? resolver : this.globalResolver;
    }

    private Map<String, Link> mapLinks(JsonNode linksObject) {
        HashMap<String, Link> result = new HashMap<String, Link>();
        Iterator linkItr = linksObject.fields();
        while (linkItr.hasNext()) {
            Map.Entry linkNode = (Map.Entry)linkItr.next();
            Link linkObj = new Link();
            linkObj.setHref(this.getLink((JsonNode)linkNode.getValue()));
            if (((JsonNode)linkNode.getValue()).has("meta")) {
                linkObj.setMeta(this.mapMeta(((JsonNode)linkNode.getValue()).get("meta")));
            }
            result.put((String)linkNode.getKey(), linkObj);
        }
        return result;
    }

    private Map<String, ?> mapMeta(JsonNode metaNode) {
        JsonParser p = this.objectMapper.treeAsTokens((TreeNode)metaNode);
        MapType mapType = TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class);
        try {
            return (Map)this.objectMapper.readValue(p, (JavaType)mapType);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private ObjectNode addIncludedSection(ObjectNode rootNode, Map<String, ObjectNode> includedDataMap) {
        if (!includedDataMap.isEmpty()) {
            ArrayNode includedArray = this.objectMapper.createArrayNode();
            includedArray.addAll(includedDataMap.values());
            rootNode.set("included", (JsonNode)includedArray);
        }
        return rootNode;
    }

    public void enableDeserializationOption(DeserializationFeature option) {
        this.deserializationFeatures.add(option);
    }

    public void disableDeserializationOption(DeserializationFeature option) {
        this.deserializationFeatures.remove((Object)option);
    }

    public void enableSerializationOption(SerializationFeature option) {
        this.serializationFeatures.add(option);
    }

    public void disableSerializationOption(SerializationFeature option) {
        this.serializationFeatures.remove((Object)option);
    }

    private static class Resource {
        private String identifier;
        private Object object;

        public Resource(String identifier, Object resource) {
            this.identifier = identifier;
            this.object = resource;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

