/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.Links;
import com.github.jasminb.jsonapi.models.errors.Error;
import java.util.HashMap;
import java.util.Map;

public class JSONAPIDocument<T> {
    private T data;
    private ObjectMapper deserializer;
    private Iterable<? extends Error> errors;
    private Links links;
    private Map<String, ?> meta;

    public JSONAPIDocument(T data) {
        this.data = data;
    }

    public JSONAPIDocument(T data, ObjectMapper deserializer) {
        this(data);
        this.deserializer = deserializer;
    }

    public JSONAPIDocument() {
    }

    public static JSONAPIDocument<?> createErrorDocument(Iterable<? extends Error> errors) {
        JSONAPIDocument result = new JSONAPIDocument();
        result.errors = errors;
        return result;
    }

    public T get() {
        return this.data;
    }

    public Map<String, ?> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, ?> meta) {
        this.meta = new HashMap(meta);
    }

    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public <T> T getMeta(Class<?> metaType) {
        if (this.meta != null && this.deserializer != null) {
            return (T)this.deserializer.convertValue(this.meta, metaType);
        }
        return null;
    }

    public Iterable<? extends Error> getErrors() {
        return this.errors;
    }
}

