/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasminb.jsonapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.ErrorUtils;
import com.github.jasminb.jsonapi.exceptions.InvalidJsonApiResourceException;
import com.github.jasminb.jsonapi.exceptions.ResourceParseException;
import com.github.jasminb.jsonapi.models.errors.Errors;

public class ValidationUtils {
    private ValidationUtils() {
    }

    public static void ensureValidResource(JsonNode resource) {
        if (!resource.has("data") && !resource.has("meta")) {
            throw new InvalidJsonApiResourceException();
        }
    }

    public static boolean isRelationshipParsable(JsonNode dataNode) {
        return dataNode != null && dataNode.hasNonNull("id") && dataNode.hasNonNull("type") && !dataNode.get("id").isContainerNode() && !dataNode.get("type").isContainerNode();
    }

    public static void ensureNotError(ObjectMapper mapper, JsonNode resourceNode) {
        if (resourceNode != null && resourceNode.hasNonNull("errors")) {
            try {
                throw new ResourceParseException(ErrorUtils.parseError(mapper, resourceNode, Errors.class));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

