/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.r2dbc.mysql;

import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nH\u0002J+\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ,\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J,\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0013\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J#\u0010\u0017\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/jasync/r2dbc/mysql/JasyncInsertSyntheticRow;", "Lio/r2dbc/spi/Row;", "generatedKeyName", "", "lastInsertId", "", "(Ljava/lang/String;J)V", "assertValidIdentifier", "", "identifier", "", "get", "T", "type", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "index", "", "(ILjava/lang/Class;)Ljava/lang/Object;", "name", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getMetadata", "Lio/r2dbc/spi/RowMetadata;", "getValue", "(Ljava/lang/Class;)Ljava/lang/Object;", "jasync-r2dbc-mysql"})
public final class JasyncInsertSyntheticRow
implements Row {
    @NotNull
    private final String generatedKeyName;
    private final long lastInsertId;

    public JasyncInsertSyntheticRow(@NotNull String generatedKeyName, long lastInsertId) {
        Intrinsics.checkNotNullParameter((Object)generatedKeyName, (String)"generatedKeyName");
        this.generatedKeyName = generatedKeyName;
        this.lastInsertId = lastInsertId;
    }

    @Nullable
    public <T> T get(int index, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.get((Object)index, type);
    }

    @Nullable
    public <T> T get(@NotNull String name, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return this.get((Object)name, type);
    }

    @NotNull
    public RowMetadata getMetadata() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final <T> T get(Object identifier, Class<T> type) {
        this.assertValidIdentifier(identifier);
        return this.getValue(type);
    }

    private final Object get(Object identifier) {
        this.assertValidIdentifier(identifier);
        return this.lastInsertId < 0L ? this.getValue(BigInteger.class) : this.getValue(Long.TYPE);
    }

    private final <T> T getValue(Class<T> type) {
        Comparable<Long> comparable;
        Class<T> clazz = type;
        if (Intrinsics.areEqual(clazz, Long.class) ? true : Intrinsics.areEqual(clazz, Long.TYPE)) {
            comparable = this.lastInsertId;
        } else if (Intrinsics.areEqual(clazz, Integer.class) ? true : Intrinsics.areEqual(clazz, Integer.TYPE)) {
            comparable = (int)this.lastInsertId;
        } else if (Intrinsics.areEqual(clazz, Float.class) ? true : Intrinsics.areEqual(clazz, Float.TYPE)) {
            comparable = Float.valueOf(this.lastInsertId);
        } else if (Intrinsics.areEqual(clazz, Double.class) ? true : Intrinsics.areEqual(clazz, Double.TYPE)) {
            comparable = this.lastInsertId;
        } else if (Intrinsics.areEqual(clazz, Character.class) ? true : Intrinsics.areEqual(clazz, Character.TYPE)) {
            comparable = Character.valueOf((char)this.lastInsertId);
        } else if (Intrinsics.areEqual(clazz, Short.class) ? true : Intrinsics.areEqual(clazz, Short.TYPE)) {
            comparable = (short)this.lastInsertId;
        } else if (Intrinsics.areEqual(clazz, Byte.class) ? true : Intrinsics.areEqual(clazz, Byte.TYPE)) {
            comparable = (byte)this.lastInsertId;
        } else if (Intrinsics.areEqual(clazz, BigDecimal.class)) {
            if (this.lastInsertId < 0L) {
                comparable = new BigDecimal(Long.toUnsignedString(this.lastInsertId));
            } else {
                BigDecimal bigDecimal = BigDecimal.valueOf(this.lastInsertId);
                comparable = bigDecimal;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(this)");
            }
        } else if (Intrinsics.areEqual(clazz, BigInteger.class)) {
            if (this.lastInsertId < 0L) {
                comparable = new BigInteger(Long.toUnsignedString(this.lastInsertId));
            } else {
                BigInteger bigInteger = BigInteger.valueOf(this.lastInsertId);
                comparable = bigInteger;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this)");
            }
        } else if (type.isAssignableFrom(Number.class)) {
            comparable = this.lastInsertId < 0L ? new BigInteger(Long.toUnsignedString(this.lastInsertId)) : Long.valueOf(this.lastInsertId);
        } else {
            throw new IllegalStateException("unmatched requested type " + type.getSimpleName());
        }
        return (T)comparable;
    }

    private final void assertValidIdentifier(Object identifier) {
        Object object = identifier;
        if (object instanceof Integer) {
            if (!Intrinsics.areEqual((Object)identifier, (Object)0)) {
                throw new IndexOutOfBoundsException("Index: " + identifier + ", Size: 1");
            }
        } else if (object instanceof String) {
            if (!StringsKt.equals((String)this.generatedKeyName, (String)((String)identifier), (boolean)true)) {
                throw new NoSuchElementException("Key " + identifier + " is missing in the map.");
            }
        } else {
            throw new IllegalArgumentException("Identifier must be a String or an Integer");
        }
    }
}

