/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.r2dbc.mysql;

import com.github.jasync.sql.db.SSLConfiguration;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/jasync/r2dbc/mysql/MysqlSSLConfigurationFactory;", "", "()V", "SSL_MODE_MAP", "", "", "Lcom/github/jasync/sql/db/SSLConfiguration$Mode;", "SSL_MODE_OPTION", "Lio/r2dbc/spi/Option;", "kotlin.jvm.PlatformType", "create", "Lcom/github/jasync/sql/db/SSLConfiguration;", "options", "Lio/r2dbc/spi/ConnectionFactoryOptions;", "jasync-r2dbc-mysql"})
public final class MysqlSSLConfigurationFactory {
    @NotNull
    public static final MysqlSSLConfigurationFactory INSTANCE = new MysqlSSLConfigurationFactory();
    private static final Option<String> SSL_MODE_OPTION = Option.valueOf((String)"sslMode");
    @NotNull
    private static final Map<String, SSLConfiguration.Mode> SSL_MODE_MAP;

    private MysqlSSLConfigurationFactory() {
    }

    @NotNull
    public final SSLConfiguration create(@NotNull ConnectionFactoryOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!options.hasOption(ConnectionFactoryOptions.SSL)) {
            return new SSLConfiguration(SSLConfiguration.Mode.Disable, null, null, null, 14, null);
        }
        if (!options.hasOption(SSL_MODE_OPTION)) {
            return new SSLConfiguration(SSLConfiguration.Mode.Prefer, null, null, null, 14, null);
        }
        Object object = options.getValue(SSL_MODE_OPTION);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String sslMode = (String)object;
        String string = sslMode.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return new SSLConfiguration(SSL_MODE_MAP.getOrDefault(string, SSLConfiguration.Mode.Prefer), null, null, null, 14, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"disabled", (Object)SSLConfiguration.Mode.Disable), TuplesKt.to((Object)"preferred", (Object)SSLConfiguration.Mode.Prefer), TuplesKt.to((Object)"required", (Object)SSLConfiguration.Mode.Require), TuplesKt.to((Object)"verify_ca", (Object)SSLConfiguration.Mode.VerifyCA), TuplesKt.to((Object)"verify_identity", (Object)SSLConfiguration.Mode.VerifyFull)};
        SSL_MODE_MAP = MapsKt.mapOf((Pair[])pairArray);
    }
}

