/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.r2dbc.mysql;

import com.github.jasync.r2dbc.mysql.JasyncBatch;
import com.github.jasync.r2dbc.mysql.JasyncConnectionMetadata;
import com.github.jasync.r2dbc.mysql.JasyncStatement;
import com.github.jasync.sql.db.ConcreteConnection;
import com.github.jasync.sql.db.mysql.MySQLConnection;
import com.github.jasync.sql.db.mysql.pool.MySQLConnectionFactory;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J4\u0010\u001b\u001a&\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00100\u0010 \u001d*\u0012\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u001c0\u001c2\u0006\u0010\u001a\u001a\u00020\rH\u0002J4\u0010\u001e\u001a&\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00100\u0010 \u001d*\u0012\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00100\u0010\u0018\u00010\u001c0\u001c2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\tH\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010*\u001a\u00020%H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010,\u001a\u00020-H\u0016J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010,\u001a\u00020-H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020%0\u000f2\u0006\u00101\u001a\u000202H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/github/jasync/r2dbc/mysql/JasyncClientConnection;", "Lio/r2dbc/spi/Connection;", "Ljava/util/function/Supplier;", "Lcom/github/jasync/sql/db/Connection;", "jasyncConnection", "mySQLConnectionFactory", "Lcom/github/jasync/sql/db/mysql/pool/MySQLConnectionFactory;", "(Lcom/github/jasync/sql/db/Connection;Lcom/github/jasync/sql/db/mysql/pool/MySQLConnectionFactory;)V", "isolationLevel", "Lio/r2dbc/spi/IsolationLevel;", "assertValidSavepointName", "", "name", "", "beginTransaction", "Lorg/reactivestreams/Publisher;", "Ljava/lang/Void;", "definition", "Lio/r2dbc/spi/TransactionDefinition;", "close", "commitTransaction", "createBatch", "Lio/r2dbc/spi/Batch;", "createSavepoint", "createStatement", "Lio/r2dbc/spi/Statement;", "sql", "executeVoid", "Lreactor/core/publisher/Mono;", "kotlin.jvm.PlatformType", "executeVoidAfterCurrent", "query", "get", "getMetadata", "Lio/r2dbc/spi/ConnectionMetadata;", "getTransactionIsolationLevel", "isAutoCommit", "", "releaseSavepoint", "rollbackTransaction", "rollbackTransactionToSavepoint", "setAutoCommit", "autoCommit", "setLockWaitTimeout", "timeout", "Ljava/time/Duration;", "setStatementTimeout", "setTransactionIsolationLevel", "validate", "depth", "Lio/r2dbc/spi/ValidationDepth;", "jasync-r2dbc-mysql"})
@SourceDebugExtension(value={"SMAP\nJasyncClientConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JasyncClientConnection.kt\ncom/github/jasync/r2dbc/mysql/JasyncClientConnection\n+ 2 FutureUtils.kt\ncom/github/jasync/sql/db/util/FutureUtilsKt\n*L\n1#1,140:1\n58#2:141\n*S KotlinDebug\n*F\n+ 1 JasyncClientConnection.kt\ncom/github/jasync/r2dbc/mysql/JasyncClientConnection\n*L\n31#1:141\n*E\n"})
public final class JasyncClientConnection
implements Connection,
Supplier<com.github.jasync.sql.db.Connection> {
    @NotNull
    private final com.github.jasync.sql.db.Connection jasyncConnection;
    @NotNull
    private final MySQLConnectionFactory mySQLConnectionFactory;
    @NotNull
    private IsolationLevel isolationLevel;

    public JasyncClientConnection(@NotNull com.github.jasync.sql.db.Connection jasyncConnection, @NotNull MySQLConnectionFactory mySQLConnectionFactory) {
        Intrinsics.checkNotNullParameter((Object)jasyncConnection, (String)"jasyncConnection");
        Intrinsics.checkNotNullParameter((Object)mySQLConnectionFactory, (String)"mySQLConnectionFactory");
        this.jasyncConnection = jasyncConnection;
        this.mySQLConnectionFactory = mySQLConnectionFactory;
        IsolationLevel isolationLevel = IsolationLevel.REPEATABLE_READ;
        Intrinsics.checkNotNullExpressionValue((Object)isolationLevel, (String)"REPEATABLE_READ");
        this.isolationLevel = isolationLevel;
    }

    @NotNull
    public Publisher<Boolean> validate(@NotNull ValidationDepth depth) {
        Publisher publisher;
        Intrinsics.checkNotNullParameter((Object)depth, (String)"depth");
        switch (WhenMappings.$EnumSwitchMapping$0[depth.ordinal()]) {
            case 1: {
                com.github.jasync.sql.db.Connection connection = this.jasyncConnection;
                Intrinsics.checkNotNull((Object)connection, (String)"null cannot be cast to non-null type com.github.jasync.sql.db.mysql.MySQLConnection");
                publisher = (Publisher)MonoExtensionsKt.toMono((Object)this.mySQLConnectionFactory.validate((ConcreteConnection)((MySQLConnection)connection)).isSuccess());
                break;
            }
            case 2: {
                Mono mono = Mono.defer(() -> JasyncClientConnection.validate$lambda$1(this));
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer {\n                \u2026 }.toMono()\n            }");
                publisher = (Publisher)mono;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return publisher;
    }

    @NotNull
    public ConnectionMetadata getMetadata() {
        return new JasyncConnectionMetadata(this.jasyncConnection);
    }

    @NotNull
    public Publisher<Void> beginTransaction() {
        Mono<Void> mono = this.executeVoid("START TRANSACTION");
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"START TRANSACTION\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> beginTransaction(@NotNull TransactionDefinition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Mono mono = Mono.defer(() -> JasyncClientConnection.beginTransaction$lambda$4(definition, this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer {\n            val \u2026        .then()\n        }");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> commitTransaction() {
        Mono<Void> mono = this.executeVoid("COMMIT");
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"COMMIT\")");
        return (Publisher)mono;
    }

    public boolean isAutoCommit() {
        com.github.jasync.sql.db.Connection connection = this.jasyncConnection;
        Intrinsics.checkNotNull((Object)connection, (String)"null cannot be cast to non-null type com.github.jasync.sql.db.mysql.MySQLConnection");
        return ((MySQLConnection)connection).isAutoCommit();
    }

    @NotNull
    public Publisher<Void> setAutoCommit(boolean autoCommit) {
        Mono<Void> mono = this.executeVoidAfterCurrent("SET AUTOCOMMIT = " + (autoCommit ? 1 : 0));
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoidAfterCurrent(\u2026 (autoCommit) 1 else 0}\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> setLockWaitTimeout(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Mono<Void> mono = this.executeVoid("SET innodb_lock_wait_timeout=" + timeout.getSeconds());
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"SET innodb_\u2026eout=${timeout.seconds}\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> setStatementTimeout(@NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Mono<Void> mono = this.executeVoid("SET SESSION MAX_EXECUTION_TIME=" + timeout);
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"SET SESSION\u2026EXECUTION_TIME=$timeout\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> createSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("SAVEPOINT `" + name + '`');
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> releaseSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("RELEASE SAVEPOINT `" + name + '`');
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"RELEASE SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> rollbackTransactionToSavepoint(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.assertValidSavepointName(name);
        Mono<Void> mono = this.executeVoid("ROLLBACK TO SAVEPOINT `" + name + '`');
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoid(\"ROLLBACK TO SAVEPOINT `$name`\")");
        return (Publisher)mono;
    }

    @NotNull
    public Publisher<Void> rollbackTransaction() {
        Mono<Void> mono = this.executeVoidAfterCurrent("ROLLBACK");
        Intrinsics.checkNotNullExpressionValue(mono, (String)"executeVoidAfterCurrent(\"ROLLBACK\")");
        return (Publisher)mono;
    }

    private final Mono<Void> executeVoidAfterCurrent(String query) {
        return Mono.defer(() -> JasyncClientConnection.executeVoidAfterCurrent$lambda$5(this, query));
    }

    @NotNull
    public Publisher<Void> setTransactionIsolationLevel(@NotNull IsolationLevel isolationLevel) {
        Intrinsics.checkNotNullParameter((Object)isolationLevel, (String)"isolationLevel");
        Mono mono = this.executeVoidAfterCurrent("SET SESSION TRANSACTION ISOLATION LEVEL " + isolationLevel.asSql()).doOnSuccess(arg_0 -> JasyncClientConnection.setTransactionIsolationLevel$lambda$6((Function1)new Function1<Void, Unit>(this, isolationLevel){
            final /* synthetic */ JasyncClientConnection this$0;
            final /* synthetic */ IsolationLevel $isolationLevel;
            {
                this.this$0 = $receiver;
                this.$isolationLevel = $isolationLevel;
                super(1);
            }

            public final void invoke(Void it) {
                JasyncClientConnection.access$setIsolationLevel$p(this.this$0, this.$isolationLevel);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"override fun setTransact\u2026 = isolationLevel }\n    }");
        return (Publisher)mono;
    }

    @NotNull
    public IsolationLevel getTransactionIsolationLevel() {
        return this.isolationLevel;
    }

    @NotNull
    public Statement createStatement(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return new JasyncStatement(this, sql);
    }

    @NotNull
    public Publisher<Void> close() {
        Mono mono = Mono.defer(() -> JasyncClientConnection.close$lambda$7(this));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"defer { jasyncConnection\u2026nnect().toMono().then() }");
        return (Publisher)mono;
    }

    @NotNull
    public Batch createBatch() {
        return new JasyncBatch(this);
    }

    @Override
    @NotNull
    public com.github.jasync.sql.db.Connection get() {
        return this.jasyncConnection;
    }

    private final Mono<Void> executeVoid(String sql) {
        return Mono.defer(() -> JasyncClientConnection.executeVoid$lambda$8(this, sql));
    }

    private final void assertValidSavepointName(String name) {
        if (((CharSequence)name).length() == 0) {
            throw new IllegalArgumentException("Savepoint name is empty");
        }
        if (StringsKt.indexOf$default((CharSequence)name, (char)'`', (int)0, (boolean)false, (int)6, null) != -1) {
            throw new IllegalArgumentException("Savepoint name must not contain backticks");
        }
    }

    private static final Mono validate$lambda$1(JasyncClientConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MySQLConnectionFactory mySQLConnectionFactory = this$0.mySQLConnectionFactory;
        com.github.jasync.sql.db.Connection connection = this$0.jasyncConnection;
        Intrinsics.checkNotNull((Object)connection, (String)"null cannot be cast to non-null type com.github.jasync.sql.db.mysql.MySQLConnection");
        CompletableFuture $this$map$iv = mySQLConnectionFactory.test((ConcreteConnection)((MySQLConnection)connection));
        boolean $i$f$map = false;
        Function1 function1 = (Function1)new Function1<MySQLConnection, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object invoke(Object it) {
                MySQLConnection it2 = (MySQLConnection)it;
                boolean bl = false;
                return true;
            }
        };
        CompletionStage completionStage = $this$map$iv.thenApply(new Function(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"crossinline f: (A) -> B)\u2026=\n    thenApply { f(it) }");
        return MonoExtensionsKt.toMono((CompletableFuture)completionStage);
    }

    private static final Mono beginTransaction$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono beginTransaction$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono beginTransaction$lambda$4(TransactionDefinition $definition, JasyncClientConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)$definition, (String)"$definition");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Mono setLockWaitTimeout2 = Mono.justOrEmpty((Object)$definition.getAttribute(TransactionDefinition.LOCK_WAIT_TIMEOUT)).flatMap(arg_0 -> JasyncClientConnection.beginTransaction$lambda$4$lambda$2((Function1)new Function1<Duration, Mono<? extends Void>>(this$0){
            final /* synthetic */ JasyncClientConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Mono<? extends Void> invoke(Duration timeout) {
                Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"timeout");
                return Mono.from(this.this$0.setLockWaitTimeout(timeout));
            }
        }, arg_0));
        Mono changeIsolationLevel2 = Mono.justOrEmpty((Object)$definition.getAttribute(TransactionDefinition.ISOLATION_LEVEL)).flatMap(arg_0 -> JasyncClientConnection.beginTransaction$lambda$4$lambda$3((Function1)new Function1<IsolationLevel, Mono<? extends Void>>(this$0){
            final /* synthetic */ JasyncClientConnection this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Mono<? extends Void> invoke(IsolationLevel newIsolationLevel) {
                Intrinsics.checkNotNullExpressionValue((Object)newIsolationLevel, (String)"newIsolationLevel");
                return Mono.from(this.this$0.setTransactionIsolationLevel(newIsolationLevel));
            }
        }, arg_0));
        Mono startTransaction = Mono.from(this$0.beginTransaction());
        return Mono.from((Publisher)((Publisher)setLockWaitTimeout2)).then(changeIsolationLevel2).then(startTransaction).then();
    }

    private static final Mono executeVoidAfterCurrent$lambda$5(JasyncClientConnection this$0, String $query) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$query, (String)"$query");
        com.github.jasync.sql.db.Connection connection = this$0.jasyncConnection;
        Intrinsics.checkNotNull((Object)connection, (String)"null cannot be cast to non-null type com.github.jasync.sql.db.mysql.MySQLConnection");
        return MonoExtensionsKt.toMono((CompletableFuture)((MySQLConnection)connection).sendQueryAfterCurrent($query)).then();
    }

    private static final void setTransactionIsolationLevel$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Mono close$lambda$7(JasyncClientConnection this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return MonoExtensionsKt.toMono((CompletableFuture)this$0.jasyncConnection.disconnect()).then();
    }

    private static final Mono executeVoid$lambda$8(JasyncClientConnection this$0, String $sql) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$sql, (String)"$sql");
        return MonoExtensionsKt.toMono((CompletableFuture)this$0.jasyncConnection.sendQuery($sql)).then();
    }

    public static final /* synthetic */ void access$setIsolationLevel$p(JasyncClientConnection $this, IsolationLevel isolationLevel) {
        $this.isolationLevel = isolationLevel;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationDepth.values().length];
            try {
                nArray[ValidationDepth.LOCAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationDepth.REMOTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

