/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.r2dbc.mysql;

import com.github.jasync.r2dbc.mysql.Bindings;
import com.github.jasync.r2dbc.mysql.JasyncDatabaseException;
import com.github.jasync.r2dbc.mysql.JasyncResult;
import com.github.jasync.r2dbc.mysql.JasyncStatement;
import com.github.jasync.r2dbc.mysql.JasyncStatementKt;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.exceptions.ConnectionTimeoutedException;
import com.github.jasync.sql.db.exceptions.InsufficientParametersException;
import com.github.jasync.sql.db.mysql.MySQLQueryResult;
import com.github.jasync.sql.db.mysql.exceptions.MySQLException;
import com.github.jasync.sql.db.mysql.message.server.ErrorMessage;
import io.r2dbc.spi.Parameter;
import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0001H\u0016J\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u001c\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00062\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001aH\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\r\u001a\u00020\u0001J!\u0010\"\u001a\u00020\u00012\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060$\"\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010%R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/github/jasync/r2dbc/mysql/JasyncStatement;", "Lio/r2dbc/spi/Statement;", "clientSupplier", "Ljava/util/function/Supplier;", "Lcom/github/jasync/sql/db/Connection;", "sql", "", "(Ljava/util/function/Supplier;Ljava/lang/String;)V", "bindings", "Lcom/github/jasync/r2dbc/mysql/Bindings;", "generatedKeyName", "isPrepared", "", "releasePreparedStatementAfterUse", "selectLastInsertId", "add", "bind", "index", "", "value", "", "identifier", "bindNull", "type", "Ljava/lang/Class;", "execute", "Lorg/reactivestreams/Publisher;", "Lio/r2dbc/spi/Result;", "mapBindingValue", "bindValue", "mapException", "Ljava/lang/Exception;", "throwable", "", "returnGeneratedValues", "columns", "", "([Ljava/lang/String;)Lio/r2dbc/spi/Statement;", "jasync-r2dbc-mysql"})
@SourceDebugExtension(value={"SMAP\nJasyncStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JasyncStatement.kt\ncom/github/jasync/r2dbc/mysql/JasyncStatement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
public final class JasyncStatement
implements Statement {
    @NotNull
    private final Supplier<Connection> clientSupplier;
    @NotNull
    private final String sql;
    @NotNull
    private final Bindings bindings;
    private boolean isPrepared;
    private boolean selectLastInsertId;
    private boolean releasePreparedStatementAfterUse;
    @NotNull
    private String generatedKeyName;

    public JasyncStatement(@NotNull Supplier<Connection> clientSupplier, @NotNull String sql) {
        Intrinsics.checkNotNullParameter(clientSupplier, (String)"clientSupplier");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        this.clientSupplier = clientSupplier;
        this.sql = sql;
        this.bindings = new Bindings();
        this.generatedKeyName = "LAST_INSERT_ID";
    }

    @NotNull
    public Statement returnGeneratedValues(String ... columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        if (columns.length == 1) {
            if (!(((CharSequence)columns[0]).length() > 0)) {
                boolean $i$a$-require-JasyncStatement$returnGeneratedValues$32 = false;
                String $i$a$-require-JasyncStatement$returnGeneratedValues$32 = "generated value name must not be empty";
                throw new IllegalArgumentException($i$a$-require-JasyncStatement$returnGeneratedValues$32.toString());
            }
            if (!(StringsKt.indexOf$default((CharSequence)columns[0], (char)'`', (int)0, (boolean)false, (int)6, null) < 0)) {
                boolean bl = false;
                String string = "generated value name must not contain backticks";
                throw new IllegalArgumentException(string.toString());
            }
            this.generatedKeyName = columns[0];
        }
        if (columns.length > 1) {
            throw new IllegalArgumentException("MySQL only supports a single generated value");
        }
        JasyncStatementKt.access$getLogger$p().trace((Function0)new Function0<Object>(this){
            final /* synthetic */ JasyncStatement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "setting selectLastInsertId for " + JasyncStatement.access$getGeneratedKeyName$p(this.this$0);
            }
        });
        this.selectLastInsertId = true;
        return this;
    }

    @NotNull
    public Statement add() {
        JasyncStatementKt.access$getLogger$p().trace((Function0)add.1.INSTANCE);
        if (this.isPrepared) {
            this.bindings.done();
        }
        return this;
    }

    @NotNull
    public Statement bind(@NotNull String identifier, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        throw new UnsupportedOperationException("named binding is not supported by jasync driver " + identifier + '=' + value);
    }

    @NotNull
    public Statement bind(int index, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JasyncStatementKt.access$getLogger$p().trace((Function0)new Function0<Object>(index, value){
            final /* synthetic */ int $index;
            final /* synthetic */ Object $value;
            {
                this.$index = $index;
                this.$value = $value;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "bind " + this.$index + '=' + this.$value;
            }
        });
        this.isPrepared = true;
        Integer n = index;
        this.bindings.current().put(n, value);
        return this;
    }

    @NotNull
    public Statement bindNull(@NotNull String identifier, @NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        throw new UnsupportedOperationException("named binding is not supported by jasync driver " + identifier + '=' + type);
    }

    @NotNull
    public Statement bindNull(int index, @NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        JasyncStatementKt.access$getLogger$p().trace((Function0)new Function0<Object>(index, type){
            final /* synthetic */ int $index;
            final /* synthetic */ Class<?> $type;
            {
                this.$index = $index;
                this.$type = $type;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "bindNull " + this.$index + '=' + this.$type;
            }
        });
        this.isPrepared = true;
        Integer n = index;
        this.bindings.current().put(n, null);
        return this;
    }

    @NotNull
    public final Statement releasePreparedStatementAfterUse() {
        if (!this.isPrepared) {
            boolean bl = false;
            String string = "releasePreparedStatementAfterUse can only be called for prepared statements";
            throw new IllegalStateException(string.toString());
        }
        JasyncStatementKt.access$getLogger$p().trace((Function0)releasePreparedStatementAfterUse.2.INSTANCE);
        this.releasePreparedStatementAfterUse = true;
        return this;
    }

    @NotNull
    public Publisher<? extends Result> execute() {
        JasyncStatementKt.access$getLogger$p().trace((Function0)execute.1.INSTANCE);
        Flux flux = Mono.fromSupplier(this.clientSupplier).flatMapMany(arg_0 -> JasyncStatement.execute$lambda$3((Function1)new Function1<Connection, Publisher<? extends QueryResult>>(this){
            final /* synthetic */ JasyncStatement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends QueryResult> invoke(Connection connection) {
                CorePublisher corePublisher;
                if (JasyncStatement.access$isPrepared$p(this.this$0)) {
                    Flux allParams2 = FluxExtensionsKt.toFlux((Sequence)SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)JasyncStatement.access$getBindings$p(this.this$0).all()), (Function2)((Function2)new Function2<Integer, Map<Integer, ? extends Object>, List<? extends Object>>(this.this$0){
                        final /* synthetic */ JasyncStatement this$0;
                        {
                            this.this$0 = $receiver;
                            super(2);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final List<Object> invoke(int i2, @NotNull Map<Integer, ? extends Object> binding) {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Intrinsics.checkNotNullParameter(binding, (String)"binding");
                            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)binding.size());
                            JasyncStatement jasyncStatement = this.this$0;
                            boolean $i$f$map = false;
                            void var6_6 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                void it;
                                int item$iv$iv;
                                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                if (!binding.containsKey((int)it)) {
                                    throw new IllegalStateException("binding failed with bind index " + i2 + " and param index " + (int)it + " for query '" + JasyncStatement.access$getSql$p(jasyncStatement) + '\'');
                                }
                                collection.add(JasyncStatement.access$mapBindingValue(jasyncStatement, binding.get((int)it)));
                            }
                            return (List)destination$iv$iv;
                        }
                    })));
                    corePublisher = (CorePublisher)allParams2.concatMap(arg_0 -> execute.2.invoke$lambda$0((Function1)new Function1<List<? extends Object>, Publisher<? extends QueryResult>>(connection, this.this$0){
                        final /* synthetic */ Connection $connection;
                        final /* synthetic */ JasyncStatement this$0;
                        {
                            this.$connection = $connection;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final Publisher<? extends QueryResult> invoke(List<? extends Object> it) {
                            String string = JasyncStatement.access$getSql$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                            return (Publisher)MonoExtensionsKt.toMono((CompletableFuture)this.$connection.sendPreparedStatement(string, it, JasyncStatement.access$getReleasePreparedStatementAfterUse$p(this.this$0)));
                        }
                    }, arg_0));
                } else {
                    corePublisher = (CorePublisher)MonoExtensionsKt.toMono((CompletableFuture)connection.sendQuery(JasyncStatement.access$getSql$p(this.this$0)));
                }
                return (Publisher)corePublisher;
            }

            private static final Publisher invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Publisher)$tmp0.invoke(p0);
            }
        }, arg_0)).map(arg_0 -> JasyncStatement.execute$lambda$4((Function1)new Function1<QueryResult, JasyncResult>(this){
            final /* synthetic */ JasyncStatement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final JasyncResult invoke(QueryResult it) {
                JasyncResult jasyncResult;
                JasyncStatementKt.access$getLogger$p().trace((Function0)new Function0<Object>(this.this$0){
                    final /* synthetic */ JasyncStatement this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "execute.map " + JasyncStatement.access$getSelectLastInsertId$p(this.this$0);
                    }
                });
                if (JasyncStatement.access$getSelectLastInsertId$p(this.this$0)) {
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.github.jasync.sql.db.mysql.MySQLQueryResult");
                    long lastInsertId = ((MySQLQueryResult)it).getLastInsertId();
                    jasyncResult = new JasyncResult(it.getRows(), it.getRowsAffected(), JasyncStatement.access$getSelectLastInsertId$p(this.this$0), lastInsertId, JasyncStatement.access$getGeneratedKeyName$p(this.this$0));
                } else {
                    jasyncResult = new JasyncResult(it.getRows(), it.getRowsAffected());
                }
                return jasyncResult;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"override fun execute(): \u2026able)\n            }\n    }");
        return (Publisher)FluxExtensionsKt.onErrorMap((Flux)flux, (KClass)Reflection.getOrCreateKotlinClass(Throwable.class), (Function1)((Function1)new Function1<Throwable, Throwable>(this){
            final /* synthetic */ JasyncStatement this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Throwable invoke(@NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                JasyncStatementKt.access$getLogger$p().trace((Function0)new Function0<Object>(throwable){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = $throwable;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "mapException " + this.$throwable.getClass();
                    }
                });
                return JasyncStatement.access$mapException(this.this$0, throwable);
            }
        }));
    }

    private final Object mapBindingValue(Object bindValue) {
        JasyncStatementKt.access$getLogger$p().trace((Function0)new Function0<Object>(bindValue){
            final /* synthetic */ Object $bindValue;
            {
                this.$bindValue = $bindValue;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                Object object = this.$bindValue;
                return "mapping bindValue type " + (object != null ? object.getClass() : null) + ' ' + this.$bindValue;
            }
        });
        return bindValue instanceof Parameter ? ((Parameter)bindValue).getValue() : bindValue;
    }

    private final Exception mapException(Throwable throwable) {
        Exception exception;
        block46: {
            Throwable throwable2;
            block51: {
                R2dbcException r2dbcException;
                block50: {
                    block49: {
                        block48: {
                            block47: {
                                block45: {
                                    throwable2 = throwable;
                                    if (!(throwable2 instanceof ConnectionTimeoutedException)) break block45;
                                    exception = (Exception)new R2dbcTimeoutException(throwable);
                                    break block46;
                                }
                                if (!(throwable2 instanceof IllegalArgumentException)) break block47;
                                exception = (Exception)throwable;
                                break block46;
                            }
                            if (!(throwable2 instanceof IllegalStateException)) break block48;
                            exception = (Exception)throwable;
                            break block46;
                        }
                        if (!(throwable2 instanceof UnsupportedOperationException)) break block49;
                        exception = (Exception)throwable;
                        break block46;
                    }
                    if (!(throwable2 instanceof IOException)) break block50;
                    exception = (Exception)throwable;
                    break block46;
                }
                if (!(throwable2 instanceof MySQLException)) break block51;
                ErrorMessage errorMessage = ((MySQLException)throwable).getErrorMessage();
                block0 : switch (errorMessage.getErrorCode()) {
                    case 1044: 
                    case 1045: 
                    case 1095: 
                    case 1142: 
                    case 1143: 
                    case 1227: 
                    case 1370: 
                    case 1698: 
                    case 1873: {
                        r2dbcException = (R2dbcException)new R2dbcPermissionDeniedException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                        break;
                    }
                    case 1022: 
                    case 1048: 
                    case 1062: 
                    case 1169: 
                    case 1215: 
                    case 1216: 
                    case 1217: 
                    case 1364: 
                    case 1451: 
                    case 1452: 
                    case 1557: 
                    case 1859: {
                        r2dbcException = (R2dbcException)new R2dbcDataIntegrityViolationException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                        break;
                    }
                    case 1050: 
                    case 1051: 
                    case 1054: 
                    case 1064: 
                    case 1146: 
                    case 1247: 
                    case 1304: 
                    case 1305: 
                    case 1630: {
                        r2dbcException = (R2dbcException)new R2dbcBadGrammarException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), this.sql, throwable);
                        break;
                    }
                    case 1205: 
                    case 1907: 
                    case 3024: {
                        r2dbcException = (R2dbcException)new R2dbcTimeoutException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                        break;
                    }
                    case 1402: 
                    case 1613: {
                        r2dbcException = (R2dbcException)new R2dbcRollbackException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                        break;
                    }
                    case 1159: 
                    case 1161: 
                    case 1213: 
                    case 1317: {
                        r2dbcException = (R2dbcException)new R2dbcTransientResourceException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                        break;
                    }
                    default: {
                        switch (StringsKt.take((String)errorMessage.getSqlState(), (int)2)) {
                            case "22": 
                            case "26": 
                            case "XA": 
                            case "0A": 
                            case "2F": 
                            case "20": 
                            case "42": {
                                r2dbcException = (R2dbcException)new R2dbcBadGrammarException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                                break block0;
                            }
                            case "25": 
                            case "28": {
                                r2dbcException = (R2dbcException)new R2dbcPermissionDeniedException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                                break block0;
                            }
                            case "23": 
                            case "21": {
                                r2dbcException = (R2dbcException)new R2dbcDataIntegrityViolationException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                                break block0;
                            }
                            case "08": 
                            case "H1": {
                                r2dbcException = (R2dbcException)new R2dbcNonTransientResourceException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                                break block0;
                            }
                            case "40": {
                                r2dbcException = (R2dbcException)new R2dbcRollbackException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                                break block0;
                            }
                        }
                        r2dbcException = (R2dbcException)new JasyncDatabaseException(errorMessage.getErrorMessage(), errorMessage.getSqlState(), errorMessage.getErrorCode(), throwable);
                    }
                }
                exception = (Exception)r2dbcException;
                break block46;
            }
            exception = throwable2 instanceof InsufficientParametersException ? (Exception)new R2dbcDataIntegrityViolationException(throwable.getMessage(), throwable) : (Exception)((Object)new JasyncDatabaseException("Unknown exception", "UNKOWN", -1, throwable));
        }
        return exception;
    }

    private static final Publisher execute$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final JasyncResult execute$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (JasyncResult)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getGeneratedKeyName$p(JasyncStatement $this) {
        return $this.generatedKeyName;
    }

    public static final /* synthetic */ boolean access$isPrepared$p(JasyncStatement $this) {
        return $this.isPrepared;
    }

    public static final /* synthetic */ Bindings access$getBindings$p(JasyncStatement $this) {
        return $this.bindings;
    }

    public static final /* synthetic */ Object access$mapBindingValue(JasyncStatement $this, Object bindValue) {
        return $this.mapBindingValue(bindValue);
    }

    public static final /* synthetic */ String access$getSql$p(JasyncStatement $this) {
        return $this.sql;
    }

    public static final /* synthetic */ boolean access$getReleasePreparedStatementAfterUse$p(JasyncStatement $this) {
        return $this.releasePreparedStatementAfterUse;
    }

    public static final /* synthetic */ boolean access$getSelectLastInsertId$p(JasyncStatement $this) {
        return $this.selectLastInsertId;
    }

    public static final /* synthetic */ Exception access$mapException(JasyncStatement $this, Throwable throwable) {
        return $this.mapException(throwable);
    }
}

