/*
 * Decompiled with CFR 0.152.
 */
package com.github.javahao.util;

import cn.org.rapid_framework.util.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisObject {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";

    public static Object getResult(Object objParam, String columnMethod) {
        try {
            for (String methodStr : columnMethod.trim().split("[.]")) {
                methodStr = GETTER_PREFIX + methodStr.substring(0, 1).toUpperCase() + methodStr.substring(1);
                Method method = objParam.getClass().getMethod(methodStr, new Class[0]);
                objParam = method.invoke(objParam, new Object[0]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return objParam;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Method method = AnalysisObject.getAccessibleMethod(obj, methodName, parameterTypes);
        if (ObjectUtils.isEmpty((Object)method)) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        Object object = obj;
        String[] names = StringUtils.split((String)propertyName, (String)".");
        for (int i = 0; i < names.length; ++i) {
            if (i < names.length - 1) {
                String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)names[i]);
                object = AnalysisObject.invokeMethod(object, getterMethodName, new Class[0], new Object[0]);
                continue;
            }
            String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)names[i]);
            AnalysisObject.invokeMethodByName(object, setterMethodName, new Object[]{value});
        }
    }

    public static Object invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = AnalysisObject.getAccessibleMethodByName(obj, methodName);
        if (ObjectUtils.isEmpty((Object)method)) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on target [" + obj + "]");
        }
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getAccessibleMethodByName(Object obj, String methodName) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                AnalysisObject.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Object obj, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> searchType = obj.getClass(); searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, parameterTypes);
                AnalysisObject.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }
}

