/*
 * Decompiled with CFR 0.152.
 */
package com.github.javahao.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class AntZipFileUtil {
    static boolean flag = true;
    private static ZipFile zipFile;
    private static ZipEntry zipEntry;
    private static ZipOutputStream zipOut;
    private static int bufSize;
    private static byte[] buf;
    private static int readedBytes;

    public static boolean doZip(String srcStr, String targetStr, String targetName) {
        File zipDir = new File(srcStr);
        if (StringUtils.isBlank((CharSequence)targetName)) {
            targetName = "ZipFile";
        }
        if (!targetName.endsWith(".zip")) {
            targetName = targetName + ".zip";
        }
        try {
            zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(new File(targetStr + File.separator + targetName)));
            AntZipFileUtil.compressFile(zipDir, "", zipOut);
            zipOut.close();
        }
        catch (IOException e) {
            flag = false;
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean doFileZip(File zipDir, String targetStr, String targetName, String suffix) {
        if (StringUtils.isBlank((CharSequence)targetName)) {
            targetName = "ZipFile";
        }
        if (!targetName.endsWith(".zip")) {
            targetName = targetName + ("".equals(suffix) ? ".zip" : suffix);
        }
        try {
            zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(new File(targetStr + File.separator + targetName)));
            AntZipFileUtil.compressFile(zipDir, "", zipOut);
            zipOut.close();
        }
        catch (IOException e) {
            flag = false;
            e.printStackTrace();
        }
        return flag;
    }

    private static void compressFile(File srcFile, String oppositePath, ZipOutputStream zipOut) throws IOException {
        if (srcFile.isDirectory()) {
            String newOppositePath = oppositePath + srcFile.getName() + "/";
            AntZipFileUtil.compressFolder(srcFile, newOppositePath, zipOut);
        }
        if (srcFile.isFile()) {
            ZipEntry zipe = new ZipEntry(oppositePath + srcFile.getName());
            try {
                zipOut.setEncoding("GBK");
                zipOut.putNextEntry(zipe);
                FileInputStream fileIn = new FileInputStream(srcFile);
                while ((readedBytes = fileIn.read(buf)) > 0) {
                    zipOut.write(buf, 0, readedBytes);
                }
                zipOut.flush();
                fileIn.close();
                zipOut.closeEntry();
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    private static void compressFolder(File file, String oppositePath, ZipOutputStream zipOut) throws IOException {
        File[] files = file.listFiles();
        if (files.length == 0) {
            String fileName = files.toString();
            if (file.isDirectory()) {
                fileName = fileName + "/";
            }
            zipOut.putNextEntry(new ZipEntry(oppositePath));
            if (file.isFile()) {
                FileInputStream fileIn = new FileInputStream(file);
                while ((readedBytes = fileIn.read(buf)) > 0) {
                    zipOut.write(buf, 0, readedBytes);
                }
                fileIn.close();
            }
            zipOut.closeEntry();
        } else {
            for (File subfile : files) {
                AntZipFileUtil.compressFile(subfile, oppositePath, zipOut);
            }
        }
    }

    public void upZip(String srcZipFile, String targetStr, String targetName) {
        try {
            zipFile = new ZipFile(srcZipFile);
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                zipEntry = (ZipEntry)entries.nextElement();
                File file = new File(targetStr + "/" + targetName + "/" + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File parent = file.getParentFile();
                if (null == parent || !parent.exists()) {
                    parent.mkdirs();
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                FileOutputStream fileOut = new FileOutputStream(file);
                while ((readedBytes = inputStream.read(buf)) > 0) {
                    fileOut.write(buf, 0, readedBytes);
                }
                fileOut.close();
                inputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setBufSize(int bufSize) {
        AntZipFileUtil.bufSize = bufSize;
    }

    static {
        bufSize = 1024;
        buf = new byte[bufSize];
    }
}

