/*
 * Decompiled with CFR 0.152.
 */
package com.github.javahao.util;

import cn.org.rapid_framework.util.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    private static final transient Log log = LogFactory.getLog(FileUtil.class);
    private static List<File> fileList = new ArrayList<File>();
    static BufferedInputStream bis = null;
    static BufferedOutputStream bos = null;
    public static final String NETWORK = "network";
    public static final String CLASSPATH = "classpath";

    public static void fileIsExists(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readTxt(String path) {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            String lineTxt = null;
            while (ObjectUtils.isNotEmpty((Object)(lineTxt = bufferedReader.readLine()))) {
                result.add(lineTxt);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        return result;
    }

    public static void printTxtToFile(String path, String value) throws Exception {
        File file = new File(path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), "UTF-8");
        writer.write(value);
        ((Writer)writer).close();
    }

    public static String joinFilName(String path, String join) {
        StringBuffer sb = new StringBuffer();
        File files = new File(path);
        String[] filess = files.list();
        for (int i = 0; i < filess.length; ++i) {
            sb.append(path);
            sb.append(filess[i]);
            sb.append(join);
        }
        return sb.toString();
    }

    public static String getProjectPath() {
        String projectPath = "";
        try {
            File file = new DefaultResourceLoader().getResource("").getFile();
            if (file != null) {
                File f;
                while ((f = new File(StringUtils.join((Object[])new Object[]{file.getPath(), File.separator, "src", File.separator, "main"}))) != null && !f.exists() && file.getParentFile() != null) {
                    file = file.getParentFile();
                }
                projectPath = file.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return projectPath;
    }

    public static String getProjectClassPath() {
        try {
            return new DefaultResourceLoader().getResource("").getFile().getPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void deleteFileByFolder(String path) throws Exception {
        File file = new File(path);
        FileUtil.deleteFileUtil(file);
        for (int i = fileList.size() - 1; i >= 0; --i) {
            fileList.get(i).delete();
        }
    }

    public static void deleteFileByPath(String path) throws Exception {
        File file = new File(path);
        file.delete();
    }

    private static void deleteFileUtil(File file) throws Exception {
        File[] childFile = file.listFiles();
        fileList.addAll(Arrays.asList(childFile));
        for (File f : childFile) {
            if (!f.isDirectory()) continue;
            FileUtil.deleteFileUtil(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFileToPath(String sourcePath, String toPath, String fileName) {
        File inputFile = new File(sourcePath);
        File outPath = new File(toPath);
        File outFile = new File(toPath + fileName);
        if (!outPath.getParentFile().exists()) {
            outPath.getParentFile().mkdirs();
        }
        byte[] b = new byte[1024];
        try {
            int len;
            bis = new BufferedInputStream(new FileInputStream(inputFile));
            bos = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((len = bis.read(b)) != -1) {
                bos.write(b, 0, len);
            }
            System.out.println("\u590d\u5236\u5b8c\u6210" + fileName + "\uff01");
        }
        catch (FileNotFoundException e) {
            System.out.println("\u6587\u4ef6\u672a\u627e\u5230\uff01\u8bf7\u786e\u5b9a\u6587\u4ef6\u8def\u5f84\u6b63\u786e\uff01");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            System.out.println("\u590d\u5236\u6587\u4ef6\u5931\u8d25\uff01");
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtil.closeAll();
        }
        return true;
    }

    private static void closeAll() {
        try {
            if (ObjectUtils.isNotEmpty((Object)bis) && ObjectUtils.isNotEmpty((Object)bos)) {
                bis.close();
                bos.close();
            }
        }
        catch (IOException e) {
            System.out.println("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25\uff01");
        }
    }

    public static String readProperties(String path, String readType, String readKey, String defaultValue) {
        Properties properties = FileUtil.readPropertiesUtil(path, readType);
        String result = properties.getProperty(readKey, defaultValue);
        return result;
    }

    public static Map<String, String> getPropertiesKeyValue(String path, String readType) {
        Properties properties = FileUtil.readPropertiesUtil(path, readType);
        Enumeration<?> propNames = properties.propertyNames();
        HashMap<String, String> keyValue = new HashMap<String, String>();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            String value = properties.getProperty(key);
            keyValue.put(key, value);
        }
        return keyValue;
    }

    public static Properties readPropertiesUtil(String path, String readType) {
        Properties properties = new Properties();
        try {
            if (NETWORK.equals(readType)) {
                URL url = new URL(path);
                properties.load(url.openStream());
            } else if (CLASSPATH.equals(readType)) {
                InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                properties.load(in);
            } else {
                properties.load(new FileInputStream(new File(path)));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("\u6587\u4ef6\u672a\u627e\u5230\uff01---------" + e);
        }
        catch (IOException e) {
            System.out.println("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff01---------" + e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File file) {
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[8192];
        try {
            int len;
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            while ((len = in.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            BigInteger bigInt = new BigInteger(1, digest.digest());
            String string = bigInt.toString(16);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileSha1(File file) {
        if (!file.isFile()) {
            return null;
        }
        MessageDigest digest = null;
        FileInputStream in = null;
        byte[] buffer = new byte[8192];
        try {
            int len;
            digest = MessageDigest.getInstance("SHA-1");
            in = new FileInputStream(file);
            while ((len = in.read(buffer)) != -1) {
                digest.update(buffer, 0, len);
            }
            BigInteger bigInt = new BigInteger(1, digest.digest());
            String string = bigInt.toString(16);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String md5(String content) {
        StringBuffer sb = new StringBuffer();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(content.getBytes("UTF-8"));
            byte[] tmpFolder = md5.digest();
            for (int i = 0; i < tmpFolder.length; ++i) {
                sb.append(Integer.toString((tmpFolder[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            log.error((Object)"\u65e0\u6cd5\u751f\u6210\u6587\u4ef6\u7684MD5\u7b7e\u540d", (Throwable)ex);
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"\u65e0\u6cd5\u751f\u6210\u6587\u4ef6\u7684MD5\u7b7e\u540d", (Throwable)ex);
            return null;
        }
    }
}

