/*
 * Decompiled with CFR 0.152.
 */
package com.github.javahao.util;

import cn.org.rapid_framework.util.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtil {
    private static int bufSize = 8096;
    private static Log log = LogFactory.getLog(ZipUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String antzip(File[] files, String zipFileName) {
        File filezip;
        if (StringUtils.isBlank((CharSequence)zipFileName)) {
            zipFileName = "ZipFile";
        }
        if (!(zipFileName.toLowerCase().endsWith(".zip") || zipFileName.toLowerCase().endsWith(".jar") || zipFileName.toLowerCase().endsWith(".war"))) {
            zipFileName = zipFileName + ".zip";
        }
        if ((filezip = new File(zipFileName)).exists()) {
            filezip.delete();
        }
        ZipOutputStream zipOutput = null;
        try {
            zipOutput = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(zipFileName)));
            zipOutput.setEncoding("GBK");
            for (File file : files) {
                ZipUtil.antzipFiles(file, zipOutput, "");
            }
            log.info((Object)("\u538b\u7f29\u6587\u4ef6\u6210\u529f\uff1a" + zipFileName));
        }
        catch (Exception e) {
            log.error((Object)"\u538b\u7f29\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            String string = e.getMessage();
            return string;
        }
        finally {
            try {
                assert (zipOutput != null);
                zipOutput.close();
            }
            catch (Exception e) {
                log.error((Object)"\u5f02\u5e38", (Throwable)e);
            }
        }
        return null;
    }

    public static String antzip(String zipDirectory) {
        File zipDir = new File(zipDirectory);
        return ZipUtil.antzip(zipDirectory, zipDir.getPath(), false);
    }

    public static String antzip(String zipDirectory, String zipFileName, boolean includeSelfDir) {
        File zipDir = new File(zipDirectory);
        File[] willZipFileArr = includeSelfDir || zipDir.isFile() ? new File[]{zipDir} : zipDir.listFiles();
        return ZipUtil.antzip(willZipFileArr, zipFileName);
    }

    public static void createZip(File file, boolean flag, String baseDir, String objFileName, boolean checkfile) throws Exception {
        ZipOutputStream zos;
        File folderObject = new File(baseDir);
        if (folderObject.exists()) {
            zos = new ZipOutputStream((OutputStream)new FileOutputStream(objFileName));
            zos.setEncoding("GBK");
            ZipEntry ze = null;
            int readLen = 0;
            byte[] buf = new byte[1024];
            if (null != file) {
                ze = new ZipEntry(ZipUtil.getAbsFileName(baseDir, file));
                ze.setSize(file.length());
                ze.setTime(file.lastModified());
                zos.putNextEntry(ze);
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                    zos.write(buf, 0, readLen);
                }
                ((InputStream)is).close();
            } else {
                List fileList = ZipUtil.getSubFiles(new File(baseDir));
                for (int i = 0; i < fileList.size(); ++i) {
                    File f = (File)fileList.get(i);
                    if (flag && checkfile && !f.isDirectory()) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(new Date());
                        cal.add(5, -1);
                        Date fDate = new Date(f.lastModified());
                        if (fDate.compareTo(cal.getTime()) < 0) continue;
                    }
                    ze = new ZipEntry(ZipUtil.getAbsFileName(baseDir, f));
                    ze.setSize(f.length());
                    ze.setTime(f.lastModified());
                    zos.putNextEntry(ze);
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                    while ((readLen = ((InputStream)is).read(buf, 0, 1024)) != -1) {
                        zos.write(buf, 0, readLen);
                    }
                    ((InputStream)is).close();
                }
            }
        } else {
            throw new Exception("this folder isnot exist!");
        }
        zos.close();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("\u5f00\u59cb\u89e3\u538b");
        ZipUtil.unZip("E:\\temp\\\u9152\u5e97\u9875\u9762.zip", "E:\\temp\\");
        System.out.println("\u89e3\u538bend");
    }

    public static boolean unZip(File unZipFile) {
        return ZipUtil.unZip(unZipFile.getPath(), null);
    }

    public static boolean unZip(File unZipFile, String destFileName) {
        return ZipUtil.unZip(unZipFile.getPath(), destFileName);
    }

    public static boolean unZip(String unZipFileName) {
        return ZipUtil.unZip(unZipFileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unZip(String unZipFileName, String destFileName) {
        File unzipFile = new File(unZipFileName);
        if (StringUtils.isBlank((CharSequence)destFileName) || destFileName.trim().length() == 0) {
            destFileName = unzipFile.getParent();
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(unzipFile, "GBK");
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                File destFile = new File(destFileName, entry.getName());
                ZipUtil.unZipFile(destFile, zipFile, entry, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u89e3\u538bZIP\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                assert (zipFile != null);
                zipFile.close();
            }
            catch (Exception e) {
                log.error((Object)"\u5f02\u5e38", (Throwable)e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unZipWithFileCheck(String unZipFileName, String destFileName) {
        File unzipFile = new File(unZipFileName);
        StringBuffer sBuffer = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)destFileName) || destFileName.trim().length() == 0) {
            destFileName = unzipFile.getParent();
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(unzipFile, "GBK");
            DecimalFormat df = new DecimalFormat("#####.##");
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                int readedBytes;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                File destFile = new File(destFileName, entry.getName());
                boolean needwrite = false;
                String path = destFile.getAbsolutePath();
                path = path.replaceAll("\\\\", "/").replaceAll("//", "/");
                path = path.substring(path.indexOf("/hdtv/") + 5);
                if (!destFile.exists()) {
                    needwrite = true;
                    sBuffer.append("     ").append("        [\u65b0\u589e]   ").append(path).append(" \u65f6\u95f4:").append("").append(" \u5927\u5c0f: ").append(df.format((double)entry.getSize() / 1024.0)).append(" KB\uff01").append("\r\n");
                } else {
                    long entrytime = entry.getTime();
                    long localtime = destFile.lastModified();
                    long entrysize = entry.getSize();
                    long localsize = destFile.length();
                    if (entrytime != localtime || entrysize != localsize) {
                        needwrite = true;
                        sBuffer.append("     ").append("        [\u4fee\u6539]   ").append(path).append(" \u66f4\u65b0\u4e3a\u65f6\u95f4:").append("").append(" \u5927\u5c0f: ").append(df.format((double)entrysize / 1024.0)).append(" KB\uff01").append("\r\n");
                    }
                }
                if (!needwrite) continue;
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                File parent = destFile.getParentFile();
                if (ObjectUtils.isNotEmpty((Object)parent) && !parent.exists()) {
                    parent.mkdirs();
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                FileOutputStream fileOut = new FileOutputStream(destFile);
                byte[] buf = new byte[bufSize];
                while ((readedBytes = inputStream.read(buf)) > 0) {
                    fileOut.write(buf, 0, readedBytes);
                }
                fileOut.close();
                inputStream.close();
                destFile.setLastModified(entry.getTime());
            }
        }
        catch (Exception e) {
            log.error((Object)"\u89e3\u538bZIP\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            sBuffer.append("\u89e3\u538bZIP\u6587\u4ef6\u5f02\u5e38:").append(e.getMessage()).append("\r\n");
        }
        finally {
            try {
                if (ObjectUtils.isNotEmpty((Object)zipFile)) {
                    zipFile.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"\u5f02\u5e38", (Throwable)e);
            }
        }
        return sBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unZipWithoutOverWrite(String unZipFileName, String destFileName) {
        File unzipFile = new File(unZipFileName);
        if (StringUtils.isBlank((CharSequence)destFileName) || destFileName.trim().length() == 0) {
            destFileName = unzipFile.getParent();
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(unzipFile, "GBK");
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                File destFile = new File(destFileName, entry.getName());
                ZipUtil.unZipFile(destFile, zipFile, entry, false);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u89e3\u538bZIP\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                assert (zipFile != null);
                zipFile.close();
            }
            catch (Exception e) {
                log.error((Object)"\u5f02\u5e38", (Throwable)e);
            }
        }
        return true;
    }

    private static void antzipFiles(File file, ZipOutputStream zipOutput, String pathName) throws Exception {
        String fileName = pathName + file.getName();
        if (file.isDirectory()) {
            fileName = fileName + "/";
            ZipEntry entry = new ZipEntry(fileName);
            entry.setTime(file.lastModified());
            zipOutput.putNextEntry(entry);
            zipOutput.closeEntry();
            String[] fileNames = file.list();
            if (ObjectUtils.isNotEmpty((Object)fileNames)) {
                for (String fileName2 : fileNames) {
                    ZipUtil.antzipFiles(new File(file, fileName2), zipOutput, fileName);
                }
                zipOutput.closeEntry();
            }
        } else {
            int len;
            ZipEntry jarEntry = new ZipEntry(fileName);
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            zipOutput.putNextEntry(jarEntry);
            byte[] buf = new byte[bufSize];
            while ((len = in.read(buf)) >= 0) {
                zipOutput.write(buf, 0, len);
            }
            in.close();
            zipOutput.closeEntry();
        }
    }

    private static String getAbsFileName(String baseDir, File realFileName) {
        File real = realFileName;
        File base = new File(baseDir);
        String ret = real.getName();
        while (!ObjectUtils.isEmpty((Object)(real = real.getParentFile())) && !real.equals(base)) {
            ret = real.getName() + "/" + ret;
        }
        return ret;
    }

    private static List getSubFiles(File baseDir) {
        File[] tmp;
        ArrayList<File> ret = new ArrayList<File>();
        for (File element : tmp = baseDir.listFiles()) {
            if (element.isFile()) {
                ret.add(element);
            }
            if (!element.isDirectory()) continue;
            ret.addAll(ZipUtil.getSubFiles(element));
        }
        return ret;
    }

    private static void unZipFile(File destFile, ZipFile zipFile, ZipEntry entry, boolean isOverWriteIgnore) throws IOException {
        if (entry.isDirectory()) {
            destFile.mkdirs();
        } else {
            File parent = destFile.getParentFile();
            if (ObjectUtils.isNotEmpty((Object)parent) && !parent.exists()) {
                parent.mkdirs();
            }
            boolean isOverWriteFlag = true;
            if (!isOverWriteIgnore && parent.isDirectory()) {
                String[] childfiles;
                for (String cf : childfiles = parent.list()) {
                    File file2X = new File(parent.getAbsolutePath() + "/" + cf);
                    if (file2X.exists()) {
                        if (file2X.isFile()) {
                            if (!file2X.getName().equals(destFile.getName())) continue;
                            isOverWriteFlag = false;
                            break;
                        }
                        if (!file2X.isDirectory()) continue;
                        continue;
                    }
                    throw new RuntimeException("File not exist!");
                }
            }
            if (isOverWriteFlag) {
                int readedBytes;
                InputStream inputStream = zipFile.getInputStream(entry);
                FileOutputStream fileOut = new FileOutputStream(destFile);
                byte[] buf = new byte[bufSize];
                while ((readedBytes = inputStream.read(buf)) > 0) {
                    fileOut.write(buf, 0, readedBytes);
                }
                fileOut.close();
                inputStream.close();
            }
        }
    }
}

