/*
 * Decompiled with CFR 0.152.
 */
package com.github.javahao.util.word;

import cn.org.rapid_framework.util.ObjectUtils;
import com.github.javahao.util.AnalysisObject;
import com.github.javahao.util.word.ExcelField;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportExcel {
    private static Logger log = LoggerFactory.getLogger(ImportExcel.class);
    private Workbook wb;
    private Sheet sheet;
    private int headerNum;

    public ImportExcel(String fileName, int headerNum) throws InvalidFormatException, IOException {
        this(new File(fileName), headerNum);
    }

    public ImportExcel(File file, int headerNum) throws InvalidFormatException, IOException {
        this(file, headerNum, 0);
    }

    public ImportExcel(String fileName, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(new File(fileName), headerNum, sheetIndex);
    }

    public ImportExcel(File file, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(file.getName(), new FileInputStream(file), headerNum, sheetIndex);
    }

    public ImportExcel(MultipartFile multipartFile, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(multipartFile.getOriginalFilename(), multipartFile.getInputStream(), headerNum, sheetIndex);
    }

    public ImportExcel(String fileName, InputStream is, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new RuntimeException("\u5bfc\u5165\u6587\u6863\u4e3a\u7a7a!");
        }
        if (fileName.toLowerCase().endsWith("xls")) {
            this.wb = new HSSFWorkbook(is);
        } else if (fileName.toLowerCase().endsWith("xlsx")) {
            this.wb = new XSSFWorkbook(is);
        } else {
            throw new RuntimeException("\u6587\u6863\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        if (this.wb.getNumberOfSheets() < sheetIndex) {
            throw new RuntimeException("\u6587\u6863\u4e2d\u6ca1\u6709\u5de5\u4f5c\u8868!");
        }
        this.sheet = this.wb.getSheetAt(sheetIndex);
        this.headerNum = headerNum;
        log.debug("Initialize success.");
    }

    public Row getRow(int rownum) {
        return this.sheet.getRow(rownum);
    }

    public int getDataRowNum() {
        return this.headerNum + 1;
    }

    public int getLastDataRowNum() {
        return this.sheet.getLastRowNum() + this.headerNum;
    }

    public int getLastCellNum() {
        return this.getRow(this.headerNum).getLastCellNum();
    }

    public Object getCellValue(Row row, int column) {
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (ObjectUtils.isNotEmpty((Object)cell)) {
                if (cell.getCellType() == 0) {
                    val = cell.getNumericCellValue();
                } else if (cell.getCellType() == 1) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellType() == 2) {
                    val = cell.getCellFormula();
                } else if (cell.getCellType() == 4) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellType() == 5) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            return val;
        }
        return val;
    }

    public <E> List<E> getDataList(Class<E> cls, int ... groups) throws Exception {
        Method[] ms;
        Field[] fs;
        ArrayList annotationList = Lists.newArrayList();
        block2: for (Field f : fs = cls.getDeclaredFields()) {
            ExcelField ef = f.getAnnotation(ExcelField.class);
            if (!ObjectUtils.isNotEmpty((Object)ef) || ef.type() != 0 && ef.type() != 2) continue;
            if (ObjectUtils.isNotEmpty((Object)groups) && groups.length > 0) {
                boolean inGroup = false;
                block3: for (int g : groups) {
                    if (inGroup) continue block2;
                    for (int efg : ef.groups()) {
                        if (g != efg) continue;
                        inGroup = true;
                        annotationList.add(new Object[]{ef, f});
                        continue block3;
                    }
                }
                continue;
            }
            annotationList.add(new Object[]{ef, f});
        }
        block5: for (Method m : ms = cls.getDeclaredMethods()) {
            ExcelField ef = m.getAnnotation(ExcelField.class);
            if (!ObjectUtils.isNotEmpty((Object)ef) || ef.type() != 0 && ef.type() != 2) continue;
            if (ObjectUtils.isNotEmpty((Object)groups) && groups.length > 0) {
                boolean inGroup = false;
                block6: for (int g : groups) {
                    if (inGroup) continue block5;
                    for (int efg : ef.groups()) {
                        if (g != efg) continue;
                        inGroup = true;
                        annotationList.add(new Object[]{ef, m});
                        continue block6;
                    }
                }
                continue;
            }
            annotationList.add(new Object[]{ef, m});
        }
        Collections.sort(annotationList, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return new Integer(((ExcelField)o1[0]).sort()).compareTo(new Integer(((ExcelField)o2[0]).sort()));
            }
        });
        ArrayList dataList = Lists.newArrayList();
        for (int i = this.getDataRowNum(); i < this.getLastDataRowNum(); ++i) {
            E e = cls.newInstance();
            int column = 0;
            Row row = this.getRow(i);
            StringBuilder sb = new StringBuilder();
            for (Object[] os : annotationList) {
                Object val;
                if (ObjectUtils.isNotEmpty((Object)(val = this.getCellValue(row, column++)))) {
                    ExcelField ef = (ExcelField)os[0];
                    Class valType = Class.class;
                    if (os[1] instanceof Field) {
                        valType = ((Field)os[1]).getType();
                    } else if (os[1] instanceof Method) {
                        Method method = (Method)os[1];
                        if ("get".equals(method.getName().substring(0, 3))) {
                            valType = method.getReturnType();
                        } else if ("set".equals(method.getName().substring(0, 3))) {
                            valType = ((Method)os[1]).getParameterTypes()[0];
                        }
                    }
                    try {
                        val = valType == String.class ? String.valueOf(val.toString()) : (valType == Integer.class ? Integer.valueOf(Double.valueOf(val.toString()).intValue()) : (valType == Long.class ? Long.valueOf(Double.valueOf(val.toString()).longValue()) : (valType == Double.class ? Double.valueOf(val.toString()) : (valType == Float.class ? Float.valueOf(val.toString()) : (valType == Date.class ? DateUtil.getJavaDate((double)((Double)val)) : (ef.fieldType() != Class.class ? ef.fieldType().getMethod("getValue", String.class).invoke(null, val.toString()) : Class.forName(this.getClass().getName().replaceAll(this.getClass().getSimpleName(), "fieldtype." + valType.getSimpleName() + "Type")).getMethod("getValue", String.class).invoke(null, val.toString())))))));
                    }
                    catch (Exception ex) {
                        log.info("Get cell value [" + i + "," + column + "] error: " + ex.toString());
                        val = null;
                    }
                    if (os[1] instanceof Field) {
                        AnalysisObject.invokeSetter(e, ((Field)os[1]).getName(), val);
                    } else if (os[1] instanceof Method) {
                        String mthodName = ((Method)os[1]).getName();
                        if ("get".equals(mthodName.substring(0, 3))) {
                            mthodName = "set" + StringUtils.substringAfter((String)mthodName, (String)"get");
                        }
                        AnalysisObject.invokeMethod(e, mthodName, new Class[]{valType}, new Object[]{val});
                    }
                }
                sb.append(val + ", ");
            }
            dataList.add(e);
            log.debug("Read success: [" + i + "] " + sb.toString());
        }
        return dataList;
    }
}

