/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring.internal;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.KeyringStorageType;
import com.github.javakeyring.internal.KeyringBackend;
import java.lang.reflect.InvocationTargetException;

public class KeyringBackendFactory {
    public static KeyringBackend create() throws BackendNotSupportedException {
        KeyringStorageType[] keyringStorageTypeArray = KeyringStorageType.values();
        int n = keyringStorageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            KeyringStorageType keyRing = keyringStorageTypeArray[n2];
            KeyringBackend backend = KeyringBackendFactory.tryToCreateBackend(keyRing, false);
            if (backend != null) {
                return backend;
            }
            ++n2;
        }
        throw new BackendNotSupportedException("No available keyring backend found");
    }

    public static KeyringBackend create(KeyringStorageType preferred) throws BackendNotSupportedException {
        Exception cause;
        KeyringBackend backend;
        try {
            backend = KeyringBackendFactory.tryToCreateBackend(preferred, true);
            cause = null;
        }
        catch (Exception ex) {
            cause = ex;
            backend = null;
        }
        if (backend == null || cause != null) {
            throw new BackendNotSupportedException(String.format("The backend '%s' is not supported", new Object[]{preferred}), cause);
        }
        return backend;
    }

    private static KeyringBackend tryToCreateBackend(KeyringStorageType keyring, boolean throwing) throws BackendNotSupportedException {
        KeyringBackend backend;
        try {
            backend = keyring.getSupportingClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            if (throwing) {
                throw new BackendNotSupportedException("Could not instantiate backend", ex);
            }
            return null;
        }
        return backend;
    }
}

