/*
 * Decompiled with CFR 0.152.
 */
package com.github.javakeyring.internal.freedesktop;

import com.github.javakeyring.BackendNotSupportedException;
import com.github.javakeyring.PasswordAccessException;
import com.github.javakeyring.internal.KeyringBackend;
import com.github.javakeyring.internal.freedesktop.SimpleCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FreedesktopKeyringBackend
implements KeyringBackend {
    private final SimpleCollection collection;

    public FreedesktopKeyringBackend() throws BackendNotSupportedException {
        try {
            this.collection = new SimpleCollection();
        }
        catch (IOException ex) {
            throw new BackendNotSupportedException("Error connecting to dbus", ex);
        }
    }

    private Map<String, String> getMap(String service, String account) {
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("service", service);
        output.put("account", account);
        return output;
    }

    private String getLabel(String service, String account) {
        return String.valueOf(service) + "|" + account;
    }

    @Override
    public String getPassword(String service, String account) throws PasswordAccessException {
        List<String> objectPaths = this.getObjectPaths(this.getMap(service, account));
        if (objectPaths.size() > 1) {
            this.throwTooManyCredentialsException(service, account);
        }
        if (objectPaths.size() == 0) {
            this.throwNoExistingCredentialException(service, account);
        }
        return new String(this.collection.getSecret(objectPaths.get(0)));
    }

    private void throwTooManyCredentialsException(String service, String account) throws PasswordAccessException {
        throw new PasswordAccessException("Too many stored credentials match " + service + " account: " + account);
    }

    @Override
    public void setPassword(String service, String account, String password) throws PasswordAccessException {
        Map<String, String> attributes = this.getMap(service, account);
        String label = this.getLabel(service, account);
        List<String> objectPaths = this.getObjectPaths(attributes);
        if (objectPaths.size() > 1) {
            this.throwTooManyCredentialsException(service, account);
        }
        if (objectPaths.size() == 1) {
            this.collection.updateItem(objectPaths.get(0), label, password, attributes);
        } else {
            this.collection.createItem(label, password, attributes);
        }
    }

    private List<String> getObjectPaths(Map<String, String> attributes) {
        List<String> objectPaths = this.collection.getItems(attributes);
        if (objectPaths == null) {
            objectPaths = new ArrayList<String>();
        }
        return objectPaths;
    }

    @Override
    public void deletePassword(String service, String account) throws PasswordAccessException {
        List<String> objectPaths = this.getObjectPaths(this.getMap(service, account));
        if (objectPaths.size() > 1) {
            this.throwTooManyCredentialsException(service, account);
        }
        if (objectPaths.size() == 1) {
            this.collection.deleteItem(objectPaths.get(0));
        }
        if (objectPaths.size() == 0) {
            this.throwNoExistingCredentialException(service, account);
        }
    }

    private void throwNoExistingCredentialException(String service, String account) throws PasswordAccessException {
        throw new PasswordAccessException("No stored credentials match " + service + " account: " + account);
    }

    @Override
    public void close() throws Exception {
        this.collection.close();
    }
}

