/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.declarations;

import com.github.javaparser.symbolsolver.model.declarations.AccessLevel;
import com.github.javaparser.symbolsolver.model.declarations.FieldDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.MethodDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.TypeDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.TypeParametrizable;
import com.github.javaparser.symbolsolver.model.methods.MethodUsage;
import com.github.javaparser.symbolsolver.model.resolution.UnsolvedSymbolException;
import com.github.javaparser.symbolsolver.model.typesystem.ReferenceType;
import com.github.javaparser.symbolsolver.model.typesystem.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface ReferenceTypeDeclaration
extends TypeDeclaration,
TypeParametrizable {
    @Override
    default public ReferenceTypeDeclaration asReferenceType() {
        return this;
    }

    public List<ReferenceType> getAncestors();

    default public List<ReferenceType> getAllAncestors() {
        ArrayList<ReferenceType> ancestors = new ArrayList<ReferenceType>();
        if (!Object.class.getCanonicalName().equals(this.getQualifiedName())) {
            for (ReferenceType ancestor : this.getAncestors()) {
                ancestors.add(ancestor);
                for (ReferenceType inheritedAncestor : ancestor.getAllAncestors()) {
                    if (ancestors.contains(inheritedAncestor)) continue;
                    ancestors.add(inheritedAncestor);
                }
            }
        }
        return ancestors;
    }

    default public FieldDeclaration getField(String name) {
        Optional<FieldDeclaration> field = this.getAllFields().stream().filter(f -> f.getName().equals(name)).findFirst();
        if (field.isPresent()) {
            return field.get();
        }
        throw new UnsolvedSymbolException("Field not found: " + name);
    }

    default public FieldDeclaration getVisibleField(String name) {
        Optional<FieldDeclaration> field = this.getVisibleFields().stream().filter(f -> f.getName().equals(name)).findFirst();
        if (field.isPresent()) {
            return field.get();
        }
        throw new IllegalArgumentException();
    }

    default public boolean hasField(String name) {
        return this.getAllFields().stream().filter(f -> f.getName().equals(name)).findFirst().isPresent();
    }

    default public boolean hasVisibleField(String name) {
        return this.getVisibleFields().stream().filter(f -> f.getName().equals(name)).findFirst().isPresent();
    }

    public List<FieldDeclaration> getAllFields();

    default public List<FieldDeclaration> getVisibleFields() {
        return this.getAllFields().stream().filter(f -> f.declaringType().equals(this) || f.accessLevel() != AccessLevel.PRIVATE).collect(Collectors.toList());
    }

    default public List<FieldDeclaration> getAllNonStaticFields() {
        return this.getAllFields().stream().filter(it -> !it.isStatic()).collect(Collectors.toList());
    }

    default public List<FieldDeclaration> getAllStaticFields() {
        return this.getAllFields().stream().filter(it -> it.isStatic()).collect(Collectors.toList());
    }

    default public List<FieldDeclaration> getDeclaredFields() {
        return this.getAllFields().stream().filter(it -> it.declaringType().getQualifiedName().equals(this.getQualifiedName())).collect(Collectors.toList());
    }

    public Set<MethodDeclaration> getDeclaredMethods();

    public Set<MethodUsage> getAllMethods();

    public boolean isAssignableBy(Type var1);

    default public boolean canBeAssignedTo(ReferenceTypeDeclaration other) {
        return other.isAssignableBy(this);
    }

    public boolean isAssignableBy(ReferenceTypeDeclaration var1);

    public boolean hasDirectlyAnnotation(String var1);

    default public boolean hasAnnotation(String qualifiedName) {
        if (this.hasDirectlyAnnotation(qualifiedName)) {
            return true;
        }
        return this.getAllAncestors().stream().anyMatch(it -> it.asReferenceType().getTypeDeclaration().hasDirectlyAnnotation(qualifiedName));
    }

    public boolean isFunctionalInterface();

    @Override
    default public Optional<TypeParameterDeclaration> findTypeParameter(String name) {
        for (TypeParameterDeclaration tp : this.getTypeParameters()) {
            if (!tp.getName().equals(name)) continue;
            return Optional.of(tp);
        }
        if (this.containerType().isPresent()) {
            return this.containerType().get().findTypeParameter(name);
        }
        return Optional.empty();
    }
}

