/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.declarations;

import com.github.javaparser.symbolsolver.model.declarations.ClassDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.Declaration;
import com.github.javaparser.symbolsolver.model.declarations.EnumDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.InterfaceDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.ReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.resolution.UnsolvedSymbolException;
import java.util.Optional;
import java.util.Set;

public interface TypeDeclaration
extends Declaration {
    default public Set<ReferenceTypeDeclaration> internalTypes() {
        throw new UnsupportedOperationException("InternalTypes not available for " + this.getClass().getCanonicalName());
    }

    default public ReferenceTypeDeclaration getInternalType(String name) {
        Optional<ReferenceTypeDeclaration> type = this.internalTypes().stream().filter(f -> f.getName().equals(name)).findFirst();
        return type.orElseThrow(() -> new UnsolvedSymbolException("Internal type not found: " + name));
    }

    default public boolean hasInternalType(String name) {
        return this.internalTypes().stream().anyMatch(f -> f.getName().equals(name));
    }

    default public Optional<ReferenceTypeDeclaration> containerType() {
        throw new UnsupportedOperationException("containerType is not supported for " + this.getClass().getCanonicalName());
    }

    default public boolean isClass() {
        return false;
    }

    default public boolean isInterface() {
        return false;
    }

    default public boolean isEnum() {
        return false;
    }

    default public boolean isTypeParameter() {
        return false;
    }

    @Override
    default public boolean isType() {
        return true;
    }

    @Override
    default public TypeDeclaration asType() {
        return this;
    }

    default public ClassDeclaration asClass() {
        throw new UnsupportedOperationException(String.format("%s is not a class", this));
    }

    default public InterfaceDeclaration asInterface() {
        throw new UnsupportedOperationException(String.format("%s is not an interface", this));
    }

    default public EnumDeclaration asEnum() {
        throw new UnsupportedOperationException(String.format("%s is not an enum", this));
    }

    default public TypeParameterDeclaration asTypeParameter() {
        throw new UnsupportedOperationException(String.format("%s is not a type parameter", this));
    }

    default public ReferenceTypeDeclaration asReferenceType() {
        throw new UnsupportedOperationException(String.format("%s is not a reference type", this));
    }

    public String getPackageName();

    public String getClassName();

    public String getQualifiedName();

    default public String getId() {
        String qname = this.getQualifiedName();
        if (qname == null) {
            return String.format("<localClass>:%s", this.getName());
        }
        return qname;
    }
}

