/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.resolution;

import com.github.javaparser.symbolsolver.model.declarations.Declaration;
import java.util.Optional;

public class SymbolReference<S extends Declaration> {
    private Optional<? extends S> correspondingDeclaration;

    private SymbolReference(Optional<? extends S> correspondingDeclaration) {
        this.correspondingDeclaration = correspondingDeclaration;
    }

    public static <S extends Declaration, S2 extends S> SymbolReference<S> solved(S2 symbolDeclaration) {
        return new SymbolReference<S2>(Optional.of(symbolDeclaration));
    }

    public static <S extends Declaration, S2 extends S> SymbolReference<S> unsolved(Class<S2> clazz) {
        return new SymbolReference(Optional.empty());
    }

    public String toString() {
        return "SymbolReference{" + this.correspondingDeclaration + "}";
    }

    public S getCorrespondingDeclaration() {
        if (!this.isSolved()) {
            throw new UnsupportedOperationException();
        }
        return (S)((Declaration)this.correspondingDeclaration.get());
    }

    public boolean isSolved() {
        return this.correspondingDeclaration.isPresent();
    }

    public static <O extends Declaration> SymbolReference<O> adapt(SymbolReference<? extends O> ref, Class<O> clazz) {
        if (ref.isSolved()) {
            return SymbolReference.solved(ref.getCorrespondingDeclaration());
        }
        return SymbolReference.unsolved(clazz);
    }
}

