/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.typesystem;

import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.typesystem.Type;
import java.util.Map;

public class ArrayType
implements Type {
    private Type baseType;

    public ArrayType(Type baseType) {
        this.baseType = baseType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayType that = (ArrayType)o;
        return this.baseType.equals(that.baseType);
    }

    public int hashCode() {
        return this.baseType.hashCode();
    }

    public String toString() {
        return "ArrayTypeUsage{" + this.baseType + "}";
    }

    @Override
    public ArrayType asArrayType() {
        return this;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public String describe() {
        return this.baseType.describe() + "[]";
    }

    public Type getComponentType() {
        return this.baseType;
    }

    @Override
    public boolean isAssignableBy(Type other) {
        if (other.isArray()) {
            if (this.baseType.isPrimitive() && other.asArrayType().getComponentType().isPrimitive()) {
                return this.baseType.equals(other.asArrayType().getComponentType());
            }
            return this.baseType.isAssignableBy(other.asArrayType().getComponentType());
        }
        return other.isNull();
    }

    @Override
    public Type replaceTypeVariables(TypeParameterDeclaration tpToReplace, Type replaced, Map<TypeParameterDeclaration, Type> inferredTypes) {
        Type baseTypeReplaced = this.baseType.replaceTypeVariables(tpToReplace, replaced, inferredTypes);
        if (baseTypeReplaced == this.baseType) {
            return this;
        }
        return new ArrayType(baseTypeReplaced);
    }
}

