/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.typesystem;

import com.github.javaparser.symbolsolver.model.typesystem.Type;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class PrimitiveType
implements Type {
    public static final PrimitiveType BYTE = new PrimitiveType("byte", Byte.class.getCanonicalName(), (List<PrimitiveType>)ImmutableList.of());
    public static final PrimitiveType SHORT = new PrimitiveType("short", Short.class.getCanonicalName(), (List<PrimitiveType>)ImmutableList.of((Object)BYTE));
    public static final PrimitiveType CHAR = new PrimitiveType("char", Character.class.getCanonicalName(), (List<PrimitiveType>)ImmutableList.of());
    public static final PrimitiveType INT = new PrimitiveType("int", Integer.class.getCanonicalName(), (List<PrimitiveType>)ImmutableList.of((Object)BYTE, (Object)SHORT, (Object)CHAR));
    public static final PrimitiveType LONG = new PrimitiveType("long", Long.class.getCanonicalName(), (List<PrimitiveType>)ImmutableList.of((Object)BYTE, (Object)SHORT, (Object)INT, (Object)CHAR));
    public static final PrimitiveType BOOLEAN = new PrimitiveType("boolean", Boolean.class.getCanonicalName(), (List<PrimitiveType>)ImmutableList.of());
    public static final PrimitiveType FLOAT = new PrimitiveType("float", Float.class.getCanonicalName(), (List<PrimitiveType>)ImmutableList.of((Object)LONG, (Object)INT, (Object)SHORT, (Object)BYTE, (Object)CHAR));
    public static final PrimitiveType DOUBLE = new PrimitiveType("double", Double.class.getCanonicalName(), (List<PrimitiveType>)ImmutableList.of((Object)FLOAT, (Object)LONG, (Object)INT, (Object)SHORT, (Object)BYTE, (Object)CHAR));
    public static final List<PrimitiveType> ALL = ImmutableList.of((Object)INT, (Object)BOOLEAN, (Object)LONG, (Object)CHAR, (Object)FLOAT, (Object)DOUBLE, (Object)SHORT, (Object)BYTE);
    private String name;
    private String boxTypeQName;
    private List<PrimitiveType> promotionTypes;

    private PrimitiveType(String name, String boxTypeQName, List<PrimitiveType> promotionTypes) {
        this.name = name;
        this.boxTypeQName = boxTypeQName;
        this.promotionTypes = promotionTypes;
    }

    public static Type byName(String name) {
        name = name.toLowerCase();
        for (PrimitiveType ptu : ALL) {
            if (!ptu.describe().equals(name)) continue;
            return ptu;
        }
        throw new IllegalArgumentException("Name " + name);
    }

    public String toString() {
        return "PrimitiveTypeUsage{name='" + this.name + '\'' + '}';
    }

    @Override
    public PrimitiveType asPrimitive() {
        return this;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isReferenceType() {
        return false;
    }

    @Override
    public String describe() {
        return this.name;
    }

    @Override
    public boolean isTypeVariable() {
        return false;
    }

    @Override
    public boolean isAssignableBy(Type other) {
        if (other.isPrimitive()) {
            return this == other || this.promotionTypes.contains(other);
        }
        if (other.isReferenceType()) {
            if (other.asReferenceType().getQualifiedName().equals(this.boxTypeQName)) {
                return true;
            }
            for (PrimitiveType promotion : this.promotionTypes) {
                if (!other.asReferenceType().getQualifiedName().equals(promotion.boxTypeQName)) continue;
                return true;
            }
            return false;
        }
        if (other.isConstraint()) {
            return this.isAssignableBy(other.asConstraintType().getBound());
        }
        return false;
    }

    public String getBoxTypeQName() {
        return this.boxTypeQName;
    }
}

