/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.model.typesystem.parametrization;

import com.github.javaparser.symbolsolver.model.declarations.TypeParameterDeclaration;
import com.github.javaparser.symbolsolver.model.typesystem.Type;
import com.github.javaparser.symbolsolver.model.typesystem.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TypeParametersMap {
    private Map<String, Type> nameToValue = new HashMap<String, Type>();
    private Map<String, TypeParameterDeclaration> nameToDeclaration;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeParametersMap)) {
            return false;
        }
        TypeParametersMap that = (TypeParametersMap)o;
        return this.nameToValue.equals(that.nameToValue) && this.nameToDeclaration.equals(that.nameToDeclaration);
    }

    public int hashCode() {
        return this.nameToValue.hashCode();
    }

    public String toString() {
        return "TypeParametersMap{nameToValue=" + this.nameToValue + '}';
    }

    public static TypeParametersMap empty() {
        return new Builder().build();
    }

    private TypeParametersMap(Map<String, Type> nameToValue, Map<String, TypeParameterDeclaration> nameToDeclaration) {
        this.nameToValue.putAll(nameToValue);
        this.nameToDeclaration = new HashMap<String, TypeParameterDeclaration>();
        this.nameToDeclaration.putAll(nameToDeclaration);
    }

    public Type getValue(TypeParameterDeclaration typeParameter) {
        String qualifiedName = typeParameter.getQualifiedName();
        if (this.nameToValue.containsKey(qualifiedName)) {
            return this.nameToValue.get(qualifiedName);
        }
        return new TypeVariable(typeParameter);
    }

    public Optional<Type> getValueBySignature(String signature) {
        if (this.nameToValue.containsKey(signature)) {
            return Optional.of(this.nameToValue.get(signature));
        }
        return Optional.empty();
    }

    public List<String> getNames() {
        return new ArrayList<String>(this.nameToValue.keySet());
    }

    public List<Type> getTypes() {
        return new ArrayList<Type>(this.nameToValue.values());
    }

    public Builder toBuilder() {
        return new Builder(this.nameToValue, this.nameToDeclaration);
    }

    public boolean isEmpty() {
        return this.nameToValue.isEmpty();
    }

    public Type replaceAll(Type type) {
        HashMap<TypeParameterDeclaration, Type> inferredTypes = new HashMap<TypeParameterDeclaration, Type>();
        for (TypeParameterDeclaration typeParameterDeclaration : this.nameToDeclaration.values()) {
            type = type.replaceTypeVariables(typeParameterDeclaration, this.getValue(typeParameterDeclaration), inferredTypes);
        }
        return type;
    }

    public static class Builder {
        private Map<String, Type> nameToValue = new HashMap<String, Type>();
        private Map<String, TypeParameterDeclaration> nameToDeclaration;

        public Builder() {
            this.nameToDeclaration = new HashMap<String, TypeParameterDeclaration>();
        }

        private Builder(Map<String, Type> nameToValue, Map<String, TypeParameterDeclaration> nameToDeclaration) {
            this.nameToValue.putAll(nameToValue);
            this.nameToDeclaration = new HashMap<String, TypeParameterDeclaration>();
            this.nameToDeclaration.putAll(nameToDeclaration);
        }

        public TypeParametersMap build() {
            return new TypeParametersMap(this.nameToValue, this.nameToDeclaration);
        }

        public Builder setValue(TypeParameterDeclaration typeParameter, Type value) {
            String qualifiedName = typeParameter.getQualifiedName();
            this.nameToValue.put(qualifiedName, value);
            this.nameToDeclaration.put(qualifiedName, typeParameter);
            return this;
        }
    }
}

