/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.web.log;

import com.github.yt.web.YtWebConfig;
import com.github.yt.web.log.HttpHelper;
import com.github.yt.web.log.RequestLog;
import com.github.yt.web.log.RequestLogEntity;
import com.github.yt.web.util.JsonUtils;
import com.github.yt.web.util.SpringContextUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class RequestLogInterceptor
implements HandlerInterceptor {
    private final Logger logger = LoggerFactory.getLogger(RequestLogInterceptor.class);

    private String getInputStr(HttpServletRequest httpServletRequest) {
        if ("POST".equalsIgnoreCase(httpServletRequest.getMethod())) {
            return HttpHelper.getBodyString((ServletRequest)httpServletRequest);
        }
        return "";
    }

    private static String getIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private boolean isLog(HttpServletRequest request, Object handler) {
        String path = request.getServletPath();
        if (path.startsWith("/swagger")) {
            return false;
        }
        if (path.startsWith("/v2/api-docs")) {
            return false;
        }
        if (path.startsWith("/v3/api-docs")) {
            return false;
        }
        if (!(handler instanceof HandlerMethod)) {
            return false;
        }
        if (!this.logger.isDebugEnabled()) {
            return false;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        RequestLog methodRequestLog = (RequestLog)handlerMethod.getMethodAnnotation(RequestLog.class);
        RequestLog classRequestLog = handlerMethod.getBeanType().getAnnotation(RequestLog.class);
        if (methodRequestLog != null) {
            return methodRequestLog.value();
        }
        if (classRequestLog != null) {
            return classRequestLog.value();
        }
        YtWebConfig ytWebConfig = SpringContextUtils.getBean(YtWebConfig.class);
        return ytWebConfig.getRequest().isRequestLog();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        request.setAttribute("requestTime", (Object)new Date());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        YtWebConfig ytWebConfig;
        if (!this.isLog(request, handler)) {
            return;
        }
        Date requestTime = (Date)request.getAttribute("requestTime");
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        RequestLogEntity requestLogEntity = new RequestLogEntity();
        requestLogEntity.setRequestTime(requestTime);
        requestLogEntity.setIpAddress(RequestLogInterceptor.getIpAddress(request));
        requestLogEntity.setRequestUri(request.getRequestURI());
        requestLogEntity.setUserAgent(request.getHeader("User-Agent"));
        requestLogEntity.setClassMethodName(handlerMethod.getMethod().toString());
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headerMap = new HashMap<String, String>(16);
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String header = request.getHeader(headerName);
            headerMap.put(headerName, header);
        }
        if (!headerMap.isEmpty()) {
            requestLogEntity.setHeaderParams(JsonUtils.toJsonString(headerMap));
        }
        if (request.getParameterMap() != null && !request.getParameterMap().isEmpty()) {
            requestLogEntity.setUrlParams(JsonUtils.toJsonString(request.getParameterMap()));
        }
        if ((ytWebConfig = SpringContextUtils.getBean(YtWebConfig.class)).getRequest().isRequestLogBody()) {
            requestLogEntity.setRequestBody(this.getInputStr(request));
        }
        requestLogEntity.setInvokingTime((int)(System.currentTimeMillis() - requestLogEntity.getRequestTime().getTime()));
        requestLogEntity.setResponseBody(JsonUtils.toJsonString(request.getAttribute("yt:request_result_entity")));
        Exception e = (Exception)request.getAttribute("yt:request_exception");
        if (e != null) {
            requestLogEntity.setError(true);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            requestLogEntity.setErrorStackTrace(sw.getBuffer().toString());
            requestLogEntity.setErrorMessage(e.toString());
        } else {
            requestLogEntity.setError(false);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(JsonUtils.toJsonString(requestLogEntity));
        }
    }
}

