/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.web.query;

import com.github.yt.commons.query.PageQuery;
import com.github.yt.web.YtWebConfig;
import com.github.yt.web.util.SpringContextUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=1000)
@Component
public class QueryControllerAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Set<Method> METHOD_SET = new HashSet<Method>();
    private static final Map<Method, Integer> QUERY_METHOD_MAP = new HashMap<Method, Integer>();

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) || @annotation(org.springframework.web.bind.annotation.GetMapping) || @annotation(org.springframework.web.bind.annotation.PostMapping)")
    public void allController() {
    }

    @Around(value="allController() ")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        block8: {
            try {
                int pageNoNum;
                int pageSizeNum;
                MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
                Object target = proceedingJoinPoint.getTarget();
                Method currentMethod = target.getClass().getMethod(methodSignature.getName(), methodSignature.getParameterTypes());
                if (!METHOD_SET.contains(currentMethod)) {
                    METHOD_SET.add(currentMethod);
                    Class[] classes = methodSignature.getParameterTypes();
                    for (int i = 0; i < classes.length; ++i) {
                        if (!PageQuery.class.isAssignableFrom(classes[i])) continue;
                        QUERY_METHOD_MAP.put(currentMethod, i);
                    }
                }
                if (!QUERY_METHOD_MAP.containsKey(currentMethod)) break block8;
                RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
                HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(requestAttributes)).getRequest();
                YtWebConfig ytWebConfig = SpringContextUtils.getBean(YtWebConfig.class);
                String pageNoStr = request.getParameter(ytWebConfig.getPage().getPageNoName());
                String pageSizeStr = request.getParameter(ytWebConfig.getPage().getPageSizeName());
                PageQuery pageQuery = (PageQuery)proceedingJoinPoint.getArgs()[QUERY_METHOD_MAP.get(currentMethod)];
                try {
                    pageSizeNum = pageSizeStr == null || pageSizeStr.isEmpty() ? 10 : Integer.parseInt(pageSizeStr);
                }
                catch (NumberFormatException e) {
                    pageSizeNum = 10;
                }
                try {
                    pageNoNum = pageNoStr == null || pageNoStr.isEmpty() ? 1 : Integer.parseInt(pageNoStr);
                }
                catch (NumberFormatException e) {
                    pageNoNum = 1;
                }
                pageQuery.makePageNo(Integer.valueOf(pageNoNum));
                pageQuery.makePageSize(Integer.valueOf(pageSizeNum));
            }
            catch (Exception e) {
                this.logger.warn("\u8bbe\u7f6e Query \u7684 pageNo\u3001pageSize \u5f02\u5e38", (Throwable)e);
            }
        }
        return proceedingJoinPoint.proceed();
    }
}

