/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.web.result;

import com.github.yt.commons.exception.BaseException;
import com.github.yt.web.YtWebConfig;
import com.github.yt.web.result.BaseResultConfig;
import com.github.yt.web.result.HttpResultEntity;
import com.github.yt.web.util.JsonUtils;
import com.github.yt.web.util.SpringContextUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpResultHandler.class);
    private static volatile BaseResultConfig resultConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BaseResultConfig getResultConfig() {
        if (resultConfig != null) return resultConfig;
        Class<HttpResultHandler> clazz = HttpResultHandler.class;
        synchronized (HttpResultHandler.class) {
            try {
                YtWebConfig ytWebConfig = SpringContextUtils.getBean(YtWebConfig.class);
                resultConfig = ytWebConfig.getResult().getResultConfigClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("\u5b9e\u4f8b\u5316 BaseResultConfig \u7c7b\u5f02\u5e38", e);
            }
            return resultConfig;
        }
    }

    public static HttpResultEntity getSuccessSimpleResultBody() {
        return HttpResultHandler.getSuccessSimpleResultBody(null);
    }

    public static HttpResultEntity getSuccessSimpleResultBody(Object result) {
        return HttpResultHandler.getSuccessMoreResultBody(result, false, null);
    }

    public static HttpResultEntity getSuccessMoreResultBody(Object result, Object moreResult) {
        return HttpResultHandler.getSuccessMoreResultBody(result, true, moreResult);
    }

    private static HttpResultEntity getSuccessMoreResultBody(Object result, boolean withMore, Object moreResult) {
        HttpResultEntity resultBody = new HttpResultEntity();
        resultBody.put(HttpResultHandler.getResultConfig().getErrorCodeField(), HttpResultHandler.getResultConfig().getDefaultSuccessCode());
        resultBody.put(HttpResultHandler.getResultConfig().getMessageField(), HttpResultHandler.getResultConfig().getDefaultSuccessMessage());
        resultBody.put(HttpResultHandler.getResultConfig().getResultField(), result);
        resultBody.put(HttpResultHandler.getResultConfig().getUuidField(), HttpResultHandler.getRequest().getAttribute("__REQUEST_UUID__"));
        if (withMore) {
            resultBody.put(HttpResultHandler.getResultConfig().getMoreResultField(), moreResult);
        }
        return resultBody;
    }

    public static HttpResultEntity getErrorSimpleResultBody(Throwable exception) {
        HttpResultEntity resultBody = new HttpResultEntity();
        if (exception instanceof BaseException) {
            BaseException baseException = (BaseException)exception;
            resultBody.put(HttpResultHandler.getResultConfig().getErrorCodeField(), HttpResultHandler.getResultConfig().convertErrorCode(baseException.getErrorCode()));
            resultBody.put(HttpResultHandler.getResultConfig().getMessageField(), exception.getMessage());
            resultBody.put(HttpResultHandler.getResultConfig().getResultField(), baseException.getErrorResult());
        } else {
            resultBody.put(HttpResultHandler.getResultConfig().getErrorCodeField(), HttpResultHandler.getResultConfig().getDefaultErrorCode());
            resultBody.put(HttpResultHandler.getResultConfig().getMessageField(), HttpResultHandler.getResultConfig().getDefaultErrorMessage());
            resultBody.put(HttpResultHandler.getResultConfig().getResultField(), null);
        }
        resultBody.put(HttpResultHandler.getResultConfig().getUuidField(), HttpResultHandler.getRequest().getAttribute("__REQUEST_UUID__"));
        YtWebConfig ytWebConfig = SpringContextUtils.getBean(YtWebConfig.class);
        if (ytWebConfig.getResult().isReturnStackTrace()) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter((Writer)stringWriter, true));
            resultBody.put(HttpResultHandler.getResultConfig().getStackTraceField(), stringWriter.getBuffer());
        }
        return resultBody;
    }

    public static void writeExceptionResult(Throwable e, HttpServletRequest request, HttpServletResponse response) {
        logger.error(e.getMessage(), e);
        HttpResultEntity resultBody = HttpResultHandler.getErrorSimpleResultBody(e);
        YtWebConfig ytWebConfig = SpringContextUtils.getBean(YtWebConfig.class);
        response.setStatus(ytWebConfig.getResult().getErrorState());
        response.addHeader("Content-type", "application/json;charset=UTF-8");
        request.setAttribute("yt:request_result_entity", (Object)resultBody);
        String result = JsonUtils.toJsonString(resultBody);
        try {
            response.getWriter().write(result);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return ((ServletRequestAttributes)Objects.requireNonNull(requestAttributes)).getRequest();
    }
}

