/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.web.result;

import com.github.yt.commons.exception.BaseException;
import com.github.yt.commons.exception.BaseExceptionConverter;
import com.github.yt.commons.query.IPage;
import com.github.yt.web.YtWebConfig;
import com.github.yt.web.result.HttpResultEntity;
import com.github.yt.web.result.HttpResultHandler;
import com.github.yt.web.result.PackageResponseBody;
import com.github.yt.web.util.JsonUtils;
import com.github.yt.web.util.SpringContextUtils;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=200)
@ControllerAdvice
public class PackageResponseBodyAdvice
implements ResponseBodyAdvice<Object>,
ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String REQUEST_EXCEPTION = "yt:request_exception";
    public static final String REQUEST_RESULT_ENTITY = "yt:request_result_entity";
    public static final String REQUEST_BEFORE_BODY_WRITE = "yt:request_before_body_write";
    private ApplicationContext applicationContext;
    private final YtWebConfig ytWebConfig;

    public PackageResponseBodyAdvice(YtWebConfig ytWebConfig) {
        this.ytWebConfig = ytWebConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @PackageResponseBody(value=false)
    public void handleExceptions405(Throwable e) throws Throwable {
        throw e;
    }

    @ExceptionHandler
    @PackageResponseBody(value=false)
    public HttpResultEntity handleExceptions(Throwable e, HandlerMethod handlerMethod, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Throwable se = this.convertToKnownException(e);
        request.setAttribute(REQUEST_EXCEPTION, (Object)se);
        if (!this.exceptionPackageResponseBody(request, handlerMethod.getMethod())) {
            throw e;
        }
        Object beforeBodyWrite = request.getAttribute(REQUEST_BEFORE_BODY_WRITE);
        if (beforeBodyWrite != null) {
            throw se;
        }
        this.logger.error(e.getMessage(), e);
        HttpResultEntity resultBody = HttpResultHandler.getErrorSimpleResultBody(e);
        YtWebConfig ytWebConfig = SpringContextUtils.getBean(YtWebConfig.class);
        response.setStatus(ytWebConfig.getResult().getErrorState());
        response.addHeader("Content-type", "application/json;charset=UTF-8");
        request.setAttribute(REQUEST_RESULT_ENTITY, (Object)resultBody);
        return resultBody;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        HttpServletRequest request = ((ServletServerHttpRequest)serverHttpRequest).getServletRequest();
        YtWebConfig.Page pageConfig = this.ytWebConfig.getPage();
        if (pageConfig.isConvertPage() && body instanceof IPage) {
            LinkedHashMap<String, Object> pageResultEntity;
            IPage page = (IPage)body;
            body = pageResultEntity = new LinkedHashMap<String, Object>();
            pageResultEntity.put(pageConfig.getPageNoName(), page.getPageNo());
            pageResultEntity.put(pageConfig.getPageSizeName(), page.getPageSize());
            pageResultEntity.put(pageConfig.getPageTotalCountName(), page.getTotalCount());
            pageResultEntity.put(pageConfig.getPageDataName(), page.getData());
        }
        request.setAttribute(REQUEST_RESULT_ENTITY, (Object)body);
        if (!this.successPackageResponseBody(request, Objects.requireNonNull(returnType.getMethod()))) {
            return body;
        }
        HttpResultEntity resultBody = HttpResultEntity.class.isAssignableFrom(returnType.getMethod().getReturnType()) ? (HttpResultEntity)body : HttpResultHandler.getSuccessSimpleResultBody(body);
        request.setAttribute(REQUEST_RESULT_ENTITY, (Object)resultBody);
        request.setAttribute(REQUEST_BEFORE_BODY_WRITE, new Object());
        serverHttpResponse.setStatusCode(HttpStatus.OK);
        serverHttpResponse.getHeaders().add("Content-type", "application/json;charset=UTF-8");
        if (body instanceof String || returnType.getMethod().getReturnType().equals(String.class)) {
            return JsonUtils.toJsonString(resultBody);
        }
        return resultBody;
    }

    private Throwable convertToKnownException(Throwable e) {
        if (e instanceof BaseException) {
            return e;
        }
        Map exceptionConverterMap = this.applicationContext.getBeansOfType(BaseExceptionConverter.class);
        for (BaseExceptionConverter baseExceptionConverter : exceptionConverterMap.values()) {
            Throwable knownException = baseExceptionConverter.convertToBaseException(e);
            if (!(knownException instanceof BaseException)) continue;
            return knownException;
        }
        return e;
    }

    private boolean exceptionPackageResponseBody(HttpServletRequest request, Method method) {
        String path = request.getServletPath();
        if (path.startsWith("/actuator")) {
            return false;
        }
        if (ResponseEntity.class.isAssignableFrom(method.getReturnType())) {
            return false;
        }
        if (HttpResultEntity.class.isAssignableFrom(method.getReturnType())) {
            return true;
        }
        return this.packageResponseBody(method);
    }

    private boolean successPackageResponseBody(HttpServletRequest request, Method method) {
        String path = request.getServletPath();
        if (path.startsWith("/actuator")) {
            return false;
        }
        if (ResponseEntity.class.isAssignableFrom(method.getReturnType())) {
            return false;
        }
        return this.packageResponseBody(method);
    }

    private boolean packageResponseBody(Method method) {
        PackageResponseBody methodPackageResponseBody = method.getAnnotation(PackageResponseBody.class);
        PackageResponseBody classPackageResponseBody = method.getDeclaringClass().getAnnotation(PackageResponseBody.class);
        if (methodPackageResponseBody != null) {
            return methodPackageResponseBody.value();
        }
        if (classPackageResponseBody != null) {
            return classPackageResponseBody.value();
        }
        return this.ytWebConfig.getResult().isPackageResponseBody();
    }
}

