/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.web.result;

import com.github.yt.commons.exception.BaseAccidentException;
import com.github.yt.commons.exception.BaseExceptionConverter;
import com.github.yt.commons.util.YtStringUtils;
import com.github.yt.web.YtWebExceptionEnum;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@Component
public class ValidatorExceptionConverter
implements BaseExceptionConverter {
    public Throwable convertToBaseException(Throwable e) {
        if (e instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)e;
            Set cvSet = cve.getConstraintViolations();
            List errorMessageList = cvSet.stream().map(ConstraintViolation::getMessage).collect(Collectors.toList());
            return new BaseAccidentException((Enum)YtWebExceptionEnum.CODE_11, e, new Object[]{YtStringUtils.join(errorMessageList, (String)", ")});
        }
        if (e instanceof BindException) {
            BindException be = (BindException)e;
            List errorList = be.getAllErrors();
            List errorMessageList = errorList.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
            return new BaseAccidentException((Enum)YtWebExceptionEnum.CODE_11, e, new Object[]{YtStringUtils.join(errorMessageList, (String)", ")});
        }
        if (e instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException exception = (MethodArgumentNotValidException)e;
            List errorList = exception.getBindingResult().getAllErrors();
            List errorMessageList = errorList.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
            return new BaseAccidentException((Enum)YtWebExceptionEnum.CODE_11, e, new Object[]{YtStringUtils.join(errorMessageList, (String)", ")});
        }
        if (e instanceof HttpMessageNotReadableException) {
            return new BaseAccidentException((Enum)YtWebExceptionEnum.CODE_12, e, new Object[]{e.getMessage()});
        }
        if (e instanceof MethodArgumentTypeMismatchException) {
            MethodArgumentTypeMismatchException se = (MethodArgumentTypeMismatchException)e;
            return new BaseAccidentException((Enum)YtWebExceptionEnum.CODE_11, e, new Object[]{"\u53c2\u6570:" + se.getName() + ", \u503c:" + se.getValue()});
        }
        if (e instanceof MaxUploadSizeExceededException) {
            return new BaseAccidentException((Enum)YtWebExceptionEnum.CODE_13, e, new Object[0]);
        }
        if (e instanceof MissingServletRequestPartException) {
            MissingServletRequestPartException missingServletRequestPartException = (MissingServletRequestPartException)e;
            return new BaseAccidentException((Enum)YtWebExceptionEnum.CODE_11, e, new Object[]{"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570 " + missingServletRequestPartException.getRequestPartName()});
        }
        return e;
    }
}

