/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.web.unittest;

import com.github.yt.commons.exception.ExceptionUtils;
import com.github.yt.web.result.HttpResultHandler;
import com.github.yt.web.unittest.InitApplication;
import com.github.yt.web.util.JsonUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ControllerTestHandler {
    private static ResultActions getResultActions(String url, MultiValueMap<String, String> paramMap, Object code, boolean isPackaged) {
        if (code instanceof Enum) {
            code = HttpResultHandler.getResultConfig().convertErrorCode(ExceptionUtils.getExceptionCode((Enum)((Enum)code)));
        }
        try {
            ResultActions resultActions = InitApplication.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.get((String)url, (Object[])new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON_UTF8}).params(paramMap).headers(InitApplication.getHttpHeaders())).andDo(MockMvcResultHandlers.print());
            if (isPackaged) {
                resultActions.andExpect(MockMvcResultMatchers.jsonPath((String)("$." + HttpResultHandler.getResultConfig().getErrorCodeField()), (Matcher)Matchers.equalTo((Object)code)));
            }
            return resultActions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ResultActions postResultActions(String url, Object jsonBody, MultiValueMap<String, String> paramMap, Object code) {
        if (code instanceof Enum) {
            code = HttpResultHandler.getResultConfig().convertErrorCode(ExceptionUtils.getExceptionCode((Enum)((Enum)code)));
        }
        if (jsonBody == null) {
            jsonBody = "{}";
        }
        try {
            String jsonStr = jsonBody instanceof String ? (String)jsonBody : JsonUtils.toJsonString(jsonBody);
            ResultActions resultActions = InitApplication.getMockMvc().perform((RequestBuilder)MockMvcRequestBuilders.post((String)url, (Object[])new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON_UTF8}).contentType(MediaType.APPLICATION_JSON_UTF8).content(jsonStr).content(jsonStr.getBytes()).params(paramMap).headers(InitApplication.getHttpHeaders()));
            resultActions.andExpect(MockMvcResultMatchers.jsonPath((String)("$." + HttpResultHandler.getResultConfig().getErrorCodeField()), (Matcher)Matchers.equalTo((Object)code)));
            return resultActions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ResultActions get(String url, LinkedMultiValueMap<String, String> param, Object code) {
        return ControllerTestHandler.getResultActions(url, param, code, true);
    }

    public static ResultActions get(String url, LinkedMultiValueMap<String, String> param) {
        return ControllerTestHandler.getResultActions(url, param, HttpResultHandler.getResultConfig().getDefaultSuccessCode(), true);
    }

    public static ResultActions get(String url, Object code) {
        return ControllerTestHandler.getResultActions(url, (MultiValueMap<String, String>)new LinkedMultiValueMap(), code, true);
    }

    public static ResultActions get(String url, boolean isPackaged) {
        return ControllerTestHandler.getResultActions(url, (MultiValueMap<String, String>)new LinkedMultiValueMap(), HttpResultHandler.getResultConfig().getDefaultSuccessCode(), isPackaged);
    }

    public static ResultActions get(String url) {
        return ControllerTestHandler.get(url, (LinkedMultiValueMap<String, String>)new LinkedMultiValueMap(), HttpResultHandler.getResultConfig().getDefaultSuccessCode());
    }

    public static ResultActions getWithObjectParam(String url, Object paramObject) {
        return ControllerTestHandler.getWithObjectParam(url, paramObject, HttpResultHandler.getResultConfig().getDefaultSuccessCode());
    }

    public static ResultActions getWithObjectParam(String url, Object paramObject, Object code) {
        return ControllerTestHandler.get(ControllerTestHandler.parseToUrlPair(url, paramObject), (LinkedMultiValueMap<String, String>)new LinkedMultiValueMap(), code);
    }

    public static ResultActions post(String url, Object jsonBody, LinkedMultiValueMap<String, String> param, Object code) {
        return ControllerTestHandler.postResultActions(url, jsonBody, param, code);
    }

    public static ResultActions post(String url, Object jsonBody, LinkedMultiValueMap<String, String> param) {
        return ControllerTestHandler.postResultActions(url, jsonBody, param, HttpResultHandler.getResultConfig().getDefaultSuccessCode());
    }

    public static ResultActions post(String url, Object jsonBody, Object code) {
        return ControllerTestHandler.postResultActions(url, jsonBody, (MultiValueMap<String, String>)new LinkedMultiValueMap(), code);
    }

    public static ResultActions post(String url, Object jsonBody) {
        return ControllerTestHandler.postResultActions(url, jsonBody, (MultiValueMap<String, String>)new LinkedMultiValueMap(), HttpResultHandler.getResultConfig().getDefaultSuccessCode());
    }

    public static ResultActions post(String url) {
        return ControllerTestHandler.postResultActions(url, "{}", (MultiValueMap<String, String>)new LinkedMultiValueMap(), HttpResultHandler.getResultConfig().getDefaultSuccessCode());
    }

    public static String parseToUrlPair(String url, Object o) {
        String params = ControllerTestHandler.parseToUrlPair(o);
        if (!url.contains("?")) {
            url = url + "?";
        }
        if (!url.endsWith("&")) {
            url = url + "&";
        }
        return url + params;
    }

    public static String parseToUrlPair(Object o) {
        Class<?> c = o.getClass();
        List<Field> fields = ControllerTestHandler.getFieldList(c);
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Field field : fields) {
            Object value;
            field.setAccessible(true);
            String name = field.getName();
            try {
                value = field.get(o);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (value == null) continue;
            map.put(name, value);
        }
        Set set = map.entrySet();
        Iterator it = set.iterator();
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            sb.append((String)e.getKey()).append("=").append(e.getValue()).append("&");
        }
        return sb.toString();
    }

    private static List<Field> getFieldList(Class<?> entityClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> c = entityClass; c != Object.class; c = c.getSuperclass()) {
            fieldList.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fieldList;
    }
}

