/*
 * Decompiled with CFR 0.152.
 */
package com.github.yt.web.unittest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.yt.web.YtWebConfig;
import com.github.yt.web.result.BaseResultConfig;
import com.github.yt.web.result.HttpResultHandler;
import com.github.yt.web.util.JsonUtils;
import com.github.yt.web.util.SpringContextUtils;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.ResultActions;

public class HttpRestHandler {
    public static <T> T getResult(ResultActions resultActions, Class<T> resultType) {
        return HttpRestHandler.getResult(HttpRestHandler.responseToString(resultActions), resultType);
    }

    public static <T> T getResult(String json, Class<T> resultType) {
        try {
            Object result = HttpRestHandler.getResult(json);
            if (result instanceof Map) {
                ObjectMapper objectMapper = new ObjectMapper();
                return (T)objectMapper.readValue(JsonUtils.toJsonString(result), resultType);
            }
            return (T)result;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> getListResult(ResultActions resultActions, Class<T> resultType) {
        String jsonResult = HttpRestHandler.responseToString(resultActions);
        Object result = HttpRestHandler.getResult(jsonResult);
        return HttpRestHandler.getListResult(result, resultType);
    }

    public static <T> List<T> getPageListResult(ResultActions resultActions, Class<T> resultType) {
        String jsonResult = HttpRestHandler.responseToString(resultActions);
        Object result = HttpRestHandler.getResult(jsonResult);
        if (result instanceof Map) {
            YtWebConfig ytWebConfig = SpringContextUtils.getBean(YtWebConfig.class);
            Object listData = ((Map)result).get(ytWebConfig.getPage().getPageDataName());
            return HttpRestHandler.getListResult(listData, resultType);
        }
        throw new RuntimeException("\u7ed3\u679c\u96c6\u4e0d\u662f\u96c6\u5408\u7c7b\u578b");
    }

    private static <T> List<T> getListResult(Object listData, Class<T> resultType) {
        ObjectMapper objectMapper = new ObjectMapper();
        if (listData instanceof List) {
            ArrayList resultList = new ArrayList();
            ((List)listData).forEach(resultEntity -> {
                try {
                    Object t = objectMapper.readValue(JsonUtils.toJsonString(resultEntity), resultType);
                    resultList.add(t);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            });
            return resultList;
        }
        throw new RuntimeException("\u7ed3\u679c\u96c6\u4e0d\u662f\u96c6\u5408\u7c7b\u578b");
    }

    private static Object getValue(Object source, String fieldName) {
        try {
            Field field = HttpRestHandler.getField(source.getClass(), fieldName);
            field.setAccessible(true);
            return field.get(source);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getField(Class<?> clazz, String fieldName) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        if (clazz.getSuperclass() == null || clazz.getSuperclass().equals(Object.class)) {
            throw new RuntimeException("\u5c5e\u6027\u4e0d\u5b58\u5728");
        }
        return HttpRestHandler.getField(clazz.getSuperclass(), fieldName);
    }

    private static String responseToString(ResultActions resultActions) {
        MvcResult mvcResult = resultActions.andReturn();
        MockHttpServletResponse mockHttpServletResponse = mvcResult.getResponse();
        try {
            PrintWriter printWriter = mockHttpServletResponse.getWriter();
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)HttpRestHandler.getValue(printWriter, "out");
            return HttpRestHandler.getValue(outputStreamWriter, "lock").toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object getResult(String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            HashMap jsonObject = (HashMap)objectMapper.readValue(json, HashMap.class);
            BaseResultConfig baseResultConfig = HttpResultHandler.getResultConfig();
            return jsonObject.get(baseResultConfig.getResultField());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

