/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.paypal;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.ContentType;
import com.ijpay.core.IJPayHttpResponse;
import com.ijpay.core.kit.HttpKit;
import com.ijpay.core.kit.PayKit;
import com.ijpay.paypal.PayPalApiConfig;
import com.ijpay.paypal.accesstoken.AccessToken;
import com.ijpay.paypal.accesstoken.AccessTokenKit;
import com.ijpay.paypal.enums.PayPalApiUrl;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class PayPalApi {
    public static String getReqUrl(PayPalApiUrl payPalApiUrl, boolean isSandBox) {
        return (isSandBox ? PayPalApiUrl.SANDBOX_GATEWAY.getUrl() : PayPalApiUrl.LIVE_GATEWAY.getUrl()).concat(payPalApiUrl.getUrl());
    }

    public static IJPayHttpResponse getToken(PayPalApiConfig config) {
        HashMap<String, String> headers = new HashMap<String, String>(3);
        headers.put("Accept", ContentType.JSON.toString());
        headers.put("Content-Type", ContentType.FORM_URLENCODED.toString());
        headers.put("Authorization", "Basic ".concat(Base64.encode((byte[])config.getClientId().concat(":").concat(config.getSecret()).getBytes(StandardCharsets.UTF_8))));
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("grant_type", "client_credentials");
        return PayPalApi.post(PayPalApi.getReqUrl(PayPalApiUrl.GET_TOKEN, config.isSandBox()), params, headers);
    }

    public static IJPayHttpResponse createOrder(PayPalApiConfig config, String data) {
        AccessToken accessToken = AccessTokenKit.get(config.getClientId());
        return PayPalApi.post(PayPalApi.getReqUrl(PayPalApiUrl.CHECKOUT_ORDERS, config.isSandBox()), data, PayPalApi.getBaseHeaders(accessToken));
    }

    public static IJPayHttpResponse updateOrder(PayPalApiConfig config, String id, String data) {
        AccessToken accessToken = AccessTokenKit.get(config.getClientId());
        String url = PayPalApi.getReqUrl(PayPalApiUrl.CHECKOUT_ORDERS, config.isSandBox()).concat("/").concat(id);
        return PayPalApi.patch(url, data, PayPalApi.getBaseHeaders(accessToken));
    }

    public static IJPayHttpResponse queryOrder(PayPalApiConfig config, String orderId) {
        AccessToken accessToken = AccessTokenKit.get(config.getClientId());
        String url = PayPalApi.getReqUrl(PayPalApiUrl.CHECKOUT_ORDERS, config.isSandBox()).concat("/").concat(orderId);
        return PayPalApi.get(url, null, PayPalApi.getBaseHeaders(accessToken));
    }

    public static IJPayHttpResponse captureOrder(PayPalApiConfig config, String id, String data) {
        AccessToken accessToken = AccessTokenKit.get(config.getClientId());
        String url = String.format(PayPalApi.getReqUrl(PayPalApiUrl.CAPTURE_ORDER, config.isSandBox()), id);
        return PayPalApi.post(url, data, PayPalApi.getBaseHeaders(accessToken));
    }

    public static IJPayHttpResponse captureQuery(PayPalApiConfig config, String captureId) {
        AccessToken accessToken = AccessTokenKit.get(config.getClientId());
        String url = String.format(PayPalApi.getReqUrl(PayPalApiUrl.CAPTURE_QUERY, config.isSandBox()), captureId);
        return PayPalApi.get(url, null, PayPalApi.getBaseHeaders(accessToken));
    }

    public static IJPayHttpResponse refund(PayPalApiConfig config, String captureId, String data) {
        AccessToken accessToken = AccessTokenKit.get(config.getClientId());
        String url = String.format(PayPalApi.getReqUrl(PayPalApiUrl.REFUND, config.isSandBox()), captureId);
        return PayPalApi.post(url, data, PayPalApi.getBaseHeaders(accessToken));
    }

    public static IJPayHttpResponse refundQuery(PayPalApiConfig config, String id) {
        AccessToken accessToken = AccessTokenKit.get(config.getClientId());
        String url = String.format(PayPalApi.getReqUrl(PayPalApiUrl.REFUND_QUERY, config.isSandBox()), id);
        return PayPalApi.get(url, null, PayPalApi.getBaseHeaders(accessToken));
    }

    public static IJPayHttpResponse post(String url, Map<String, Object> params, Map<String, String> headers) {
        return HttpKit.getDelegate().post(url, params, headers);
    }

    public static IJPayHttpResponse get(String url, Map<String, Object> params, Map<String, String> headers) {
        return HttpKit.getDelegate().get(url, params, headers);
    }

    public static IJPayHttpResponse post(String url, String data, Map<String, String> headers) {
        return HttpKit.getDelegate().post(url, data, headers);
    }

    public static IJPayHttpResponse patch(String url, String data, Map<String, String> headers) {
        return HttpKit.getDelegate().patch(url, data, headers);
    }

    public static Map<String, String> getBaseHeaders(AccessToken accessToken) {
        return PayPalApi.getBaseHeaders(accessToken, PayKit.generateStr(), null, null);
    }

    public static Map<String, String> getBaseHeaders(AccessToken accessToken, String payPalRequestId, String payPalPartnerAttributionId, String prefer) {
        if (accessToken == null || StrUtil.isEmpty((CharSequence)accessToken.getTokenType()) || StrUtil.isEmpty((CharSequence)accessToken.getAccessToken())) {
            throw new RuntimeException("accessToken is null");
        }
        HashMap<String, String> headers = new HashMap<String, String>(3);
        headers.put("Content-Type", ContentType.JSON.toString());
        headers.put("Authorization", accessToken.getTokenType().concat(" ").concat(accessToken.getAccessToken()));
        if (StrUtil.isNotEmpty((CharSequence)payPalRequestId)) {
            headers.put("PayPal-Request-Id", payPalRequestId);
        }
        if (StrUtil.isNotEmpty((CharSequence)payPalPartnerAttributionId)) {
            headers.put("PayPal-Partner-Attribution-Id", payPalPartnerAttributionId);
        }
        if (StrUtil.isNotEmpty((CharSequence)prefer)) {
            headers.put("Prefer", prefer);
        }
        return headers;
    }
}

