/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.alipay;

import com.jpay.alipay.AliPayApiConfig;
import com.jpay.ext.kit.StrKit;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AliPayApiConfigKit {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, AliPayApiConfig> CFG_MAP = new ConcurrentHashMap<String, AliPayApiConfig>();
    private static final String DEFAULT_CFG_KEY = "_default_ijpay_key_";

    public static AliPayApiConfig putApiConfig(AliPayApiConfig aliPayApiConfig) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, aliPayApiConfig);
        }
        return CFG_MAP.put(aliPayApiConfig.getAppId(), aliPayApiConfig);
    }

    public static AliPayApiConfig setThreadLocalAliPayApiConfig(AliPayApiConfig aliPayApiConfig) {
        return AliPayApiConfigKit.putApiConfig(aliPayApiConfig);
    }

    public static AliPayApiConfig removeApiConfig(AliPayApiConfig apiConfig) {
        return AliPayApiConfigKit.removeApiConfig(apiConfig.getAppId());
    }

    public static AliPayApiConfig removeApiConfig(String appId) {
        return CFG_MAP.remove(appId);
    }

    public static void setThreadLocalAppId(String appId) {
        if (StrKit.isBlank(appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        TL.set(appId);
    }

    public static void removeThreadLocalAppId() {
        TL.remove();
    }

    public static String getAppId() {
        String appId = TL.get();
        if (StrKit.isBlank(appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        return appId;
    }

    public static AliPayApiConfig getAliPayApiConfig() {
        String appId = AliPayApiConfigKit.getAppId();
        return AliPayApiConfigKit.getApiConfig(appId);
    }

    public static AliPayApiConfig getApiConfig(String appId) {
        AliPayApiConfig cfg = CFG_MAP.get(appId);
        if (cfg == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 AliPayApiConfigKit.putApiConfig(aliPayApiConfig) \u5c06 appId\u5bf9\u5e94\u7684 aliPayApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528 AliPayApiConfigKit.getAliPayApiConfig() \u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return cfg;
    }
}

