/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.weixin.api;

import com.jpay.ext.kit.PaymentKit;
import com.jpay.ext.kit.StrKit;
import com.jpay.weixin.api.WxPayApi;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class WxPayApiConfig
implements Serializable {
    private static final long serialVersionUID = -6447075676732210047L;
    private String appId;
    private String mchId;
    private String subAppId;
    private String subMchId;
    private String paternerKey;
    private String nonceStr;
    private String body;
    private String attach;
    private String transactionId;
    private String outTradeNo;
    private String totalFee;
    private String spbillCreateIp;
    private String notifyUrl;
    private WxPayApi.TradeType tradeType;
    private String openId;
    private String subOpenId;
    private String authCode;
    private String sceneInfo;
    private String planId;
    private String contractCode;
    private String requestSerial;
    private String contractDisplayAccount;
    private String version;
    private String timestamp;
    private String returnApp;
    private String returnWeb;
    private String contractNotifyUrl;
    private String contractId;
    private PayModel payModel;

    private WxPayApiConfig() {
    }

    public static WxPayApiConfig New() {
        return new WxPayApiConfig();
    }

    public Map<String, String> build() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.getPayModel().equals((Object)PayModel.SERVICEMODE)) {
            map.put("sub_mch_id", this.getSubMchId());
            if (StrKit.notBlank(this.getSubAppId())) {
                map.put("sub_appid", this.subAppId);
            }
        }
        if (this.getTradeType().equals((Object)WxPayApi.TradeType.JSAPI)) {
            if (StrKit.notBlank(this.getSubAppId())) {
                map.put("sub_appid", this.subAppId);
                map.put("sub_openid", this.getSubOpenId());
            } else {
                map.put("openid", this.getOpenId());
            }
        }
        if (this.getTradeType().equals((Object)WxPayApi.TradeType.MWEB)) {
            if (StrKit.isBlank(this.getSceneInfo())) {
                throw new IllegalArgumentException("\u5fae\u4fe1H5\u652f\u4ed8 scene_info \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            map.put("scene_info", this.getSceneInfo());
        }
        map.put("appid", this.getAppId());
        map.put("mch_id", this.getMchId());
        map.put("nonce_str", this.getNonceStr());
        map.put("body", this.getBody());
        map.put("out_trade_no", this.getOutTradeNo());
        map.put("total_fee", this.getTotalFee());
        map.put("spbill_create_ip", this.getSpbillCreateIp());
        map.put("trade_type", this.getTradeType().name());
        map.put("attach", this.getAttach());
        if (this.getTradeType().equals((Object)WxPayApi.TradeType.MICROPAY)) {
            map.put("auth_code", this.getAuthCode());
            map.remove("trade_type");
        } else {
            map.put("notify_url", this.getNotifyUrl());
        }
        map.put("sign", PaymentKit.createSign(map, this.getPaternerKey()));
        return map;
    }

    public Map<String, String> orderQueryBuild() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.getPayModel().equals((Object)PayModel.SERVICEMODE)) {
            map.put("sub_mch_id", this.getSubMchId());
            map.put("sub_appid", this.getSubAppId());
        }
        map.put("appid", this.getAppId());
        map.put("mch_id", this.getMchId());
        if (StrKit.notBlank(this.getTransactionId())) {
            map.put("transaction_id", this.getTransactionId());
        } else {
            if (StrKit.isBlank(this.getOutTradeNo())) {
                throw new IllegalArgumentException("out_trade_no,transaction_id \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            map.put("out_trade_no", this.getOutTradeNo());
        }
        map.put("nonce_str", String.valueOf(System.currentTimeMillis()));
        map.put("sign", PaymentKit.createSign(map, this.getPaternerKey()));
        return map;
    }

    public Map<String, String> entrustwebBuild() throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", this.getAppId());
        map.put("mch_id", this.getMchId());
        map.put("plan_id", this.getPlanId());
        map.put("contract_code", this.getContractCode());
        map.put("request_serial", this.getRequestSerial());
        map.put("contract_display_account", this.getContractDisplayAccount());
        map.put("notify_url", this.getNotifyUrl());
        map.put("version", this.getVersion());
        map.put("timestamp", this.getTimestamp());
        map.put("sign", PaymentKit.createSign(map, this.getPaternerKey()));
        for (Map.Entry param : map.entrySet()) {
            String key = (String)param.getKey();
            String value = (String)param.getValue();
            value = PaymentKit.urlEncode(value);
            map.put(key, value);
        }
        return map;
    }

    public Map<String, String> contractorderBuild() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", this.getAppId());
        map.put("mch_id", this.getMchId());
        map.put("contract_appid", this.getAppId());
        map.put("contract_mchid", this.getMchId());
        map.put("out_trade_no", this.getOutTradeNo());
        map.put("nonce_str", this.getNonceStr());
        map.put("body", this.getBody());
        map.put("attach", this.getAttach());
        map.put("notify_url", this.getNotifyUrl());
        map.put("total_fee", this.getTotalFee());
        map.put("spbill_create_ip", this.getSpbillCreateIp());
        map.put("trade_type", this.getTradeType().name());
        if (this.getTradeType().equals((Object)WxPayApi.TradeType.JSAPI)) {
            map.put("openid", this.getOpenId());
        }
        map.put("plan_id", this.getPlanId());
        map.put("contract_code", this.getContractCode());
        map.put("request_serial", this.getRequestSerial());
        map.put("contract_display_account", this.getContractDisplayAccount());
        map.put("contract_notify_url", this.getContractNotifyUrl());
        map.put("sign", PaymentKit.createSign(map, this.getPaternerKey()));
        return map;
    }

    public Map<String, String> querycontractBuild() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", this.getAppId());
        map.put("mch_id", this.getMchId());
        if (StrKit.notBlank(this.getPlanId())) {
            map.put("plan_id", this.getPlanId());
            map.put("contract_code", this.getContractCode());
        } else {
            map.put("contract_id", this.getContractId());
        }
        map.put("version", this.getVersion());
        map.put("sign", PaymentKit.createSign(map, this.getPaternerKey()));
        return map;
    }

    public Map<String, String> pappayapplyBuild() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appid", this.getAppId());
        map.put("mch_id", this.getMchId());
        map.put("nonce_str", this.getNonceStr());
        map.put("body", this.getBody());
        map.put("attach", this.getAttach());
        map.put("out_trade_no", this.getOutTradeNo());
        map.put("total_fee", this.getTotalFee());
        map.put("spbill_create_ip", this.getSpbillCreateIp());
        map.put("notify_url", this.getNotifyUrl());
        map.put("trade_type", this.getTradeType().name());
        map.put("contract_id", this.getContractId());
        map.put("sign", PaymentKit.createSign(map, this.getPaternerKey()));
        return map;
    }

    public String getAppId() {
        if (StrKit.isBlank(this.appId)) {
            throw new IllegalArgumentException("appId \u672a\u88ab\u8d4b\u503c");
        }
        return this.appId;
    }

    public WxPayApiConfig setAppId(String appId) {
        if (StrKit.isBlank(appId)) {
            throw new IllegalArgumentException("appId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.appId = appId;
        return this;
    }

    public String getMchId() {
        if (StrKit.isBlank(this.mchId)) {
            throw new IllegalArgumentException("mchId \u672a\u88ab\u8d4b\u503c");
        }
        return this.mchId;
    }

    public WxPayApiConfig setMchId(String mchId) {
        if (StrKit.isBlank(mchId)) {
            throw new IllegalArgumentException("mchId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mchId = mchId;
        return this;
    }

    public String getSubAppId() {
        return this.subAppId;
    }

    public WxPayApiConfig setSubAppId(String subAppId) {
        if (StrKit.isBlank(subAppId)) {
            throw new IllegalArgumentException("subAppId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.subAppId = subAppId;
        return this;
    }

    public String getSubMchId() {
        if (StrKit.isBlank(this.subMchId)) {
            throw new IllegalArgumentException("subMchId \u672a\u88ab\u8d4b\u503c");
        }
        return this.subMchId;
    }

    public WxPayApiConfig setSubMchId(String subMchId) {
        if (StrKit.isBlank(subMchId)) {
            throw new IllegalArgumentException("subMchId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.subMchId = subMchId;
        return this;
    }

    public String getNonceStr() {
        if (StrKit.isBlank(this.nonceStr)) {
            this.nonceStr = String.valueOf(System.currentTimeMillis());
        }
        return this.nonceStr;
    }

    public WxPayApiConfig setNonceStr(String nonceStr) {
        if (StrKit.isBlank(nonceStr)) {
            throw new IllegalArgumentException("nonceStr \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.nonceStr = nonceStr;
        return this;
    }

    public String getBody() {
        if (StrKit.isBlank(this.body)) {
            throw new IllegalArgumentException("body \u672a\u88ab\u8d4b\u503c");
        }
        return this.body;
    }

    public WxPayApiConfig setBody(String body) {
        if (StrKit.isBlank(body)) {
            throw new IllegalArgumentException("body \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.body = body;
        return this;
    }

    public String getAttach() {
        return this.attach;
    }

    public WxPayApiConfig setAttach(String attach) {
        if (StrKit.isBlank(attach)) {
            throw new IllegalArgumentException("attach \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.attach = attach;
        return this;
    }

    public String getOutTradeNo() {
        if (StrKit.isBlank(this.outTradeNo)) {
            throw new IllegalArgumentException("outTradeNo \u672a\u88ab\u8d4b\u503c");
        }
        return this.outTradeNo;
    }

    public WxPayApiConfig setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
        return this;
    }

    public String getTotalFee() {
        if (StrKit.isBlank(this.totalFee)) {
            throw new IllegalArgumentException("totalFee \u672a\u88ab\u8d4b\u503c");
        }
        return this.totalFee;
    }

    public WxPayApiConfig setTotalFee(String totalFee) {
        if (StrKit.isBlank(totalFee)) {
            throw new IllegalArgumentException("totalFee \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.totalFee = totalFee;
        return this;
    }

    public String getSpbillCreateIp() {
        if (StrKit.isBlank(this.spbillCreateIp)) {
            throw new IllegalArgumentException("spbillCreateIp \u672a\u88ab\u8d4b\u503c");
        }
        return this.spbillCreateIp;
    }

    public WxPayApiConfig setSpbillCreateIp(String spbillCreateIp) {
        if (StrKit.isBlank(spbillCreateIp)) {
            throw new IllegalArgumentException("spbillCreateIp \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.spbillCreateIp = spbillCreateIp;
        return this;
    }

    public String getNotifyUrl() {
        if (StrKit.isBlank(this.notifyUrl)) {
            throw new IllegalArgumentException("notifyUrl \u672a\u88ab\u8d4b\u503c");
        }
        return this.notifyUrl;
    }

    public WxPayApiConfig setNotifyUrl(String notifyUrl) {
        if (StrKit.isBlank(notifyUrl)) {
            throw new IllegalArgumentException("notifyUrl \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.notifyUrl = notifyUrl;
        return this;
    }

    public WxPayApi.TradeType getTradeType() {
        if (this.tradeType == null) {
            throw new IllegalArgumentException("tradeType \u672a\u88ab\u8d4b\u503c");
        }
        return this.tradeType;
    }

    public WxPayApiConfig setTradeType(WxPayApi.TradeType tradeType) {
        if (tradeType == null) {
            throw new IllegalArgumentException("mchId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.tradeType = tradeType;
        return this;
    }

    public String getOpenId() {
        if (StrKit.isBlank(this.openId)) {
            throw new IllegalArgumentException("openId \u672a\u88ab\u8d4b\u503c");
        }
        return this.openId;
    }

    public WxPayApiConfig setOpenId(String openId) {
        if (StrKit.isBlank(openId)) {
            throw new IllegalArgumentException("openId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.openId = openId;
        return this;
    }

    public String getSubOpenId() {
        if (StrKit.isBlank(this.subOpenId)) {
            throw new IllegalArgumentException("subOpenId \u672a\u88ab\u8d4b\u503c");
        }
        return this.subOpenId;
    }

    public WxPayApiConfig setSubOpenId(String subOpenId) {
        if (StrKit.isBlank(subOpenId)) {
            throw new IllegalArgumentException("subOpenId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.subOpenId = subOpenId;
        return this;
    }

    public String getPaternerKey() {
        if (StrKit.isBlank(this.paternerKey)) {
            throw new IllegalArgumentException("paternerKey \u672a\u88ab\u8d4b\u503c");
        }
        return this.paternerKey;
    }

    public WxPayApiConfig setPaternerKey(String paternerKey) {
        if (StrKit.isBlank(paternerKey)) {
            throw new IllegalArgumentException("paternerKey \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.paternerKey = paternerKey;
        return this;
    }

    public PayModel getPayModel() {
        if (this.payModel == null) {
            this.payModel = PayModel.BUSINESSMODEL;
        }
        return this.payModel;
    }

    public WxPayApiConfig setPayModel(PayModel payModel) {
        if (payModel == null) {
            payModel = PayModel.BUSINESSMODEL;
        }
        this.payModel = payModel;
        return this;
    }

    public String getAuthCode() {
        if (StrKit.isBlank(this.authCode)) {
            throw new IllegalArgumentException("authCode \u672a\u88ab\u8d4b\u503c");
        }
        return this.authCode;
    }

    public WxPayApiConfig setAuthCode(String authCode) {
        if (StrKit.isBlank(this.paternerKey)) {
            throw new IllegalArgumentException("authCode \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.authCode = authCode;
        return this;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public WxPayApiConfig setTransactionId(String transactionId) {
        if (StrKit.isBlank(transactionId)) {
            throw new IllegalArgumentException("transactionId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.transactionId = transactionId;
        return this;
    }

    public String getSceneInfo() {
        return this.sceneInfo;
    }

    public WxPayApiConfig setSceneInfo(String sceneInfo) {
        this.sceneInfo = sceneInfo;
        return this;
    }

    public String getPlanId() {
        if (StrKit.isBlank(this.planId)) {
            throw new IllegalArgumentException("planId \u672a\u88ab\u8d4b\u503c");
        }
        return this.planId;
    }

    public WxPayApiConfig setPlanId(String planId) {
        if (StrKit.isBlank(planId)) {
            throw new IllegalArgumentException("planId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.planId = planId;
        return this;
    }

    public String getContractCode() {
        if (StrKit.isBlank(this.contractCode)) {
            throw new IllegalArgumentException("contractCode \u672a\u88ab\u8d4b\u503c");
        }
        return this.contractCode;
    }

    public WxPayApiConfig setContractCode(String contractCode) {
        if (StrKit.isBlank(contractCode)) {
            throw new IllegalArgumentException("contractCode \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractCode = contractCode;
        return this;
    }

    public String getRequestSerial() {
        if (StrKit.isBlank(this.requestSerial)) {
            throw new IllegalArgumentException("requestSerial \u672a\u88ab\u8d4b\u503c");
        }
        return this.requestSerial;
    }

    public WxPayApiConfig setRequestSerial(String requestSerial) {
        if (StrKit.isBlank(requestSerial)) {
            throw new IllegalArgumentException("requestSerial \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.requestSerial = requestSerial;
        return this;
    }

    public String getContractDisplayAccount() {
        if (StrKit.isBlank(this.contractDisplayAccount)) {
            throw new IllegalArgumentException("contractDisplayAccount \u672a\u88ab\u8d4b\u503c");
        }
        return this.contractDisplayAccount;
    }

    public WxPayApiConfig setContractDisplayAccount(String contractDisplayAccount) {
        if (StrKit.isBlank(contractDisplayAccount)) {
            throw new IllegalArgumentException("contractDisplayAccount \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contractDisplayAccount = contractDisplayAccount;
        return this;
    }

    public String getVersion() {
        if (StrKit.isBlank(this.version)) {
            this.version = "1.0";
        }
        return this.version;
    }

    public WxPayApiConfig setVersion(String version) {
        if (StrKit.isBlank(version)) {
            throw new IllegalArgumentException("version \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.version = version;
        return this;
    }

    public String getTimestamp() {
        if (StrKit.isBlank(this.timestamp)) {
            this.timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        }
        return this.timestamp;
    }

    public WxPayApiConfig setTimestamp(String timestamp) {
        if (StrKit.isBlank(timestamp)) {
            throw new IllegalArgumentException("timestamp \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (timestamp.length() != 10) {
            throw new IllegalArgumentException("timestamp \u503c\u5fc5\u987b\u4e3a10\u4f4d");
        }
        this.timestamp = timestamp;
        return this;
    }

    public String getReturnApp() {
        return this.returnApp;
    }

    public WxPayApiConfig setReturnApp(String returnApp) {
        this.returnApp = returnApp;
        return this;
    }

    public String getReturnWeb() {
        return this.returnWeb;
    }

    public WxPayApiConfig setReturnWeb(String returnWeb) {
        this.returnWeb = returnWeb;
        return this;
    }

    public String getContractNotifyUrl() {
        if (StrKit.isBlank(this.contractNotifyUrl)) {
            throw new IllegalArgumentException("contractNotifyUrl \u672a\u88ab\u8d4b\u503c");
        }
        return this.contractNotifyUrl;
    }

    public WxPayApiConfig setContractNotifyUrl(String contractNotifyUrl) {
        this.contractNotifyUrl = contractNotifyUrl;
        return this;
    }

    public String getContractId() {
        if (StrKit.isBlank(this.contractId)) {
            throw new IllegalArgumentException("contractId \u672a\u88ab\u8d4b\u503c");
        }
        return this.contractId;
    }

    public WxPayApiConfig setContractId(String contractId) {
        this.contractId = contractId;
        return this;
    }

    public static enum PayModel {
        BUSINESSMODEL,
        SERVICEMODE;

    }
}

