/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.weixin.api.hb;

import com.jpay.ext.kit.PaymentKit;
import com.jpay.ext.kit.StrKit;
import com.jpay.weixin.api.WxPayApiConfig;
import java.util.HashMap;
import java.util.Map;

public class ReadHbModle {
    private String nonceStr;
    private String mchBillNo;
    private String mchId;
    private String subMchId;
    private String wxAppId;
    private String msgAppId;
    private String sendName;
    private String reOpenId;
    private long totalAmount;
    private int totalNum;
    private String wishing;
    private String clientIp;
    private String actName;
    private String remark;
    private SceneId sceneId;
    private String riskInfo;
    private String consumeMchId;
    private AmtType amtType;
    private HbType hbType;
    private WxPayApiConfig.PayModel payModel;
    private String paternerKey;

    private ReadHbModle() {
    }

    public static ReadHbModle Builder() {
        return new ReadHbModle();
    }

    public Map<String, String> build() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.getPayModel().equals((Object)WxPayApiConfig.PayModel.SERVICEMODE)) {
            map.put("sub_mch_id", this.getSubMchId());
            map.put("msgappid", this.getMsgAppId());
        }
        if (this.getTotalAmount() > 20000L) {
            map.put("scene_id", this.getSceneId().name());
        }
        if (StrKit.notBlank(this.getRiskInfo())) {
            map.put("risk_info", this.getRiskInfo());
        }
        if (StrKit.notBlank(this.getConsumeMchId())) {
            map.put("consume_mch_id", this.getConsumeMchId());
        }
        if (this.getHbType().equals((Object)HbType.NORMAL)) {
            map.put("client_ip", this.getClientIp());
        } else {
            map.put("amt_type", this.getAmtType().name());
        }
        map.put("nonce_str", this.getNonceStr());
        map.put("mch_billno", this.getMchBillNo());
        map.put("mch_id", this.getMchId());
        map.put("wxappid", this.getWxAppId());
        map.put("send_name", this.getSendName());
        map.put("re_openid", this.getReOpenId());
        map.put("total_amount", String.valueOf(this.getTotalAmount()));
        map.put("total_num", String.valueOf(this.getTotalNum()));
        map.put("wishing", this.getWishing());
        map.put("act_name", this.getActName());
        map.put("remark", this.getRemark());
        map.put("sign", PaymentKit.createSign(map, this.getPaternerKey()));
        return map;
    }

    public String getNonceStr() {
        if (StrKit.isBlank(this.nonceStr)) {
            this.nonceStr = String.valueOf(System.currentTimeMillis());
        }
        return this.nonceStr;
    }

    public ReadHbModle setNonceStr(String nonceStr) {
        if (StrKit.isBlank(nonceStr)) {
            throw new IllegalArgumentException("nonceStr \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.nonceStr = nonceStr;
        return this;
    }

    public String getMchBillNo() {
        if (StrKit.isBlank(this.mchBillNo)) {
            this.mchBillNo = String.valueOf(System.currentTimeMillis());
        }
        return this.mchBillNo;
    }

    public ReadHbModle setMchBillNo(String mchBillNo) {
        if (StrKit.isBlank(mchBillNo)) {
            throw new IllegalArgumentException("mchBillNo \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mchBillNo = mchBillNo;
        return this;
    }

    public String getMchId() {
        if (StrKit.isBlank(this.mchId)) {
            throw new IllegalArgumentException("mchId \u672a\u88ab\u8d4b\u503c");
        }
        return this.mchId;
    }

    public ReadHbModle setMchId(String mchId) {
        if (StrKit.isBlank(mchId)) {
            throw new IllegalArgumentException("mchId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mchId = mchId;
        return this;
    }

    public String getSubMchId() {
        return this.subMchId;
    }

    public ReadHbModle setSubMchId(String subMchId) {
        if (StrKit.isBlank(subMchId)) {
            throw new IllegalArgumentException("subMchId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.subMchId = subMchId;
        return this;
    }

    public String getWxAppId() {
        if (StrKit.isBlank(this.wxAppId)) {
            throw new IllegalArgumentException("wxAppId \u672a\u88ab\u8d4b\u503c");
        }
        return this.wxAppId;
    }

    public ReadHbModle setWxAppId(String wxAppId) {
        if (StrKit.isBlank(wxAppId)) {
            throw new IllegalArgumentException("wxAppId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.wxAppId = wxAppId;
        return this;
    }

    public String getMsgAppId() {
        return this.msgAppId;
    }

    public ReadHbModle setMsgAppId(String msgAppId) {
        if (StrKit.isBlank(msgAppId)) {
            throw new IllegalArgumentException("msgAppId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.msgAppId = msgAppId;
        return this;
    }

    public String getSendName() {
        if (StrKit.isBlank(this.sendName)) {
            throw new IllegalArgumentException("sendName \u672a\u88ab\u8d4b\u503c");
        }
        return this.sendName;
    }

    public ReadHbModle setSendName(String sendName) {
        if (StrKit.isBlank(sendName)) {
            throw new IllegalArgumentException("sendName \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sendName = sendName;
        return this;
    }

    public String getReOpenId() {
        if (StrKit.isBlank(this.reOpenId)) {
            throw new IllegalArgumentException("reOpenId \u672a\u88ab\u8d4b\u503c");
        }
        return this.reOpenId;
    }

    public ReadHbModle setReOpenId(String reOpenId) {
        if (StrKit.isBlank(reOpenId)) {
            throw new IllegalArgumentException("reOpenId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.reOpenId = reOpenId;
        return this;
    }

    public long getTotalAmount() {
        if (this.totalAmount <= 0L) {
            this.totalAmount = 1L;
        }
        return this.totalAmount;
    }

    public ReadHbModle setTotalAmount(long totalAmount) {
        if (totalAmount <= 0L) {
            totalAmount = 1L;
        }
        this.totalAmount = totalAmount;
        return this;
    }

    public int getTotalNum() {
        if (this.totalNum <= 0) {
            this.totalNum = 1;
        }
        return this.totalNum;
    }

    public ReadHbModle setTotalNum(int totalNum) {
        if (totalNum <= 0) {
            totalNum = 1;
        }
        this.totalNum = totalNum;
        return this;
    }

    public String getWishing() {
        if (StrKit.isBlank(this.wishing)) {
            throw new IllegalArgumentException("wishing \u672a\u88ab\u8d4b\u503c");
        }
        return this.wishing;
    }

    public ReadHbModle setWishing(String wishing) {
        if (StrKit.isBlank(wishing)) {
            throw new IllegalArgumentException("wishing \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.wishing = wishing;
        return this;
    }

    public String getClientIp() {
        if (StrKit.isBlank(this.clientIp)) {
            throw new IllegalArgumentException("clientIp \u672a\u88ab\u8d4b\u503c");
        }
        return this.clientIp;
    }

    public ReadHbModle setClientIp(String clientIp) {
        if (StrKit.isBlank(clientIp)) {
            throw new IllegalArgumentException("clientIp \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.clientIp = clientIp;
        return this;
    }

    public String getActName() {
        if (StrKit.isBlank(this.actName)) {
            throw new IllegalArgumentException("actName \u672a\u88ab\u8d4b\u503c");
        }
        return this.actName;
    }

    public ReadHbModle setActName(String actName) {
        if (StrKit.isBlank(actName)) {
            throw new IllegalArgumentException("actName \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.actName = actName;
        return this;
    }

    public String getRemark() {
        if (StrKit.isBlank(this.remark)) {
            throw new IllegalArgumentException("remark \u672a\u88ab\u8d4b\u503c");
        }
        return this.remark;
    }

    public ReadHbModle setRemark(String remark) {
        if (StrKit.isBlank(remark)) {
            throw new IllegalArgumentException("remark \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.remark = remark;
        return this;
    }

    public SceneId getSceneId() {
        if (this.sceneId == null) {
            throw new IllegalArgumentException("sceneId \u672a\u88ab\u8d4b\u503c");
        }
        return this.sceneId;
    }

    public ReadHbModle setSceneId(SceneId sceneId) {
        if (sceneId == null) {
            throw new IllegalArgumentException("sceneId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sceneId = sceneId;
        return this;
    }

    public String getRiskInfo() {
        return this.riskInfo;
    }

    public ReadHbModle setRiskInfo(String riskInfo) {
        if (StrKit.isBlank(riskInfo)) {
            throw new IllegalArgumentException("riskInfo \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.riskInfo = riskInfo;
        return this;
    }

    public String getConsumeMchId() {
        return this.consumeMchId;
    }

    public ReadHbModle setConsumeMchId(String consumeMchId) {
        if (StrKit.isBlank(consumeMchId)) {
            throw new IllegalArgumentException("consumeMchId \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.consumeMchId = consumeMchId;
        return this;
    }

    public WxPayApiConfig.PayModel getPayModel() {
        if (this.payModel == null) {
            throw new IllegalArgumentException("payModel \u672a\u88ab\u8d4b\u503c");
        }
        return this.payModel;
    }

    public ReadHbModle setPayModel(WxPayApiConfig.PayModel payModel) {
        if (payModel == null) {
            throw new IllegalArgumentException("payModel \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.payModel = payModel;
        return this;
    }

    public String getPaternerKey() {
        if (StrKit.isBlank(this.paternerKey)) {
            throw new IllegalArgumentException("paternerKey \u672a\u88ab\u8d4b\u503c");
        }
        return this.paternerKey;
    }

    public ReadHbModle setPaternerKey(String paternerKey) {
        if (StrKit.isBlank(paternerKey)) {
            throw new IllegalArgumentException("paternerKey \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.paternerKey = paternerKey;
        return this;
    }

    public ReadHbModle setHbType(HbType hbType) {
        if (hbType == null) {
            throw new IllegalArgumentException("hbType \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.hbType = hbType;
        return this;
    }

    public HbType getHbType() {
        if (this.hbType == null) {
            throw new IllegalArgumentException("hbType \u672a\u88ab\u8d4b\u503c");
        }
        return this.hbType;
    }

    public AmtType getAmtType() {
        if (this.amtType == null) {
            throw new IllegalArgumentException("amtType \u672a\u88ab\u8d4b\u503c");
        }
        return this.amtType;
    }

    public ReadHbModle setAmtType(AmtType amtType) {
        if (amtType == null) {
            throw new IllegalArgumentException("amtType \u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.amtType = amtType;
        return this;
    }

    public static enum HbType {
        NORMAL,
        DIVIDE;

    }

    public static enum AmtType {
        ALL_RAND;

    }

    public static enum SceneId {
        PRODUCT_1,
        PRODUCT_2,
        PRODUCT_3,
        PRODUCT_4,
        PRODUCT_5,
        PRODUCT_6,
        PRODUCT_7,
        PRODUCT_8;

    }
}

