/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.alipay;

import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.jpay.ext.kit.StrKit;
import java.io.Serializable;

public class AliPayApiConfig
implements Serializable {
    private static final long serialVersionUID = -4736760736935998953L;
    private String privateKey;
    private String alipayPublicKey;
    private String appId;
    private String serviceUrl;
    private String charset;
    private String signType;
    private String format;
    private AlipayClient alipayClient;

    private AliPayApiConfig() {
    }

    public static AliPayApiConfig New() {
        return new AliPayApiConfig();
    }

    public AliPayApiConfig build() {
        this.alipayClient = new DefaultAlipayClient(this.getServiceUrl(), this.getAppId(), this.getPrivateKey(), this.getFormat(), this.getCharset(), this.getAlipayPublicKey(), this.getSignType());
        return this;
    }

    public String getPrivateKey() {
        if (StrKit.isBlank(this.privateKey)) {
            throw new IllegalStateException("privateKey \u672a\u88ab\u8d4b\u503c");
        }
        return this.privateKey;
    }

    public AliPayApiConfig setPrivateKey(String privateKey) {
        if (StrKit.isBlank(privateKey)) {
            throw new IllegalArgumentException("privateKey \u503c\u4e0d\u80fd\u4e3a null");
        }
        this.privateKey = privateKey;
        return this;
    }

    public String getAlipayPublicKey() {
        if (StrKit.isBlank(this.alipayPublicKey)) {
            throw new IllegalStateException("alipayPublicKey \u672a\u88ab\u8d4b\u503c");
        }
        return this.alipayPublicKey;
    }

    public AliPayApiConfig setAlipayPublicKey(String alipayPublicKey) {
        if (StrKit.isBlank(alipayPublicKey)) {
            throw new IllegalArgumentException("alipayPublicKey \u503c\u4e0d\u80fd\u4e3a null");
        }
        this.alipayPublicKey = alipayPublicKey;
        return this;
    }

    public String getAppId() {
        if (StrKit.isBlank(this.appId)) {
            throw new IllegalStateException("appId \u672a\u88ab\u8d4b\u503c");
        }
        return this.appId;
    }

    public AliPayApiConfig setAppId(String appId) {
        if (StrKit.isBlank(appId)) {
            throw new IllegalArgumentException("appId \u503c\u4e0d\u80fd\u4e3a null");
        }
        this.appId = appId;
        return this;
    }

    public String getServiceUrl() {
        if (StrKit.isBlank(this.serviceUrl)) {
            throw new IllegalStateException("serviceUrl \u672a\u88ab\u8d4b\u503c");
        }
        return this.serviceUrl;
    }

    public AliPayApiConfig setServiceUrl(String serviceUrl) {
        if (StrKit.isBlank(serviceUrl)) {
            serviceUrl = "https://openapi.alipay.com/gateway.do";
        }
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String getCharset() {
        if (StrKit.isBlank(this.charset)) {
            this.charset = "UTF-8";
        }
        return this.charset;
    }

    public AliPayApiConfig setCharset(String charset) {
        if (StrKit.isBlank(charset)) {
            charset = "UTF-8";
        }
        this.charset = charset;
        return this;
    }

    public String getSignType() {
        if (StrKit.isBlank(this.signType)) {
            this.signType = "RSA2";
        }
        return this.signType;
    }

    public AliPayApiConfig setSignType(String signType) {
        if (StrKit.isBlank(signType)) {
            signType = "RSA2";
        }
        this.signType = signType;
        return this;
    }

    public String getFormat() {
        if (StrKit.isBlank(this.format)) {
            this.format = "json";
        }
        return this.format;
    }

    public AlipayClient getAlipayClient() {
        if (this.alipayClient == null) {
            throw new IllegalStateException("alipayClient \u672a\u88ab\u521d\u59cb\u5316");
        }
        return this.alipayClient;
    }
}

