/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.ext.kit;

import com.jpay.ext.kit.AesKit;
import com.jpay.ext.kit.HashKit;
import com.jpay.ext.kit.StrKit;
import com.jpay.util.Charsets;
import com.jpay.util.XmlHelper;
import com.jpay.weixin.api.WxPayApiConfig;
import com.jpay.weixin.api.WxPayApiConfigKit;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class PaymentKit {
    public static Map<String, String> buildShortUrlParasMap(String appid, String sub_appid, String mch_id, String sub_mch_id, String long_url, String paternerKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", appid);
        params.put("sub_appid", sub_appid);
        params.put("mch_id", mch_id);
        params.put("sub_mch_id", sub_mch_id);
        params.put("long_url", long_url);
        return PaymentKit.buildSignAfterParasMap(params, paternerKey);
    }

    public static String packageSign(Map<String, String> params, boolean urlEncoder) {
        TreeMap<String, String> sortedParams = new TreeMap<String, String>(params);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> param : sortedParams.entrySet()) {
            String value = param.getValue();
            if (StrKit.isBlank(value)) continue;
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(param.getKey()).append("=");
            if (urlEncoder) {
                try {
                    value = PaymentKit.urlEncode(value);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            sb.append(value);
        }
        return sb.toString();
    }

    public static String urlEncode(String src) throws UnsupportedEncodingException {
        return URLEncoder.encode(src, Charsets.UTF_8.name()).replace("+", "%20");
    }

    public static Map<String, String> buildSignAfterParasMap(Map<String, String> params, String paternerKey) {
        params.put("nonce_str", String.valueOf(System.currentTimeMillis()));
        String sign = PaymentKit.createSign(params, paternerKey);
        params.put("sign", sign);
        return params;
    }

    public static String createSign(Map<String, String> params, String partnerKey) {
        params.remove("sign");
        String stringA = PaymentKit.packageSign(params, false);
        String stringSignTemp = stringA + "&key=" + partnerKey;
        return HashKit.md5(stringSignTemp).toUpperCase();
    }

    public static String createSign(Map<String, String> params, String partnerKey, WxPayApiConfig.SignType signType) throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException {
        params.remove("sign");
        String stringA = PaymentKit.packageSign(params, false);
        String stringSignTemp = stringA + "&key=" + partnerKey;
        if (signType == WxPayApiConfig.SignType.MD5) {
            return HashKit.md5(stringSignTemp).toUpperCase();
        }
        return PaymentKit.hmacSHA256(stringSignTemp, partnerKey).toUpperCase();
    }

    public static String decryptRefundData(String reqInfo, String paternerKey) throws Exception {
        return AesKit.decryptData(reqInfo, paternerKey);
    }

    public static boolean verifyNotify(Map<String, String> params, String paternerKey) {
        String sign = params.get("sign");
        String localSign = PaymentKit.createSign(params, paternerKey);
        return sign.equals(localSign);
    }

    public static boolean verifyNotify(Map<String, String> params, String paternerKey, WxPayApiConfig.SignType signType) throws InvalidKeyException, UnsupportedEncodingException, NoSuchAlgorithmException {
        String sign = params.get("sign");
        String localSign = PaymentKit.createSign(params, paternerKey, signType);
        return sign.equals(localSign);
    }

    public static Map<String, String> prepayIdCreateSign(String prepay_id) {
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appId", WxPayApiConfigKit.getWxPayApiConfig().getAppId());
        packageParams.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        packageParams.put("nonceStr", String.valueOf(System.currentTimeMillis()));
        packageParams.put("package", "prepay_id=" + prepay_id);
        packageParams.put("signType", "MD5");
        String packageSign = PaymentKit.createSign(packageParams, WxPayApiConfigKit.getWxPayApiConfig().getPaternerKey());
        packageParams.put("paySign", packageSign);
        return packageParams;
    }

    public static boolean codeIsOK(String return_code) {
        return StrKit.notBlank(return_code) && "SUCCESS".equals(return_code);
    }

    public static String toXml(Map<String, String> params) {
        StringBuilder xml = new StringBuilder();
        xml.append("<xml>");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StrKit.isBlank(value)) continue;
            xml.append("<").append(key).append(">");
            xml.append(entry.getValue());
            xml.append("</").append(key).append(">");
        }
        xml.append("</xml>");
        return xml.toString();
    }

    public static Map<String, String> xmlToMap(String xmlStr) {
        XmlHelper xmlHelper = XmlHelper.of(xmlStr);
        return xmlHelper.toMap();
    }

    public static String replace(String str, String regex, String ... args) {
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            str = str.replaceFirst(regex, args[i]);
        }
        return str;
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public static String hmacSHA256(String stringSignTemp, String partnerKey) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(partnerKey.getBytes(), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        return PaymentKit.byteArrayToHexString(sha256_HMAC.doFinal(stringSignTemp.getBytes("utf-8")));
    }
}

