/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.weixin.api;

import com.jpay.ext.kit.PaymentKit;
import com.jpay.util.HttpUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class WxPayApi {
    private static final String UNIFIEDORDER_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String ORDERQUERY_URL = "https://api.mch.weixin.qq.com/pay/orderquery";
    private static final String CLOSEORDER_URL = "https://api.mch.weixin.qq.com/pay/closeorder";
    private static final String REVERSE_URL = "https://api.mch.weixin.qq.com/secapi/pay/reverse";
    private static final String REFUND_URL = "https://api.mch.weixin.qq.com/secapi/pay/refund";
    private static final String REFUNDQUERY_URL = "https://api.mch.weixin.qq.com/pay/refundquery";
    private static final String DOWNLOADBILLY_URL = "https://api.mch.weixin.qq.com/pay/downloadbill";
    private static final String REPORT_URL = "https://api.mch.weixin.qq.com/payitil/report";
    private static final String SHORT_URL = "https://api.mch.weixin.qq.com/tools/shorturl";
    private static final String AUTHCODETOOPENID_URL = "https://api.mch.weixin.qq.com/tools/authcodetoopenid";
    private static final String MICROPAY_URL = "https://api.mch.weixin.qq.com/pay/micropay";
    private static final String TRANSFERS_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers";
    private static final String GETTRANSFERINFO_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/gettransferinfo";
    private static final String PAY_BANK_URL = "https://api.mch.weixin.qq.com/mmpaysptrans/pay_bank";
    private static final String QUERY_BANK_URL = "https://api.mch.weixin.qq.com/mmpaysptrans/query_bank";
    private static final String GETPUBLICKEY_URL = "https://fraud.mch.weixin.qq.com/risk/getpublickey";
    private static final String ENTRUSTWEB_URL = "https://api.mch.weixin.qq.com/papay/entrustweb";
    private static final String CONTRACTORDER_URL = "https://api.mch.weixin.qq.com/pay/contractorder";
    private static final String QUERYCONTRACT_URL = "https://api.mch.weixin.qq.com/papay/querycontract";
    private static final String PAPPAYAPPLY_URL = "https://api.mch.weixin.qq.com/pay/pappayapply";
    private static final String DELETECONTRACT_URL = "https://api.mch.weixin.qq.com/papay/deletecontract";
    private static final String CONTRACTBILL_URL = "https://api.mch.weixin.qq.com/papay/contractbill";
    private static final String PAPORDERQUERYL_URL = "https://api.mch.weixin.qq.com/pay/paporderquery";
    private static final String PROFITSHARING_URL = "https://api.mch.weixin.qq.com/secapi/pay/profitsharing";
    private static final String PROFITSHARINGQUERY_URL = "https://api.mch.weixin.qq.com/pay/profitsharingquery";
    private static final String PROFITSHARINGADDRECEIVER_URL = "https://api.mch.weixin.qq.com/pay/profitsharingaddreceiver";
    private static final String PROFITSHARINGREMOVERECEIVER_URL = "https://api.mch.weixin.qq.com/pay/profitsharingremovereceiver";
    private static final String PROFITSHARINGFINISH_URL = "https://api.mch.weixin.qq.com/secapi/pay/profitsharingfinish";
    private static final String SEND_COUPON_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/send_coupon";
    private static final String QUERY_COUPON_STOCK_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/query_coupon_stock";
    private static final String QUERY_COUPONSINFO_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/querycouponsinfo";
    private static final String BATCH_QUERY_COMMENT_URL = "https://api.mch.weixin.qq.com/billcommentsp/batchquerycomment";
    private static final String DEPOSIT_FACEPAY_URL = "https://api.mch.weixin.qq.com/deposit/facepay";
    private static final String DEPOSIT_MICROPAY_URL = "https://api.mch.weixin.qq.com/deposit/micropay";
    private static final String DEPOSIT_ORDERQUERY_URL = "https://api.mch.weixin.qq.com/deposit/orderquery";
    private static final String DEPOSIT_REVERSE_URL = "https://api.mch.weixin.qq.com/deposit/reverse";
    private static final String DEPOSIT_CONSUME_URL = "https://api.mch.weixin.qq.com/deposit/consume";
    private static final String DEPOSIT_REFUND_URL = "https://api.mch.weixin.qq.com/deposit/refund";
    private static final String DEPOSIT_REFUNDQUERY_URL = "https://api.mch.weixin.qq.com/deposit/refundquery";
    private static final String GETSINGKEY = "https://api.mch.weixin.qq.com/sandboxnew/pay/getsignkey";
    private static final String UNIFIEDORDER_SANDBOXNEW_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/unifiedorder";
    private static final String MICROPAY_SANDBOXNEW_RUL = "https://api.mch.weixin.qq.com/sandboxnew/pay/micropay";
    private static final String ORDERQUERY_SANDBOXNEW_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/orderquery";
    private static final String REFUND_SANDBOXNEW_URL = "https://api.mch.weixin.qq.com/sandboxnew/secapi/pay/refund";
    private static final String REFUNDQUERY_SANDBOXNEW_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/refundquery";
    private static final String DOWNLOADBILLY_SANDBOXNEW_URL = "https://api.mch.weixin.qq.com/sandboxnew/pay/downloadbill";

    private WxPayApi() {
    }

    public static String getsignkey(String mch_id, String partnerKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        String nonce_str = String.valueOf(System.currentTimeMillis());
        map.put("mch_id", mch_id);
        map.put("nonce_str", nonce_str);
        map.put("sign", PaymentKit.createSign(map, partnerKey));
        return WxPayApi.doPost(GETSINGKEY, map);
    }

    public static String pushOrder(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(UNIFIEDORDER_SANDBOXNEW_URL, params);
        }
        return WxPayApi.doPost(UNIFIEDORDER_URL, params);
    }

    public static String orderQuery(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(ORDERQUERY_SANDBOXNEW_URL, params);
        }
        return WxPayApi.doPost(ORDERQUERY_URL, params);
    }

    public static String closeOrder(Map<String, String> params) {
        return WxPayApi.doPost(CLOSEORDER_URL, params);
    }

    public static String orderReverse(Map<String, String> params, String certPath, String certPass) {
        return WxPayApi.doPostSSL(REVERSE_URL, params, certPath, certPass);
    }

    public static String orderReverse(Map<String, String> params, InputStream certFile, String certPass) {
        return WxPayApi.doPostSSL(REVERSE_URL, params, certFile, certPass);
    }

    public static String orderRefund(boolean isSandbox, Map<String, String> params, String certPath, String certPass) {
        if (isSandbox) {
            return WxPayApi.doPostSSL(REFUND_SANDBOXNEW_URL, params, certPath, certPass);
        }
        return WxPayApi.doPostSSL(REFUND_URL, params, certPath, certPass);
    }

    public static String orderRefund(boolean isSandbox, Map<String, String> params, InputStream certFile, String certPass) {
        if (isSandbox) {
            return WxPayApi.doPostSSL(REFUND_SANDBOXNEW_URL, params, certFile, certPass);
        }
        return WxPayApi.doPostSSL(REFUND_URL, params, certFile, certPass);
    }

    public static String orderRefundQuery(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(REFUNDQUERY_SANDBOXNEW_URL, params);
        }
        return WxPayApi.doPost(REFUNDQUERY_URL, params);
    }

    public static String downloadBill(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(DOWNLOADBILLY_SANDBOXNEW_URL, params);
        }
        return WxPayApi.doPost(DOWNLOADBILLY_URL, params);
    }

    public static String orderReport(Map<String, String> params) {
        return WxPayApi.doPost(REPORT_URL, params);
    }

    public static String toShortUrl(Map<String, String> params) {
        return WxPayApi.doPost(SHORT_URL, params);
    }

    public static String authCodeToOpenid(Map<String, String> params) {
        return WxPayApi.doPost(AUTHCODETOOPENID_URL, params);
    }

    public static String micropay(boolean isSandbox, Map<String, String> params) {
        if (isSandbox) {
            return WxPayApi.doPost(MICROPAY_SANDBOXNEW_RUL, params);
        }
        return WxPayApi.doPost(MICROPAY_URL, params);
    }

    public static String transfers(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(TRANSFERS_URL, params, certPath, certPassword);
    }

    public static String transfers(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(TRANSFERS_URL, params, certFile, certPassword);
    }

    public static String getTransferInfo(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(GETTRANSFERINFO_URL, params, certPath, certPassword);
    }

    public static String getTransferInfo(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(GETTRANSFERINFO_URL, params, certFile, certPassword);
    }

    public static String payBank(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(PAY_BANK_URL, params, certPath, certPassword);
    }

    public static String payBank(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(PAY_BANK_URL, params, certFile, certPassword);
    }

    public static String queryBank(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(QUERY_BANK_URL, params, certPath, certPassword);
    }

    public static String queryBank(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(QUERY_BANK_URL, params, certFile, certPassword);
    }

    public static String getPublicKey(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(GETPUBLICKEY_URL, params, certPath, certPassword);
    }

    public static String getPublicKey(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(GETPUBLICKEY_URL, params, certFile, certPassword);
    }

    public static String getCodeUrl(String appid, String mch_id, String product_id, String partnerKey, boolean isToShortUrl) {
        String result_code;
        String shortResult;
        Map<String, String> shortMap;
        String return_code;
        String url = "weixin://wxpay/bizpayurl?sign=XXXXX&appid=XXXXX&mch_id=XXXXX&product_id=XXXXX&time_stamp=XXXXX&nonce_str=XXXXX";
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        String nonceStr = Long.toString(System.currentTimeMillis());
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appid", appid);
        packageParams.put("mch_id", mch_id);
        packageParams.put("product_id", product_id);
        packageParams.put("time_stamp", timeStamp);
        packageParams.put("nonce_str", nonceStr);
        String packageSign = PaymentKit.createSign(packageParams, partnerKey);
        String qrCodeUrl = PaymentKit.replace(url, "XXXXX", packageSign, appid, mch_id, product_id, timeStamp, nonceStr);
        if (isToShortUrl && PaymentKit.codeIsOK(return_code = (shortMap = PaymentKit.xmlToMap(shortResult = WxPayApi.toShortUrl(PaymentKit.buildShortUrlParasMap(appid, null, mch_id, null, qrCodeUrl, partnerKey)))).get("return_code")) && PaymentKit.codeIsOK(result_code = shortMap.get("result_code"))) {
            qrCodeUrl = shortMap.get("short_url");
        }
        return qrCodeUrl;
    }

    public static String entrustweb(Map<String, String> params) {
        return WxPayApi.doGet(ENTRUSTWEB_URL, params);
    }

    public static String contractorder(Map<String, String> params) {
        return WxPayApi.doPost(CONTRACTORDER_URL, params);
    }

    public static String querycontract(Map<String, String> params) {
        return WxPayApi.doPost(QUERYCONTRACT_URL, params);
    }

    public static String pappayapply(Map<String, String> params) {
        return WxPayApi.doPost(PAPPAYAPPLY_URL, params);
    }

    public static String deletecontract(Map<String, String> params) {
        return WxPayApi.doPost(DELETECONTRACT_URL, params);
    }

    public static String contractbill(Map<String, String> params) {
        return WxPayApi.doPost(CONTRACTBILL_URL, params);
    }

    public static String paporderquery(Map<String, String> params) {
        return WxPayApi.doPost(PAPORDERQUERYL_URL, params);
    }

    public static String profitsharing(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(PROFITSHARING_URL, params, certPath, certPassword);
    }

    public static String profitsharing(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(PROFITSHARING_URL, params, certFile, certPassword);
    }

    public static String profitsharingquery(Map<String, String> params) {
        return WxPayApi.doPost(PROFITSHARINGQUERY_URL, params);
    }

    public static String profitsharingaddreceiver(Map<String, String> params) {
        return WxPayApi.doPost(PROFITSHARINGADDRECEIVER_URL, params);
    }

    public static String profitsharingremovereceiver(Map<String, String> params) {
        return WxPayApi.doPost(PROFITSHARINGREMOVERECEIVER_URL, params);
    }

    public static String profitsharingfinish(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(PROFITSHARINGFINISH_URL, params, certPath, certPassword);
    }

    public static String profitsharingfinish(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(PROFITSHARINGFINISH_URL, params, certFile, certPassword);
    }

    public static String sendCoupon(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(SEND_COUPON_URL, params, certPath, certPassword);
    }

    public static String sendCoupon(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(SEND_COUPON_URL, params, certFile, certPassword);
    }

    public static String queryCouponStock(Map<String, String> params) {
        return WxPayApi.doPost(QUERY_COUPON_STOCK_URL, params);
    }

    public static String queryCouponsInfo(Map<String, String> params) {
        return WxPayApi.doPost(QUERY_COUPONSINFO_URL, params);
    }

    public static String batchquerycomment(Map<String, String> params, String certPath, String certPassword) {
        return WxPayApi.doPostSSL(BATCH_QUERY_COMMENT_URL, params, certPath, certPassword);
    }

    public static String batchquerycomment(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(BATCH_QUERY_COMMENT_URL, params, certFile, certPassword);
    }

    public static String depositFacepay(Map<String, String> params) {
        return WxPayApi.doPost(DEPOSIT_FACEPAY_URL, params);
    }

    public static String depositMicropay(Map<String, String> params) {
        return WxPayApi.doPost(DEPOSIT_MICROPAY_URL, params);
    }

    public static String depositOrderQuery(Map<String, String> params) {
        return WxPayApi.doPost(DEPOSIT_ORDERQUERY_URL, params);
    }

    public static String depositReverse(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(DEPOSIT_REVERSE_URL, params, certFile, certPassword);
    }

    public static String depositConsume(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(DEPOSIT_CONSUME_URL, params, certFile, certPassword);
    }

    public static String depositRefund(Map<String, String> params, InputStream certFile, String certPassword) {
        return WxPayApi.doPostSSL(DEPOSIT_REFUND_URL, params, certFile, certPassword);
    }

    public static String depositRefundQuery(Map<String, String> params) {
        return WxPayApi.doPost(DEPOSIT_REFUNDQUERY_URL, params);
    }

    public static String doGet(String url, Map<String, String> params) {
        return HttpUtils.get(url, params);
    }

    public static String doPost(String url, Map<String, String> params) {
        return HttpUtils.post(url, PaymentKit.toXml(params));
    }

    public static String doPostSSL(String url, Map<String, String> params, String certPath, String certPass) {
        return HttpUtils.postSSL(url, PaymentKit.toXml(params), certPath, certPass);
    }

    public static String doPostSSL(String url, Map<String, String> params, InputStream certFile, String certPass) {
        return HttpUtils.postSSL(url, PaymentKit.toXml(params), certFile, certPass);
    }

    public static enum TradeType {
        JSAPI,
        NATIVE,
        APP,
        WAP,
        MICROPAY,
        MWEB,
        PAP;

    }
}

