/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.weixin.api;

import com.jpay.ext.kit.StrKit;
import com.jpay.weixin.api.WxPayApiConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WxPayApiConfigKit {
    private static final ThreadLocal<String> TL = new ThreadLocal();
    private static final Map<String, WxPayApiConfig> CFG_MAP = new ConcurrentHashMap<String, WxPayApiConfig>();
    private static final String DEFAULT_CFG_KEY = "_default_ijpay_key_";

    public static WxPayApiConfig putApiConfig(WxPayApiConfig wxPayApiConfig) {
        if (CFG_MAP.size() == 0) {
            CFG_MAP.put(DEFAULT_CFG_KEY, wxPayApiConfig);
        }
        return CFG_MAP.put(wxPayApiConfig.getAppId(), wxPayApiConfig);
    }

    public static WxPayApiConfig setThreadLocalWxPayApiConfig(WxPayApiConfig wxPayApiConfig) {
        return WxPayApiConfigKit.putApiConfig(wxPayApiConfig);
    }

    public static WxPayApiConfig removeApiConfig(WxPayApiConfig wxPayApiConfig) {
        return WxPayApiConfigKit.removeApiConfig(wxPayApiConfig.getAppId());
    }

    public static WxPayApiConfig removeApiConfig(String appId) {
        return CFG_MAP.remove(appId);
    }

    public static void setThreadLocalAppId(String appId) {
        if (StrKit.isBlank(appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        TL.set(appId);
    }

    public static void removeThreadLocalAppId() {
        TL.remove();
    }

    public static String getAppId() {
        String appId = TL.get();
        if (StrKit.isBlank(appId)) {
            appId = CFG_MAP.get(DEFAULT_CFG_KEY).getAppId();
        }
        return appId;
    }

    public static WxPayApiConfig getWxPayApiConfig() {
        String appId = WxPayApiConfigKit.getAppId();
        return WxPayApiConfigKit.getApiConfig(appId);
    }

    public static WxPayApiConfig getApiConfig(String appId) {
        WxPayApiConfig cfg = CFG_MAP.get(appId);
        if (cfg == null) {
            throw new IllegalStateException("\u9700\u4e8b\u5148\u8c03\u7528 WxPayApiConfigKit.putApiConfig(wxPayApiConfig) \u5c06 appId\u5bf9\u5e94\u7684 WxPayApiConfig \u5bf9\u8c61\u5b58\u5165\uff0c\u624d\u53ef\u4ee5\u4f7f\u7528 WxPayApiConfigKit.getWxPayApiConfig() \u7684\u7cfb\u5217\u65b9\u6cd5");
        }
        return cfg;
    }
}

