/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.github.jamm.MemoryMeterListener;

final class TreePrinter
implements MemoryMeterListener {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static MemoryMeterListener.Factory FACTORY = new MemoryMeterListener.Factory(){

        @Override
        public MemoryMeterListener newInstance() {
            return new TreePrinter();
        }
    };
    private Map<Object, ObjectInfo> mapping = new IdentityHashMap<Object, ObjectInfo>();
    private Object root;

    TreePrinter() {
    }

    @Override
    public void started(Object obj) {
        this.root = obj;
        this.mapping.put(obj, ObjectInfo.newRoot(obj.getClass()));
    }

    @Override
    public void fieldAdded(Object obj, String fieldName, Object fieldValue) {
        ObjectInfo field = new ObjectInfo(fieldName, fieldValue.getClass());
        ObjectInfo parent = this.mapping.get(obj);
        parent.addChild(field);
        this.mapping.put(fieldValue, field);
    }

    @Override
    public void objectMeasured(Object current, long size) {
        ObjectInfo field = this.mapping.get(current);
        field.size = size;
    }

    @Override
    public void objectCounted(Object current) {
    }

    @Override
    public void done(long size) {
        System.out.println(this.mapping.get(this.root).toString());
    }

    private static final class ObjectInfo {
        private static final String ROOT_NAME = "root";
        private final String name;
        private final String className;
        private final List<ObjectInfo> children = new ArrayList<ObjectInfo>();
        private long size;
        private long totalSize = -1L;

        public ObjectInfo(String name, Class<?> clazz) {
            this.name = name;
            this.className = ObjectInfo.className(clazz);
        }

        public static ObjectInfo newRoot(Class<?> clazz) {
            return new ObjectInfo(ROOT_NAME, clazz);
        }

        public void addChild(ObjectInfo child) {
            this.children.add(child);
        }

        public long totalSize() {
            if (this.totalSize < 0L) {
                this.totalSize = this.computeTotalSize();
            }
            return this.totalSize;
        }

        private long computeTotalSize() {
            long total = this.size;
            for (ObjectInfo child : this.children) {
                total += child.totalSize();
            }
            return total;
        }

        public String toString() {
            return this.append("", true, new StringBuilder().append(LINE_SEPARATOR).append(LINE_SEPARATOR)).toString();
        }

        private StringBuilder append(String indentation, boolean isLast, StringBuilder builder) {
            if (!this.name.equals(ROOT_NAME)) {
                builder.append(indentation).append('|').append(LINE_SEPARATOR).append(indentation).append("+--");
            }
            builder.append(this.name).append(" [").append(this.className).append("] ");
            if (this.size != 0L) {
                builder.append(this.totalSize()).append(" b (").append(this.size).append(" b)");
            }
            return this.appendChildren(ObjectInfo.childIntentation(indentation, isLast), builder.append(LINE_SEPARATOR));
        }

        private StringBuilder appendChildren(String indentation, StringBuilder builder) {
            int m = this.children.size();
            for (int i = 0; i < m; ++i) {
                ObjectInfo child = this.children.get(i);
                boolean isLast = i == m - 1;
                child.append(indentation, isLast, builder);
            }
            return builder;
        }

        private static String childIntentation(String indentation, boolean isLast) {
            return isLast ? indentation + "  " : indentation + "|  ";
        }

        private static String className(Class<? extends Object> clazz) {
            if (clazz.isArray()) {
                return clazz.getComponentType().getName() + "[]";
            }
            return clazz.getName();
        }
    }
}

