/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm.utils;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.github.jamm.VM;
import org.github.jamm.accessors.FieldAccessor;

public final class ByteBufferMeasurementUtils {
    private static final Field HB_FIELD = ByteBufferMeasurementUtils.getDeclaredField(ByteBuffer.class, "hb");
    private static final Field ATT_FIELD = ByteBufferMeasurementUtils.getDeclaredField(ByteBuffer.allocateDirect(0).getClass(), "att");

    public static int underlyingCapacity(ByteBuffer buffer, FieldAccessor accessor) {
        if (buffer.isDirect()) {
            ByteBuffer att;
            if (buffer.isReadOnly() && VM.isPreJava12JVM()) {
                buffer = (ByteBuffer)accessor.getFieldValue(buffer, ATT_FIELD);
            }
            return (att = (ByteBuffer)accessor.getFieldValue(buffer, ATT_FIELD)) == null ? buffer.capacity() : att.capacity();
        }
        if (buffer.isReadOnly()) {
            byte[] hb = (byte[])accessor.getFieldValue(buffer, HB_FIELD);
            return hb.length;
        }
        return buffer.array().length;
    }

    private static Field getDeclaredField(Class<?> cls, String fieldName) {
        try {
            return cls.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ByteBufferMeasurementUtils() {
    }
}

