/*
 * Decompiled with CFR 0.152.
 */
package info.bowkett.ddt;

import info.bowkett.ddt.Row;
import info.bowkett.ddt.SyntheticResultSetAnswer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.mockito.BDDMockito;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;

public class DDTFixture {
    private final ResultSet resultSet;
    private final Connection connection;
    private CallableStatement callableStatement;
    private Statement statement;
    private PreparedStatement preparedStatement;

    public DDTFixture(Connection connection, ResultSet resultSet, Statement statement) {
        this(connection, resultSet, (PreparedStatement)Mockito.mock(PreparedStatement.class), statement, (CallableStatement)Mockito.mock(CallableStatement.class));
    }

    public DDTFixture(Connection connection, ResultSet resultSet, PreparedStatement preparedStatement) {
        this(connection, resultSet, preparedStatement, (Statement)Mockito.mock(Statement.class), (CallableStatement)Mockito.mock(CallableStatement.class));
    }

    public DDTFixture(Connection connection, ResultSet resultSet, CallableStatement callableStatement) {
        this(connection, resultSet, (PreparedStatement)Mockito.mock(PreparedStatement.class), (Statement)Mockito.mock(Statement.class), callableStatement);
    }

    private DDTFixture(Connection connection, ResultSet resultSet, PreparedStatement preparedStatement, Statement statement, CallableStatement callableStatement) {
        this.connection = connection;
        this.resultSet = resultSet;
        this.preparedStatement = preparedStatement;
        this.statement = statement;
        this.callableStatement = callableStatement;
        this.wireInStatements();
    }

    public static DDTFixture forPreparedStatement(Connection connection) {
        return new DDTFixture(connection, (ResultSet)Mockito.mock(ResultSet.class), (PreparedStatement)Mockito.mock(PreparedStatement.class));
    }

    public static DDTFixture forStatement(Connection connection) {
        return new DDTFixture(connection, (ResultSet)Mockito.mock(ResultSet.class), (Statement)Mockito.mock(Statement.class));
    }

    public static DDTFixture forCallableStatement(Connection connection) {
        return new DDTFixture(connection, (ResultSet)Mockito.mock(ResultSet.class), (CallableStatement)Mockito.mock(CallableStatement.class));
    }

    private void wireInStatements() {
        try {
            this.wireInStatement(this.connection, this.resultSet, this.statement);
            this.wireInPreparedStatement(this.connection, this.resultSet, this.preparedStatement);
            this.wireInCallableStatement(this.connection, this.resultSet, this.callableStatement);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot wire in Statement.  Please report this as a bug.");
        }
    }

    private void wireInPreparedStatement(Connection connection, ResultSet resultSet, PreparedStatement preparedStatement) throws SQLException {
        PowerMockito.when((Object)connection.prepareStatement(Matchers.anyString())).thenReturn((Object)preparedStatement);
        PowerMockito.when((Object)connection.prepareStatement(Matchers.anyString(), Matchers.anyInt())).thenReturn((Object)preparedStatement);
        PowerMockito.when((Object)connection.prepareStatement(Matchers.anyString(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)preparedStatement);
        PowerMockito.when((Object)connection.prepareStatement(Matchers.anyString(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)preparedStatement);
        PowerMockito.when((Object)connection.prepareStatement(Matchers.anyString(), (int[])Matchers.any(new int[0].getClass()))).thenReturn((Object)preparedStatement);
        PowerMockito.when((Object)connection.prepareStatement(Matchers.anyString(), (String[])Matchers.any(new String[0].getClass()))).thenReturn((Object)preparedStatement);
        PowerMockito.when((Object)preparedStatement.executeQuery()).thenReturn((Object)resultSet);
        PowerMockito.when((Object)preparedStatement.executeQuery(Matchers.anyString())).thenReturn((Object)resultSet);
    }

    private void wireInStatement(Connection connection, ResultSet resultSet, Statement statement) throws SQLException {
        PowerMockito.when((Object)connection.createStatement()).thenReturn((Object)statement);
        PowerMockito.when((Object)connection.createStatement(Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)statement);
        PowerMockito.when((Object)connection.createStatement(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)statement);
        PowerMockito.when((Object)statement.executeQuery(Matchers.anyString())).thenReturn((Object)resultSet);
    }

    private void wireInCallableStatement(Connection connection, ResultSet resultSet, CallableStatement callableStatement) throws SQLException {
        PowerMockito.when((Object)connection.prepareCall(Matchers.anyString())).thenReturn((Object)callableStatement);
        PowerMockito.when((Object)connection.prepareCall(Matchers.anyString(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)callableStatement);
        PowerMockito.when((Object)connection.prepareCall(Matchers.anyString(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt())).thenReturn((Object)callableStatement);
        PowerMockito.when((Object)callableStatement.executeQuery()).thenReturn((Object)resultSet);
        PowerMockito.when((Object)callableStatement.executeQuery(Matchers.anyString())).thenReturn((Object)resultSet);
    }

    public void setResultSet(Row ... rows) throws SQLException {
        this.setResultSet(new HashMap<String, Integer>(), rows);
    }

    public void setResultSet(Map<String, Integer> columnMap, Row ... rows) throws SQLException {
        SyntheticResultSetAnswer answerFromResultSet = new SyntheticResultSetAnswer(columnMap, rows);
        this.wireInCommonInterceptedMethodsOnResultSet(answerFromResultSet);
        this.wireInNamedColumnInterceptedMethodsOnResultSet(answerFromResultSet);
    }

    private void wireInCommonInterceptedMethodsOnResultSet(Answer answerFromResultSet) throws SQLException {
        BDDMockito.given((Object)this.resultSet.next()).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getArray(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getAsciiStream(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBigDecimal(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBinaryStream(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBlob(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBoolean(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getByte(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBytes(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getCharacterStream(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getClob(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getDate(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getDate(Matchers.anyInt(), (Calendar)Matchers.any(Calendar.class))).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getDouble(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)Float.valueOf(this.resultSet.getFloat(Matchers.anyInt()))).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getInt(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getLong(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getNCharacterStream(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getNClob(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getNString(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getObject(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getObject(Matchers.anyInt(), Matchers.anyMap())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getRef(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getRowId(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getShort(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getSQLXML(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getString(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getTime(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getTime(Matchers.anyInt(), (Calendar)Matchers.any(Calendar.class))).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getTimestamp(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getTimestamp(Matchers.anyInt(), (Calendar)Matchers.any(Calendar.class))).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getURL(Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBigDecimal(Matchers.anyInt(), Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getUnicodeStream(Matchers.anyInt())).will(answerFromResultSet);
    }

    private void wireInNamedColumnInterceptedMethodsOnResultSet(Answer answerFromResultSet) throws SQLException {
        BDDMockito.given((Object)this.resultSet.getArray(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getAsciiStream(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBigDecimal(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBinaryStream(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBlob(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBoolean(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getByte(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBytes(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getCharacterStream(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getClob(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getDate(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getDate(Matchers.anyString(), (Calendar)Matchers.any(Calendar.class))).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getDouble(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)Float.valueOf(this.resultSet.getFloat(Matchers.anyString()))).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getInt(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getLong(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getNCharacterStream(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getNClob(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getNString(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getObject(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getObject(Matchers.anyString(), Matchers.anyMap())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getRef(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getRowId(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getShort(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getSQLXML(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getString(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getTime(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getTime(Matchers.anyString(), (Calendar)Matchers.any(Calendar.class))).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getTimestamp(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getTimestamp(Matchers.anyString(), (Calendar)Matchers.any(Calendar.class))).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getURL(Matchers.anyString())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getBigDecimal(Matchers.anyString(), Matchers.anyInt())).will(answerFromResultSet);
        BDDMockito.given((Object)this.resultSet.getUnicodeStream(Matchers.anyString())).will(answerFromResultSet);
    }
}

