/*
 * Decompiled with CFR 0.152.
 */
package info.bowkett.ddt;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class PreparedStatementSpy
implements PreparedStatement {
    private final PreparedStatement pstmt;
    private final String sql;
    private Map<Integer, Param> sqlIndexToParamMap = new ConcurrentHashMap<Integer, Param>();

    public PreparedStatementSpy(PreparedStatement pstmt, String sql) {
        this.pstmt = pstmt;
        this.sql = sql;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.pstmt.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.pstmt.executeUpdate();
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.pstmt.setNull(parameterIndex, sqlType);
        this.spy(parameterIndex, new NullParam());
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.pstmt.setBoolean(parameterIndex, x);
        this.spy(parameterIndex, new BooleanParam(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.pstmt.setByte(parameterIndex, x);
        this.spy(parameterIndex, new ByteParam(x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.pstmt.setShort(parameterIndex, x);
        this.spy(parameterIndex, new LongParam(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.pstmt.setInt(parameterIndex, x);
        this.spy(parameterIndex, new LongParam(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.pstmt.setLong(parameterIndex, x);
        this.spy(parameterIndex, new LongParam(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.pstmt.setFloat(parameterIndex, x);
        this.spy(parameterIndex, new DoubleParam(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.pstmt.setDouble(parameterIndex, x);
        this.spy(parameterIndex, new DoubleParam(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.pstmt.setBigDecimal(parameterIndex, x);
        this.spy(parameterIndex, new BigDecimalParam(x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.pstmt.setString(parameterIndex, x);
        this.spy(parameterIndex, new StringParam(x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.pstmt.setBytes(parameterIndex, x);
        this.spy(parameterIndex, new ByteArrayParam(x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.pstmt.setDate(parameterIndex, x);
        this.spy(parameterIndex, new DateParam(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.pstmt.setTime(parameterIndex, x);
        this.spy(parameterIndex, new DateParam(x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.pstmt.setTimestamp(parameterIndex, x);
        this.spy(parameterIndex, new DateParam(x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.pstmt.setAsciiStream(parameterIndex, x, length);
        this.spy(parameterIndex, new AsciiStreamParam());
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.pstmt.setUnicodeStream(parameterIndex, x, length);
        this.spy(parameterIndex, new UnicodeParam());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.pstmt.setBinaryStream(parameterIndex, x, length);
        this.spy(parameterIndex, new InputStreamParam());
    }

    @Override
    public void clearParameters() throws SQLException {
        this.pstmt.clearParameters();
        this.sqlIndexToParamMap.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.pstmt.setObject(parameterIndex, x, targetSqlType);
        this.spy(parameterIndex, new ObjectParam(x));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.pstmt.setObject(parameterIndex, x);
        this.spy(parameterIndex, new ObjectParam(x));
    }

    @Override
    public boolean execute() throws SQLException {
        boolean result = false;
        try {
            result = this.pstmt.execute();
            this.sqlIndexToParamMap.clear();
        }
        finally {
            return result;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.pstmt.addBatch();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.pstmt.setCharacterStream(parameterIndex, reader, length);
        this.spy(parameterIndex, new CharstreamParam());
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.pstmt.setRef(parameterIndex, x);
        this.spy(parameterIndex, new RefParam());
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.pstmt.setBlob(parameterIndex, x);
        this.spy(parameterIndex, new BlobParam());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.pstmt.setBlob(parameterIndex, inputStream);
        this.spy(parameterIndex, new BlobParam());
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.pstmt.setClob(parameterIndex, x);
        this.spy(parameterIndex, new ClobParam());
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.pstmt.setArray(parameterIndex, x);
        this.spy(parameterIndex, new ArrayParam(x));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.pstmt.getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.pstmt.setDate(parameterIndex, x, cal);
        this.spy(parameterIndex, new DateParam(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.pstmt.setTime(parameterIndex, x, cal);
        this.spy(parameterIndex, new DateParam(x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.pstmt.setTimestamp(parameterIndex, x, cal);
        this.spy(parameterIndex, new DateParam(x));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.pstmt.setNull(parameterIndex, sqlType, typeName);
        this.spy(parameterIndex, new NullParam());
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.pstmt.setURL(parameterIndex, x);
        this.spy(parameterIndex, new URLParam(x));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.pstmt.getParameterMetaData();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.pstmt.setRowId(parameterIndex, x);
        this.spy(parameterIndex, new RowIdParam());
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.pstmt.setNString(parameterIndex, value);
        this.spy(parameterIndex, new StringParam(value));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.pstmt.setNCharacterStream(parameterIndex, value, length);
        this.spy(parameterIndex, new NCharstreamParam());
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.pstmt.setNClob(parameterIndex, value);
        this.spy(parameterIndex, new NClobParam());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.pstmt.setClob(parameterIndex, reader, length);
        this.spy(parameterIndex, new ClobParam());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.pstmt.setClob(parameterIndex, reader);
        this.spy(parameterIndex, new ClobParam());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.pstmt.setBlob(parameterIndex, inputStream, length);
        this.spy(parameterIndex, new BlobParam());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.pstmt.setNClob(parameterIndex, reader, length);
        this.spy(parameterIndex, new NClobParam());
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.pstmt.setNClob(parameterIndex, reader);
        this.spy(parameterIndex, new NClobParam());
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.pstmt.setSQLXML(parameterIndex, xmlObject);
        this.spy(parameterIndex, new SQLXMLParam());
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.pstmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        this.spy(parameterIndex, new ObjectParam(x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.pstmt.setAsciiStream(parameterIndex, x, length);
        this.spy(parameterIndex, new AsciiStreamParam());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.pstmt.setBinaryStream(parameterIndex, x, length);
        this.spy(parameterIndex, new InputStreamParam());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.pstmt.setCharacterStream(parameterIndex, reader, length);
        this.spy(parameterIndex, new CharstreamParam());
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.pstmt.setAsciiStream(parameterIndex, x);
        this.spy(parameterIndex, new AsciiStreamParam());
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.pstmt.setBinaryStream(parameterIndex, x);
        this.spy(parameterIndex, new InputStreamParam());
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.pstmt.setCharacterStream(parameterIndex, reader);
        this.spy(parameterIndex, new CharstreamParam());
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.pstmt.setNCharacterStream(parameterIndex, value);
        this.spy(parameterIndex, new NCharstreamParam());
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.pstmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        this.spy(parameterIndex, new ObjectParam(x));
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.pstmt.setObject(parameterIndex, x, targetSqlType);
        this.spy(parameterIndex, new ObjectParam(x));
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.pstmt.executeLargeUpdate();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.pstmt.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.pstmt.isWrapperFor(iface);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.pstmt.executeQuery(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.pstmt.executeUpdate(sql);
    }

    @Override
    public void close() throws SQLException {
        this.pstmt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.pstmt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.pstmt.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.pstmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.pstmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.pstmt.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.pstmt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.pstmt.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.pstmt.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.pstmt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.pstmt.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.pstmt.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.pstmt.execute(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.pstmt.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.pstmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.pstmt.getMoreResults();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.pstmt.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.pstmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.pstmt.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.pstmt.setFetchSize(rows);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.pstmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.pstmt.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.pstmt.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.pstmt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.pstmt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.pstmt.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.pstmt.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.pstmt.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.pstmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.pstmt.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.pstmt.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.pstmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.pstmt.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.pstmt.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.pstmt.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.pstmt.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.pstmt.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.pstmt.setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.pstmt.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.pstmt.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.pstmt.getLargeUpdateCount();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.pstmt.getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.pstmt.setLargeMaxRows(max);
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.pstmt.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.pstmt.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.pstmt.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.pstmt.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.pstmt.executeLargeUpdate(sql, columnNames);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        char[] chars = this.sql.toCharArray();
        int sqlParamIndex = 1;
        for (char theChar : chars) {
            if (theChar == '?') {
                Param param = this.getParamAt(sqlParamIndex);
                buffer.append(param.toSqlValue());
                ++sqlParamIndex;
                continue;
            }
            buffer.append(theChar);
        }
        return buffer.toString();
    }

    private Param getParamAt(int sqlParamIndex) {
        return this.sqlIndexToParamMap.getOrDefault(sqlParamIndex, new UnsetParam());
    }

    private void spy(int sqlIndex, Param param) {
        this.sqlIndexToParamMap.put(sqlIndex, param);
    }

    private static class ObjectParam
    implements Param {
        private final Object param;

        public ObjectParam(Object param) {
            this.param = param;
        }

        @Override
        public String toSqlValue() {
            return '\'' + this.param.toString() + '\'';
        }
    }

    private static class UnicodeParam
    implements Param {
        private UnicodeParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Unicode_>";
        }
    }

    private static class URLParam
    implements Param {
        private final URL x;

        public URLParam(URL x) {
            this.x = x;
        }

        @Override
        public String toSqlValue() {
            return '\'' + this.x.toString() + '\'';
        }
    }

    private static class SQLXMLParam
    implements Param {
        private SQLXMLParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_SQLXML_>";
        }
    }

    private static class RowIdParam
    implements Param {
        private RowIdParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_RowId_>";
        }
    }

    private static class RefParam
    implements Param {
        private RefParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Ref_>";
        }
    }

    private static class NullParam
    implements Param {
        private NullParam() {
        }

        @Override
        public String toSqlValue() {
            return "NULL";
        }
    }

    private static class NClobParam
    implements Param {
        private NClobParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Nclob_>";
        }
    }

    private static class NCharstreamParam
    implements Param {
        private NCharstreamParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Nchar_>";
        }
    }

    private static class LongParam
    implements Param {
        private final long param;

        public LongParam(long param) {
            this.param = param;
        }

        @Override
        public String toSqlValue() {
            return String.format("%1$d", this.param);
        }
    }

    private static class DoubleParam
    implements Param {
        private final double x;

        public DoubleParam(double x) {
            this.x = x;
        }

        @Override
        public String toSqlValue() {
            return String.format("%1$.5f", this.x);
        }
    }

    private static class DateParam
    implements Param {
        private final java.util.Date x;

        public DateParam(java.util.Date x) {
            this.x = x;
        }

        @Override
        public String toSqlValue() {
            return String.format("'%1$tY-%1$tm-%1$te %1$tH:%1tM:%1$tS'", this.x);
        }
    }

    private static class ClobParam
    implements Param {
        private ClobParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Clob_>";
        }
    }

    private static class CharstreamParam
    implements Param {
        private CharstreamParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Char_>";
        }
    }

    private static class ByteArrayParam
    implements Param {
        private final Byte[] x;

        public ByteArrayParam(byte[] x) {
            this.x = new Byte[x.length];
            for (int i = 0; i < x.length; ++i) {
                this.x[i] = x[i];
            }
        }

        @Override
        public String toSqlValue() {
            return '[' + Arrays.stream(this.x).map(ByteParam::new).map(ByteParam::toSqlValue).collect(Collectors.joining(", ")) + ']';
        }
    }

    private static class ByteParam
    implements Param {
        private final Byte x;

        public ByteParam(Byte x) {
            this.x = x;
        }

        @Override
        public String toSqlValue() {
            return "0x" + Integer.toHexString(this.x.byteValue());
        }
    }

    private static class BooleanParam
    implements Param {
        private final boolean value;

        public BooleanParam(boolean x) {
            this.value = x;
        }

        @Override
        public String toSqlValue() {
            return this.value + "";
        }
    }

    private static class BlobParam
    implements Param {
        private BlobParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Blob_>";
        }
    }

    private static class BigDecimalParam
    implements Param {
        private final BigDecimal param;

        public BigDecimalParam(BigDecimal param) {
            this.param = param;
        }

        @Override
        public String toSqlValue() {
            return this.param.toString();
        }
    }

    private static class ArrayParam
    implements Param {
        private final Array value;

        public ArrayParam(Array value) {
            this.value = value;
        }

        @Override
        public String toSqlValue() {
            try {
                Object[] array = (Object[])this.value.getArray();
                return '[' + Arrays.stream(array).map(ObjectParam::new).map(ObjectParam::toSqlValue).collect(Collectors.joining(", ")) + ']';
            }
            catch (SQLException e) {
                e.printStackTrace();
                return "[]";
            }
        }
    }

    private static class InputStreamParam
    implements Param {
        private InputStreamParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Binary_>";
        }
    }

    private static class AsciiStreamParam
    implements Param {
        private AsciiStreamParam() {
        }

        @Override
        public String toSqlValue() {
            return "<_Ascii_>";
        }
    }

    private static class StringParam
    implements Param {
        private final String value;

        public StringParam(String value) {
            this.value = value;
        }

        @Override
        public String toSqlValue() {
            return "'" + this.value + "'";
        }
    }

    private static class UnsetParam
    implements Param {
        private UnsetParam() {
        }

        @Override
        public String toSqlValue() {
            return "?";
        }
    }

    private static interface Param {
        public String toSqlValue();
    }
}

