/*
 * Decompiled with CFR 0.152.
 */
package info.bowkett.ddt;

import java.sql.SQLException;
import java.util.Arrays;

public class Row {
    private Object[] values;

    public Row(Object ... values) {
        this.values = values;
    }

    public Object getValue(int jdbcResultColumnIndex) throws SQLException {
        int arrayIndex = jdbcResultColumnIndex - 1;
        this.throwIfNotInBounds(arrayIndex);
        return this.values[arrayIndex];
    }

    private void throwIfNotInBounds(int arrayIndex) throws SQLException {
        if (arrayIndex < 0 || arrayIndex >= this.values.length) {
            throw new SQLException("Invalid column index.  (Valid value for getValue are 1 through to " + this.values.length + " Inclusive.)");
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Row otherRow = (Row)other;
        return Arrays.equals(this.values, otherRow.values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Row[");
        sb.append(Arrays.toString(this.values)).append(']');
        return sb.toString();
    }
}

