/*
 * Decompiled with CFR 0.152.
 */
package info.bowkett.ddt;

import info.bowkett.ddt.Row;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class SyntheticResultSetAnswer
implements Answer {
    private final Map<String, Integer> columnMap;
    private final Row[] rows;
    private int index = -1;
    private Row row = null;

    public SyntheticResultSetAnswer(Row[] rows) {
        this(new HashMap<String, Integer>(), rows);
    }

    public SyntheticResultSetAnswer(Map<String, Integer> columnMap, Row[] rows) {
        this.columnMap = columnMap;
        this.rows = rows;
    }

    public Object answer(InvocationOnMock invocation) throws SQLException {
        String methodName = invocation.getMethod().getName();
        Object[] arguments = invocation.getArguments();
        return this.answer(methodName, arguments);
    }

    Object answer(String methodName, Object ... arguments) throws SQLException {
        if (methodName.equals("next")) {
            return this.moveNext();
        }
        this.throwIfNextWasNotCalled();
        return this.valueForRow(arguments[0]);
    }

    private Object valueForRow(Object argument) throws SQLException {
        boolean isGetterCallWithColumnIndexArgument = argument instanceof Integer;
        int index = isGetterCallWithColumnIndexArgument ? ((Integer)argument).intValue() : this.handleGetterCallWithColumnNameArgument((String)argument);
        return this.row.getValue(index);
    }

    private int handleGetterCallWithColumnNameArgument(String argument) throws SQLException {
        Integer jdbcIndex = this.columnMap.get(argument);
        if (jdbcIndex == null) {
            throw new SQLException("Unknown named column : [" + argument + "]");
        }
        return jdbcIndex;
    }

    private Object moveNext() {
        ++this.index;
        boolean hasNext = this.index < this.rows.length;
        this.row = hasNext ? this.rows[this.index] : null;
        return hasNext;
    }

    private void throwIfNextWasNotCalled() throws SQLException {
        if (this.row == null) {
            throw new SQLException("Invalid state (must call next before iterating ResultSet)");
        }
    }
}

