/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.kafka;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.RandomUtil;
import com.github.jchanghong.kafka.OffsetReset;
import com.github.jchanghong.log.KStaticLogKt;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u00002\u00020\u0001BY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012&\b\u0002\u0010\u0007\u001a \u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ$\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\u00032\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204H\u0007J\u000e\u00105\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0003J\u001c\u00106\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u00107\u001a\u0004\u0018\u0001082\u0006\u00100\u001a\u00020\u0003J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00030:J\"\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\n\b\u0002\u0010>\u001a\u0004\u0018\u00010\u0003J\u0006\u0010?\u001a\u00020\nR/\u0010\u0007\u001a \u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R'\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001b\u0010\u001cR'\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0015\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0015\u001a\u0004\b%\u0010&R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\n ,*\u0004\u0018\u00010+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u0006@"}, d2={"Lcom/github/jchanghong/kafka/KafkaHelper;", "", "bootstrap", "", "groupId", "topics", "", "action", "Ljava/util/function/Function;", "Lorg/apache/kafka/clients/consumer/ConsumerRecord;", "", "offsetReset", "Lcom/github/jchanghong/kafka/OffsetReset;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/function/Function;Lcom/github/jchanghong/kafka/OffsetReset;)V", "getAction", "()Ljava/util/function/Function;", "adminClient", "Lorg/apache/kafka/clients/admin/AdminClient;", "getAdminClient", "()Lorg/apache/kafka/clients/admin/AdminClient;", "adminClient$delegate", "Lkotlin/Lazy;", "getBootstrap", "()Ljava/lang/String;", "getGroupId", "mConsumer", "Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "getMConsumer", "()Lorg/apache/kafka/clients/consumer/KafkaConsumer;", "mConsumer$delegate", "mProducer", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "getMProducer", "()Lorg/apache/kafka/clients/producer/KafkaProducer;", "mProducer$delegate", "mProps", "Ljava/util/Properties;", "getMProps", "()Ljava/util/Properties;", "mProps$delegate", "getOffsetReset", "()Lcom/github/jchanghong/kafka/OffsetReset;", "singleThreadExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getTopics", "()Ljava/util/List;", "createTopic", "name", "p", "", "r", "", "deleteTopic", "getAndSetProps", "getTopic", "Lorg/apache/kafka/clients/admin/TopicDescription;", "listAllTopic", "", "produce", "topic", "value", "key", "startConsumer", "kotlin-lib"})
public final class KafkaHelper {
    private final ExecutorService singleThreadExecutor;
    private final Lazy mProps$delegate;
    private final Lazy mProducer$delegate;
    private final Lazy mConsumer$delegate;
    private final Lazy adminClient$delegate;
    @NotNull
    private final String bootstrap;
    @NotNull
    private final String groupId;
    @Nullable
    private final List<String> topics;
    @Nullable
    private final Function<ConsumerRecord<String, String>, Unit> action;
    @NotNull
    private final OffsetReset offsetReset;

    private final Properties getMProps() {
        Lazy lazy = this.mProps$delegate;
        KafkaHelper kafkaHelper2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Properties)lazy.getValue();
    }

    private final KafkaProducer<String, String> getMProducer() {
        Lazy lazy = this.mProducer$delegate;
        KafkaHelper kafkaHelper2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (KafkaProducer)lazy.getValue();
    }

    private final KafkaConsumer<String, String> getMConsumer() {
        Lazy lazy = this.mConsumer$delegate;
        KafkaHelper kafkaHelper2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (KafkaConsumer)lazy.getValue();
    }

    private final AdminClient getAdminClient() {
        Lazy lazy = this.adminClient$delegate;
        KafkaHelper kafkaHelper2 = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AdminClient)lazy.getValue();
    }

    private final Properties getAndSetProps(String bootstrap, String groupId) {
        Properties props = new Properties();
        ((Map)props).put("bootstrap.servers", bootstrap);
        props.put("batch.size", (Object)16384);
        props.put("acks", "1");
        CharSequence charSequence = groupId;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            props.setProperty("group.id", groupId);
        }
        props.setProperty("enable.auto.commit", "true");
        props.setProperty("auto.offset.reset", this.offsetReset.name());
        props.setProperty("auto.commit.interval.ms", "1000");
        props.setProperty("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        props.setProperty("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        ((Map)props).put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        ((Map)props).put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return props;
    }

    static /* synthetic */ Properties getAndSetProps$default(KafkaHelper kafkaHelper2, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return kafkaHelper2.getAndSetProps(string, string2);
    }

    @JvmOverloads
    public final void createTopic(@NotNull String name, int p, short r) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NewTopic newTopic = new NewTopic(name, p, r);
        Collection newTopicList = new ArrayList();
        newTopicList.add(newTopic);
        CreateTopicsResult createTopicsResult = this.getAdminClient().createTopics(newTopicList);
        Map map = createTopicsResult.values();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createTopicsResult.values()");
        Map map2 = map;
        boolean bl = false;
        for (Map.Entry entry : map2.entrySet()) {
            try {
                ((KafkaFuture)entry.getValue()).get();
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                KStaticLogKt.kError(e.getMessage(), e, new Object[0]);
            }
            KStaticLogKt.kInfo("createTopic " + (String)entry.getKey(), new Object[0]);
        }
    }

    public static /* synthetic */ void createTopic$default(KafkaHelper kafkaHelper2, String string, int n, short s2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 8;
        }
        if ((n2 & 4) != 0) {
            s2 = 1;
        }
        kafkaHelper2.createTopic(string, n, s2);
    }

    @JvmOverloads
    public final void createTopic(@NotNull String name, int p) {
        KafkaHelper.createTopic$default(this, name, p, (short)0, 4, null);
    }

    @JvmOverloads
    public final void createTopic(@NotNull String name) {
        KafkaHelper.createTopic$default(this, name, 0, (short)0, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteTopic(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DeleteTopicsResult deleteTopicsResult = this.getAdminClient().deleteTopics((Collection)Arrays.asList(name));
        Map map = deleteTopicsResult.values();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"deleteTopicsResult.values()");
        Object object = map;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void k;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            KafkaFuture v = (KafkaFuture)entry2.getValue();
            try {
                v.get();
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                KStaticLogKt.kError(e.getMessage(), e, new Object[0]);
            }
            KStaticLogKt.kInfo("deleteTopic " + (String)k, new Object[0]);
        }
    }

    @NotNull
    public final Set<String> listAllTopic() {
        ListTopicsResult listTopicsResult = this.getAdminClient().listTopics();
        Intrinsics.checkNotNullExpressionValue((Object)listTopicsResult, (String)"adminClient.listTopics()");
        ListTopicsResult result = listTopicsResult;
        KafkaFuture names = result.names();
        try {
            Object object = names.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"names.get()");
            return (Set)object;
        }
        catch (InterruptedException e) {
            KStaticLogKt.kError(e.getMessage(), e, new Object[0]);
        }
        catch (ExecutionException e) {
            KStaticLogKt.kError(e.getMessage(), e, new Object[0]);
        }
        return SetsKt.emptySet();
    }

    @Nullable
    public final TopicDescription getTopic(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DescribeTopicsResult describeTopicsResult = this.getAdminClient().describeTopics((Collection)Arrays.asList(name));
        Intrinsics.checkNotNullExpressionValue((Object)describeTopicsResult, (String)"adminClient.describeTopics(Arrays.asList(name))");
        DescribeTopicsResult describeTopics = describeTopicsResult;
        Collection values = describeTopics.values().values();
        if (values.isEmpty()) {
            KStaticLogKt.kInfo("\u627e\u4e0d\u5230\u63cf\u8ff0\u4fe1\u606f", new Object[0]);
        } else {
            Iterator iterator = values.iterator();
            if (iterator.hasNext()) {
                KafkaFuture value = (KafkaFuture)iterator.next();
                return (TopicDescription)value.get();
            }
        }
        return null;
    }

    public final void produce(@NotNull String topic, @NotNull String value, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        KafkaProducer<String, String> kafkaProducer = this.getMProducer();
        String string = key;
        if (string == null) {
            string = System.nanoTime() + RandomUtil.randomString((int)20);
        }
        kafkaProducer.send(new ProducerRecord(topic, (Object)string, (Object)value));
    }

    public static /* synthetic */ void produce$default(KafkaHelper kafkaHelper2, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        kafkaHelper2.produce(string, string2, string3);
    }

    public final void startConsumer() {
        Object object = this.topics;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        object = this.action;
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (object == null) {
            boolean bl5 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Method method = ClassUtil.getDeclaredMethod(KafkaConsumer.class, (String)"subscribe", (Class[])new Class[]{List.class});
        Method pollMethod = ClassUtil.getDeclaredMethod(KafkaConsumer.class, (String)"poll", (Class[])new Class[]{Duration.class});
        if (method != null) {
            method.invoke(this.getMConsumer(), this.topics);
            this.singleThreadExecutor.execute(new Runnable(this, pollMethod){
                final /* synthetic */ KafkaHelper this$0;
                final /* synthetic */ Method $pollMethod;

                /*
                 * Unable to fully structure code
                 */
                public final void run() {
                    block0: while (true) {
                        v0 = poll = this.$pollMethod != null ? KafkaHelper.access$getMConsumer$p(this.this$0).poll(Duration.ofMillis(100L)) : KafkaHelper.access$getMConsumer$p(this.this$0).poll(0L);
                        if (poll == null) {
                            continue;
                        }
                        $this$forEach$iv = (Iterable)records;
                        $i$f$forEach = false;
                        var5_5 = $this$forEach$iv.iterator();
                        while (true) {
                            if (var5_5.hasNext()) ** break;
                            continue block0;
                            element$iv = var5_5.next();
                            it = (ConsumerRecord)element$iv;
                            $i$a$-forEach-KafkaHelper$startConsumer$1$1 = false;
                            this.this$0.getAction().apply((ConsumerRecord<String, String>)it);
                        }
                        break;
                    }
                }
                {
                    this.this$0 = kafkaHelper2;
                    this.$pollMethod = method;
                }
            });
        }
    }

    @NotNull
    public final String getBootstrap() {
        return this.bootstrap;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public final List<String> getTopics() {
        return this.topics;
    }

    @Nullable
    public final Function<ConsumerRecord<String, String>, Unit> getAction() {
        return this.action;
    }

    @NotNull
    public final OffsetReset getOffsetReset() {
        return this.offsetReset;
    }

    public KafkaHelper(@NotNull String bootstrap, @NotNull String groupId, @Nullable List<String> topics, @Nullable Function<ConsumerRecord<String, String>, Unit> action, @NotNull OffsetReset offsetReset) {
        Intrinsics.checkNotNullParameter((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)((Object)offsetReset), (String)"offsetReset");
        this.bootstrap = bootstrap;
        this.groupId = groupId;
        this.topics = topics;
        this.action = action;
        this.offsetReset = offsetReset;
        this.singleThreadExecutor = Executors.newSingleThreadExecutor();
        this.mProps$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Properties>(this){
            final /* synthetic */ KafkaHelper this$0;

            @NotNull
            public final Properties invoke() {
                return KafkaHelper.access$getAndSetProps(this.this$0, this.this$0.getBootstrap(), this.this$0.getGroupId());
            }
            {
                this.this$0 = kafkaHelper2;
                super(0);
            }
        }));
        this.mProducer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KafkaProducer<String, String>>(this){
            final /* synthetic */ KafkaHelper this$0;

            @NotNull
            public final KafkaProducer<String, String> invoke() {
                return new KafkaProducer(KafkaHelper.access$getMProps$p(this.this$0));
            }
            {
                this.this$0 = kafkaHelper2;
                super(0);
            }
        }));
        this.mConsumer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KafkaConsumer<String, String>>(this){
            final /* synthetic */ KafkaHelper this$0;

            @NotNull
            public final KafkaConsumer<String, String> invoke() {
                return new KafkaConsumer(KafkaHelper.access$getMProps$p(this.this$0));
            }
            {
                this.this$0 = kafkaHelper2;
                super(0);
            }
        }));
        this.adminClient$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AdminClient>(this){
            final /* synthetic */ KafkaHelper this$0;

            public final AdminClient invoke() {
                return KafkaAdminClient.create((Properties)KafkaHelper.access$getMProps$p(this.this$0));
            }
            {
                this.this$0 = kafkaHelper2;
                super(0);
            }
        }));
    }

    public /* synthetic */ KafkaHelper(String string, String string2, List list, Function function, OffsetReset offsetReset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            function = null;
        }
        if ((n & 0x10) != 0) {
            offsetReset = OffsetReset.latest;
        }
        this(string, string2, list, function, offsetReset);
    }

    public static final /* synthetic */ KafkaConsumer access$getMConsumer$p(KafkaHelper $this) {
        return $this.getMConsumer();
    }

    public static final /* synthetic */ Properties access$getAndSetProps(KafkaHelper $this, String bootstrap, String groupId) {
        return $this.getAndSetProps(bootstrap, groupId);
    }

    public static final /* synthetic */ Properties access$getMProps$p(KafkaHelper $this) {
        return $this.getMProps();
    }
}

