package com.github.jchanghong.redis

import io.lettuce.core.RedisClient
import io.lettuce.core.RedisURI
import io.lettuce.core.api.async.RedisAsyncCommands
import io.lettuce.core.api.sync.RedisCommands

val json = """
    {
        "okNtp": 0,
        "channelNtpAt": "",
        "recordPercentage": 0,
        "okStatus": 0,
        "okRecord": 0,
        "recordLength": 0,
        "indexCode": "",
        "okQuality": 0,
        "recordLists": [
            {
                "length": 0,
                "hour": 0,
                "percentage": 0
            }
        ],
        "channelNtpImgUrl": "",
        "channelCapatureAt": ""
    }
""".trimIndent().replace("""\s+""".toRegex(), "")

fun main() {
    println(json)

}

/** 一个对象对应一个redis服务器*/
class RedisHelper(ip: String, port: Int = 6379,password:String?=null) {
    private val redisClient by lazy {
        val builder = RedisURI.builder().withHost(ip)
            .withPort(port)
        if (!password.isNullOrBlank()) builder.withPassword(password)
        RedisClient.create(builder.build())
    }
    private val connect = redisClient.connect()
    val redisCommands: RedisCommands<String, String> = connect.sync()
    val asyncCommands: RedisAsyncCommands<String, String> = connect.async()
    fun close() {
        connect.close()
        redisClient.shutdown()
    }
}