/*
 * Decompiled with CFR 0.152.
 */
package com.github.jchanghong.gson;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import com.github.jchanghong.kotlin.DatesKt;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0003B\u0011\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0014\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/github/jchanghong/gson/DateDeserializer2;", "Lcom/fasterxml/jackson/datatype/jsr310/deser/JSR310DateTimeDeserializerBase;", "Ljava/util/Date;", "()V", "formatter", "Ljava/time/format/DateTimeFormatter;", "(Ljava/time/format/DateTimeFormatter;)V", "base", "leniency", "", "(Lcom/github/jchanghong/gson/DateDeserializer2;Ljava/lang/Boolean;)V", "deserialize", "parser", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "withDateFormat", "withLeniency", "withShape", "shape", "Lcom/fasterxml/jackson/annotation/JsonFormat$Shape;", "Companion", "kotlin-lib"})
public final class DateDeserializer2
extends JSR310DateTimeDeserializerBase<Date> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
    @NotNull
    private static final DateDeserializer2 INSTANCE = new DateDeserializer2();

    private DateDeserializer2() {
        this(DEFAULT_FORMATTER);
    }

    public DateDeserializer2(@Nullable DateTimeFormatter formatter) {
        super(Date.class, formatter);
    }

    protected DateDeserializer2(@Nullable DateDeserializer2 base, @Nullable Boolean leniency) {
        super((JSR310DateTimeDeserializerBase)base, leniency);
    }

    @NotNull
    protected DateDeserializer2 withDateFormat(@NotNull DateTimeFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        return new DateDeserializer2(formatter);
    }

    @NotNull
    protected DateDeserializer2 withLeniency(boolean leniency) {
        return new DateDeserializer2(this, leniency);
    }

    @NotNull
    protected DateDeserializer2 withShape(@NotNull JsonFormat.Shape shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        return this;
    }

    @Nullable
    public Date deserialize(@NotNull JsonParser parser, @NotNull DeserializationContext context) throws IOException {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_NUMBER_INT) {
            return new Date(parser.getLongValue());
        }
        String toString = parser.getValueAsString();
        Date toLocalDateTime = DatesKt.toDateJdk7OrNull(toString);
        if (toLocalDateTime != null) {
            return toLocalDateTime;
        }
        if (parser.hasTokenId(6)) {
            Object object;
            String string = parser.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parser.text");
            Object $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            $this$trim$iv = string2;
            $i$f$trim = false;
            if ($this$trim$iv.length() == 0) {
                if (!this.isLenient()) {
                    $this$trim$iv = (Date)this._failForNotLenient(parser, context, JsonToken.VALUE_STRING);
                    Intrinsics.checkNotNull((Object)$this$trim$iv);
                    object = $this$trim$iv;
                } else {
                    object = null;
                }
            } else {
                try {
                    if (Intrinsics.areEqual((Object)this._formatter, (Object)DEFAULT_FORMATTER) && string2.length() > 10 && string2.charAt(10) == 'T') {
                        return StringsKt.endsWith$default((String)string2, (String)"Z", (boolean)false, (int)2, null) ? (($this$trim$iv = LocalDateTime.ofInstant(Instant.parse(string2), ZoneOffset.UTC)) == null ? null : DatesKt.toDateOrNow((LocalDateTime)$this$trim$iv)) : (($this$trim$iv = LocalDateTime.parse(string2, DEFAULT_FORMATTER)) == null ? null : DatesKt.toDateOrNow((LocalDateTime)$this$trim$iv));
                    }
                    $this$trim$iv = LocalDateTime.parse(string2, this._formatter);
                    $this$trim$iv = $this$trim$iv == null ? null : DatesKt.toDateOrNow((LocalDateTime)$this$trim$iv);
                }
                catch (DateTimeException e) {
                    $this$trim$iv = (Date)this._handleDateTimeException(context, e, string2);
                }
                object = $this$trim$iv;
            }
            return object;
        }
        if (parser.isExpectedStartArrayToken()) {
            JsonToken t = parser.nextToken();
            if (t == JsonToken.END_ARRAY) {
                return null;
            }
            if ((t == JsonToken.VALUE_STRING || t == JsonToken.VALUE_EMBEDDED_OBJECT) && context.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                Date parsed = this.deserialize(parser, context);
                if (parser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(parser, context);
                }
                return parsed;
            }
            if (t == JsonToken.VALUE_NUMBER_INT) {
                LocalDateTime result = null;
                int year = parser.getIntValue();
                int month = parser.nextIntValue(-1);
                int day = parser.nextIntValue(-1);
                int hour = parser.nextIntValue(-1);
                int minute = parser.nextIntValue(-1);
                t = parser.nextToken();
                if (t == JsonToken.END_ARRAY) {
                    LocalDateTime startFound$iv$iv = LocalDateTime.of(year, month, day, hour, minute);
                    Intrinsics.checkNotNullExpressionValue((Object)startFound$iv$iv, (String)"of(year, month, day, hour, minute)");
                    result = startFound$iv$iv;
                } else {
                    int second = parser.getIntValue();
                    t = parser.nextToken();
                    if (t == JsonToken.END_ARRAY) {
                        LocalDateTime index$iv$iv = LocalDateTime.of(year, month, day, hour, minute, second);
                        Intrinsics.checkNotNullExpressionValue((Object)index$iv$iv, (String)"of(year, month, day, hour, minute, second)");
                        result = index$iv$iv;
                    } else {
                        int partialSecond = parser.getIntValue();
                        if (partialSecond < 1000 && !context.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            partialSecond *= 1000000;
                        }
                        if (parser.nextToken() != JsonToken.END_ARRAY) {
                            JsonMappingException jsonMappingException = context.wrongTokenException(parser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
                            Intrinsics.checkNotNullExpressionValue((Object)jsonMappingException, (String)"context.wrongTokenException(\n                                    parser, handledType(), JsonToken.END_ARRAY,\n                                    \"Expected array to end\"\n                            )");
                            throw (Throwable)jsonMappingException;
                        }
                        LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, second, partialSecond);
                        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(year, month, day, hour, minute, second, partialSecond)");
                        result = localDateTime;
                    }
                }
                LocalDateTime localDateTime = result;
                return DatesKt.toDateOrNow(localDateTime);
            }
            objectArray = new Object[]{t};
            context.reportInputMismatch(this.handledType(), "Unexpected token (%s) within Array, expected VALUE_NUMBER_INT", objectArray);
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            objectArray = parser.getEmbeddedObject();
            LocalDateTime localDateTime = objectArray instanceof LocalDateTime ? (LocalDateTime)objectArray : null;
            return localDateTime == null ? null : DatesKt.toDateOrNow(localDateTime);
        }
        if (parser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            this._throwNoNumericTimestampNeedTimeZone(parser, context);
        }
        return (Date)this._handleUnexpectedToken(context, parser, "Expected array or string.", new Object[0]);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/jchanghong/gson/DateDeserializer2$Companion;", "", "()V", "DEFAULT_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "INSTANCE", "Lcom/github/jchanghong/gson/DateDeserializer2;", "getINSTANCE", "()Lcom/github/jchanghong/gson/DateDeserializer2;", "serialVersionUID", "", "kotlin-lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateDeserializer2 getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

